/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContextControllerHashedGetterHashMultiple
implements EventPropertyGetter {
    private static final Log log = LogFactory.getLog(ContextControllerHashedGetterHashMultiple.class);
    private final ExprEvaluator[] evaluators;
    private final int granularity;

    public ContextControllerHashedGetterHashMultiple(List<ExprNode> nodes, int granularity) {
        this.evaluators = new ExprEvaluator[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            this.evaluators[i] = nodes.get(i).getExprEvaluator();
        }
        this.granularity = granularity;
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        EventBean[] events = new EventBean[]{eventBean};
        int hashCode = 0;
        for (int i = 0; i < this.evaluators.length; ++i) {
            Object result = this.evaluators[i].evaluate(events, true, null);
            if (result == null) continue;
            hashCode = hashCode == 0 ? result.hashCode() : 31 * hashCode + result.hashCode();
        }
        if (hashCode >= 0) {
            return hashCode % this.granularity;
        }
        return -hashCode % this.granularity;
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return false;
    }

    @Override
    public Object getFragment(EventBean eventBean) throws PropertyAccessException {
        return null;
    }
}

