/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.core.context.mgr.ContextPartitionIdManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ContextPartitionIdManagerImpl
implements ContextPartitionIdManager {
    private final Set<Integer> cpids = new HashSet<Integer>();
    private int lastAssignedId = -1;

    @Override
    public void clear() {
        this.cpids.clear();
    }

    @Override
    public void addExisting(int contextPartitionId) {
        this.cpids.add(contextPartitionId);
    }

    @Override
    public int allocateId() {
        do {
            if (this.lastAssignedId < Integer.MAX_VALUE) {
                ++this.lastAssignedId;
                continue;
            }
            this.lastAssignedId = 0;
        } while (this.cpids.contains(this.lastAssignedId));
        this.cpids.add(this.lastAssignedId);
        return this.lastAssignedId;
    }

    @Override
    public void removeId(int contextPartitionId) {
        this.cpids.remove(contextPartitionId);
    }

    @Override
    public Collection<Integer> getIds() {
        return this.cpids;
    }
}

