/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.util;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.hook.ExceptionHandlerExceptionType;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryResult;
import com.espertech.esper.core.context.factory.StatementAgentInstancePreload;
import com.espertech.esper.core.context.mgr.AgentInstance;
import com.espertech.esper.core.context.mgr.AgentInstanceFilterProxy;
import com.espertech.esper.core.context.mgr.ContextControllerStatementBase;
import com.espertech.esper.core.context.mgr.ContextControllerTreeAgentInstanceList;
import com.espertech.esper.core.context.stmt.AIRegistryAggregation;
import com.espertech.esper.core.context.stmt.AIRegistryExpr;
import com.espertech.esper.core.context.subselect.SubSelectStrategyHolder;
import com.espertech.esper.core.context.util.AgentInstanceComparator;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.StatementAgentInstanceFilterVersion;
import com.espertech.esper.core.service.StatementAgentInstanceLock;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.resource.StatementResourceHolder;
import com.espertech.esper.core.start.EPStatementStopMethodImpl;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.prev.ExprPreviousEvalStrategy;
import com.espertech.esper.epl.expression.prev.ExprPreviousNode;
import com.espertech.esper.epl.expression.prior.ExprPriorEvalStrategy;
import com.espertech.esper.epl.expression.prior.ExprPriorNode;
import com.espertech.esper.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.epl.expression.table.ExprTableAccessEvalStrategy;
import com.espertech.esper.epl.expression.table.ExprTableAccessNode;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.named.NamedWindowProcessorInstance;
import com.espertech.esper.epl.script.AgentInstanceScriptContext;
import com.espertech.esper.epl.spec.OnTriggerDesc;
import com.espertech.esper.epl.spec.OnTriggerWindowDesc;
import com.espertech.esper.epl.view.OutputProcessViewTerminable;
import com.espertech.esper.event.MappedEventBean;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.rowregex.RegexExprPreviousEvalStrategy;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.Viewable;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StatementAgentInstanceUtil {
    private static final Log log = LogFactory.getLog(EPStatementStopMethodImpl.class);

    public static void handleFilterFault(EventBean theEvent, long version, EPServicesContext servicesContext, Map<Integer, ContextControllerTreeAgentInstanceList> agentInstanceListMap) {
        for (Map.Entry<Integer, ContextControllerTreeAgentInstanceList> agentInstanceEntry : agentInstanceListMap.entrySet()) {
            if (agentInstanceEntry.getValue().getFilterVersionAfterAllocation() <= version) continue;
            StatementAgentInstanceUtil.evaluateEventForStatement(servicesContext, theEvent, null, agentInstanceEntry.getValue().getAgentInstances());
        }
    }

    public static void stopAgentInstances(List<AgentInstance> agentInstances, Map<String, Object> terminationProperties, EPServicesContext servicesContext, boolean isStatementStop, boolean leaveLocksAcquired) {
        if (agentInstances == null) {
            return;
        }
        for (AgentInstance instance : agentInstances) {
            StatementAgentInstanceUtil.stopAgentInstanceRemoveResources(instance, terminationProperties, servicesContext, isStatementStop, leaveLocksAcquired);
        }
    }

    public static void stopAgentInstanceRemoveResources(AgentInstance agentInstance, Map<String, Object> terminationProperties, EPServicesContext servicesContext, boolean isStatementStop, boolean leaveLocksAcquired) {
        if (terminationProperties != null) {
            agentInstance.getAgentInstanceContext().getContextProperties().getProperties().putAll(terminationProperties);
        }
        StatementAgentInstanceUtil.stop(agentInstance.getStopCallback(), agentInstance.getAgentInstanceContext(), agentInstance.getFinalView(), servicesContext, isStatementStop, leaveLocksAcquired, true);
    }

    public static void stopSafe(Collection<StopCallback> terminationCallbacks, StopCallback[] stopCallbacks, StatementContext statementContext) {
        StopCallback[] terminationArr = terminationCallbacks.toArray(new StopCallback[terminationCallbacks.size()]);
        StatementAgentInstanceUtil.stopSafe(terminationArr, statementContext);
        StatementAgentInstanceUtil.stopSafe(stopCallbacks, statementContext);
    }

    public static void stopSafe(StopCallback[] stopMethods, StatementContext statementContext) {
        for (StopCallback stopCallback : stopMethods) {
            StatementAgentInstanceUtil.stopSafe(stopCallback, statementContext);
        }
    }

    public static void stopSafe(StopCallback stopMethod, StatementContext statementContext) {
        try {
            stopMethod.stop();
        }
        catch (RuntimeException e) {
            statementContext.getExceptionHandlingService().handleException(e, statementContext.getStatementName(), statementContext.getExpression(), ExceptionHandlerExceptionType.STOP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(StopCallback stopCallback, AgentInstanceContext agentInstanceContext, Viewable finalView, EPServicesContext servicesContext, boolean isStatementStop, boolean leaveLocksAcquired, boolean removedStatementResources) {
        StatementAgentInstanceLock lock = agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock();
        lock.acquireWriteLock();
        try {
            if (finalView instanceof OutputProcessViewTerminable && !isStatementStop) {
                OutputProcessViewTerminable terminable = (OutputProcessViewTerminable)((Object)finalView);
                terminable.terminated();
            }
            StatementAgentInstanceUtil.stopSafe(stopCallback, agentInstanceContext.getStatementContext());
            agentInstanceContext.getStatementContext().getMethodResolutionService().destroyedAgentInstance(agentInstanceContext.getAgentInstanceId());
            agentInstanceContext.getStatementContext().getStatementAgentInstanceRegistry().deassign(agentInstanceContext.getAgentInstanceId());
            agentInstanceContext.getEpStatementAgentInstanceHandle().setDestroyed(true);
            agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementFilterVersion().setStmtFilterVersion(Long.MAX_VALUE);
            if (removedStatementResources && agentInstanceContext.getStatementContext().getStatementExtensionServicesContext() != null && agentInstanceContext.getStatementContext().getStatementExtensionServicesContext().getStmtResources() != null) {
                agentInstanceContext.getStatementContext().getStatementExtensionServicesContext().getStmtResources().deallocatePartitioned(agentInstanceContext.getAgentInstanceId());
            }
        }
        finally {
            if (!leaveLocksAcquired) {
                if (agentInstanceContext.getStatementContext().getEpStatementHandle().isHasTableAccess()) {
                    agentInstanceContext.getTableExprEvaluatorContext().releaseAcquiredLocks();
                }
                lock.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatementAgentInstanceFactoryResult start(EPServicesContext servicesContext, ContextControllerStatementBase statement, boolean isSingleInstanceContext, int agentInstanceId, MappedEventBean agentInstanceProperties, AgentInstanceFilterProxy agentInstanceFilterProxy, boolean isRecoveringResilient) {
        StatementAgentInstanceLock agentInstanceLock;
        StatementContext statementContext = statement.getStatementContext();
        OnTriggerDesc optOnTriggerDesc = statement.getStatementSpec().getOnTriggerDesc();
        String namedWindowName = null;
        if (optOnTriggerDesc != null && optOnTriggerDesc instanceof OnTriggerWindowDesc) {
            String windowName = ((OnTriggerWindowDesc)optOnTriggerDesc).getWindowName();
            if (servicesContext.getTableService().getTableMetadata(windowName) == null) {
                namedWindowName = windowName;
            }
        }
        if (namedWindowName != null) {
            NamedWindowProcessor processor = servicesContext.getNamedWindowMgmtService().getProcessor(namedWindowName);
            NamedWindowProcessorInstance instance = processor.getProcessorInstance(agentInstanceId);
            agentInstanceLock = instance.getRootViewInstance().getAgentInstanceContext().getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock();
        } else {
            agentInstanceLock = isSingleInstanceContext ? statementContext.getDefaultAgentInstanceLock() : servicesContext.getStatementLockFactory().getStatementLock(statementContext.getStatementName(), statementContext.getAnnotations(), statementContext.isStatelessSelect());
        }
        StatementAgentInstanceFilterVersion filterVersion = new StatementAgentInstanceFilterVersion();
        EPStatementAgentInstanceHandle agentInstanceHandle = new EPStatementAgentInstanceHandle(statementContext.getEpStatementHandle(), agentInstanceLock, agentInstanceId, filterVersion, statementContext.getFilterFaultHandlerFactory());
        AgentInstanceScriptContext agentInstanceScriptContext = null;
        if (statementContext.getDefaultAgentInstanceScriptContext() != null) {
            agentInstanceScriptContext = new AgentInstanceScriptContext();
        }
        AgentInstanceContext agentInstanceContext = new AgentInstanceContext(statementContext, agentInstanceHandle, agentInstanceId, agentInstanceFilterProxy, agentInstanceProperties, agentInstanceScriptContext);
        StatementAgentInstanceLock statementAgentInstanceLock = agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock();
        statementAgentInstanceLock.acquireWriteLock();
        try {
            StatementAgentInstanceFactoryResult startResult = statement.getFactory().newContext(agentInstanceContext, isRecoveringResilient);
            startResult.getFinalView().addView(statement.getMergeView());
            AIRegistryExpr aiExprSvc = statementContext.getStatementAgentInstanceRegistry().getAgentInstanceExprService();
            AIRegistryAggregation aiAggregationSvc = statementContext.getStatementAgentInstanceRegistry().getAgentInstanceAggregationService();
            if (startResult.getOptionalAggegationService() != null) {
                aiAggregationSvc.assignService(agentInstanceId, startResult.getOptionalAggegationService());
            }
            for (Map.Entry<ExprSubselectNode, SubSelectStrategyHolder> statementAgentInstanceFactoryResult : startResult.getSubselectStrategies().entrySet()) {
                ExprSubselectNode node = statementAgentInstanceFactoryResult.getKey();
                SubSelectStrategyHolder strategyHolder = statementAgentInstanceFactoryResult.getValue();
                aiExprSvc.getSubselectService(node).assignService(agentInstanceId, strategyHolder.getStategy());
                aiExprSvc.getSubselectAggregationService(node).assignService(agentInstanceId, strategyHolder.getSubselectAggregationService());
                for (Map.Entry<ExprPriorNode, ExprPriorEvalStrategy> entry : strategyHolder.getPriorStrategies().entrySet()) {
                    aiExprSvc.getPriorServices(entry.getKey()).assignService(agentInstanceId, entry.getValue());
                }
                for (Map.Entry<ExprNodeBase, Object> entry : strategyHolder.getPreviousNodeStrategies().entrySet()) {
                    aiExprSvc.getPreviousServices((ExprPreviousNode)entry.getKey()).assignService(agentInstanceId, (ExprPreviousEvalStrategy)entry.getValue());
                }
            }
            for (Map.Entry<ExprNodeBase, Object> entry : startResult.getPriorNodeStrategies().entrySet()) {
                aiExprSvc.getPriorServices((ExprPriorNode)entry.getKey()).assignService(agentInstanceId, (ExprPriorEvalStrategy)entry.getValue());
            }
            for (Map.Entry<ExprNodeBase, Object> entry : startResult.getPreviousNodeStrategies().entrySet()) {
                aiExprSvc.getPreviousServices((ExprPreviousNode)entry.getKey()).assignService(agentInstanceId, (ExprPreviousEvalStrategy)entry.getValue());
            }
            RegexExprPreviousEvalStrategy regexExprPreviousEvalStrategy = startResult.getRegexExprPreviousEvalStrategy();
            aiExprSvc.getMatchRecognizePrevious().assignService(agentInstanceId, regexExprPreviousEvalStrategy);
            for (Map.Entry<ExprTableAccessNode, ExprTableAccessEvalStrategy> item : startResult.getTableAccessEvalStrategies().entrySet()) {
                aiExprSvc.getTableAccessServices(item.getKey()).assignService(agentInstanceId, item.getValue());
            }
            for (StatementAgentInstancePreload preload : startResult.getPreloadList()) {
                preload.executePreload();
            }
            if (statementContext.getStatementExtensionServicesContext() != null && statementContext.getStatementExtensionServicesContext().getStmtResources() != null) {
                StatementResourceHolder statementResourceHolder = statementContext.getStatementExtensionServicesContext().extractStatementResourceHolder(startResult);
                statementContext.getStatementExtensionServicesContext().getStmtResources().setPartitioned(agentInstanceId, statementResourceHolder);
            }
            StatementAgentInstanceFactoryResult statementAgentInstanceFactoryResult = startResult;
            return statementAgentInstanceFactoryResult;
        }
        finally {
            if (agentInstanceContext.getStatementContext().getEpStatementHandle().isHasTableAccess()) {
                agentInstanceContext.getTableExprEvaluatorContext().releaseAcquiredLocks();
            }
            statementAgentInstanceLock.releaseWriteLock();
        }
    }

    public static void evaluateEventForStatement(EPServicesContext servicesContext, EventBean theEvent, Map<String, Object> optionalTriggeringPattern, List<AgentInstance> agentInstances) {
        if (theEvent != null) {
            StatementAgentInstanceUtil.evaluateEventForStatementInternal(servicesContext, theEvent, agentInstances);
        }
        if (optionalTriggeringPattern != null) {
            for (Map.Entry<String, Object> entry : optionalTriggeringPattern.entrySet()) {
                EventBean[] eventsArray;
                if (entry.getValue() instanceof EventBean) {
                    StatementAgentInstanceUtil.evaluateEventForStatementInternal(servicesContext, (EventBean)entry.getValue(), agentInstances);
                    continue;
                }
                if (!(entry.getValue() instanceof EventBean[])) continue;
                for (EventBean eventElement : eventsArray = (EventBean[])entry.getValue()) {
                    StatementAgentInstanceUtil.evaluateEventForStatementInternal(servicesContext, eventElement, agentInstances);
                }
            }
        }
    }

    private static void evaluateEventForStatementInternal(EPServicesContext servicesContext, EventBean theEvent, List<AgentInstance> agentInstances) {
        ArrayDeque<FilterHandle> callbacks = new ArrayDeque<FilterHandle>(2);
        servicesContext.getFilterService().evaluate(theEvent, callbacks);
        if (callbacks.isEmpty()) {
            return;
        }
        if (agentInstances.size() == 1 && callbacks.size() == 1) {
            AgentInstance agentInstance = agentInstances.get(0);
            if (agentInstance.getAgentInstanceContext().getStatementId() == callbacks.getFirst().getStatementId()) {
                StatementAgentInstanceUtil.process(agentInstance, servicesContext, callbacks, theEvent);
            }
            return;
        }
        boolean isPrioritized = servicesContext.getConfigSnapshot().getEngineDefaults().getExecution().isPrioritized();
        AbstractMap stmtCallbacks = !isPrioritized ? new HashMap() : new TreeMap(AgentInstanceComparator.INSTANCE);
        for (FilterHandle filterHandle : callbacks) {
            int statementId = filterHandle.getStatementId();
            AgentInstance agentInstanceFound = null;
            for (AgentInstance agentInstance : agentInstances) {
                if (agentInstance.getAgentInstanceContext().getStatementId() != statementId) continue;
                agentInstanceFound = agentInstance;
                break;
            }
            if (agentInstanceFound == null) continue;
            EPStatementHandleCallback handleCallback = (EPStatementHandleCallback)filterHandle;
            EPStatementAgentInstanceHandle handle = handleCallback.getAgentInstanceHandle();
            if (handle.isCanSelfJoin() || isPrioritized) {
                ArrayDeque<EPStatementHandleCallback> q;
                Object stmtCallback = stmtCallbacks.get(agentInstanceFound);
                if (stmtCallback == null) {
                    stmtCallbacks.put(agentInstanceFound, handleCallback);
                    continue;
                }
                if (stmtCallback instanceof ArrayDeque) {
                    q = (ArrayDeque<EPStatementHandleCallback>)stmtCallback;
                    q.add(handleCallback);
                    continue;
                }
                q = new ArrayDeque<EPStatementHandleCallback>(4);
                q.add((EPStatementHandleCallback)stmtCallback);
                q.add(handleCallback);
                stmtCallbacks.put(agentInstanceFound, q);
                continue;
            }
            StatementAgentInstanceUtil.process(agentInstanceFound, servicesContext, Collections.singletonList(handleCallback), theEvent);
        }
        if (stmtCallbacks.isEmpty()) {
            return;
        }
        for (Map.Entry entry : stmtCallbacks.entrySet()) {
            AgentInstance agentInstance = (AgentInstance)entry.getKey();
            Object callbackList = entry.getValue();
            if (callbackList instanceof ArrayDeque) {
                StatementAgentInstanceUtil.process(agentInstance, servicesContext, (Collection)callbackList, theEvent);
            } else {
                StatementAgentInstanceUtil.process(agentInstance, servicesContext, Collections.singletonList((FilterHandle)callbackList), theEvent);
            }
            if (!agentInstance.getAgentInstanceContext().getEpStatementAgentInstanceHandle().isPreemptive()) continue;
            return;
        }
    }

    public static boolean evaluateFilterForStatement(EPServicesContext servicesContext, EventBean theEvent, AgentInstanceContext agentInstanceContext, FilterHandle filterHandle) {
        ArrayDeque<FilterHandle> callbacks = new ArrayDeque<FilterHandle>();
        servicesContext.getFilterService().evaluate(theEvent, callbacks, agentInstanceContext.getStatementContext().getStatementId());
        try {
            servicesContext.getVariableService().setLocalVersion();
            for (FilterHandle handle : callbacks) {
                if (!handle.equals(filterHandle)) continue;
                return true;
            }
            agentInstanceContext.getEpStatementAgentInstanceHandle().internalDispatch();
        }
        catch (RuntimeException ex) {
            servicesContext.getExceptionHandlingService().handleException(ex, agentInstanceContext.getEpStatementAgentInstanceHandle(), ExceptionHandlerExceptionType.PROCESS);
        }
        return false;
    }

    public static StopCallback getStopCallback(List<StopCallback> stopCallbacks, final AgentInstanceContext agentInstanceContext) {
        final StopCallback[] stopCallbackArr = stopCallbacks.toArray(new StopCallback[stopCallbacks.size()]);
        return new StopCallback(){

            @Override
            public void stop() {
                StatementAgentInstanceUtil.stopSafe(agentInstanceContext.getTerminationCallbackRO(), stopCallbackArr, agentInstanceContext.getStatementContext());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void process(AgentInstance agentInstance, EPServicesContext servicesContext, Collection<FilterHandle> callbacks, EventBean theEvent) {
        AgentInstanceContext agentInstanceContext = agentInstance.getAgentInstanceContext();
        agentInstance.getAgentInstanceContext().getAgentInstanceLock().acquireWriteLock();
        try {
            servicesContext.getVariableService().setLocalVersion();
            for (FilterHandle handle : callbacks) {
                EPStatementHandleCallback callback = (EPStatementHandleCallback)handle;
                if (callback.getAgentInstanceHandle() != agentInstanceContext.getEpStatementAgentInstanceHandle()) continue;
                callback.getFilterCallback().matchFound(theEvent, null);
            }
            agentInstanceContext.getEpStatementAgentInstanceHandle().internalDispatch();
        }
        catch (RuntimeException ex) {
            servicesContext.getExceptionHandlingService().handleException(ex, agentInstanceContext.getEpStatementAgentInstanceHandle(), ExceptionHandlerExceptionType.PROCESS);
        }
        finally {
            if (agentInstanceContext.getStatementContext().getEpStatementHandle().isHasTableAccess()) {
                agentInstanceContext.getTableExprEvaluatorContext().releaseAcquiredLocks();
            }
            agentInstanceContext.getAgentInstanceLock().releaseWriteLock();
        }
    }
}

