/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.ConfigurationEngineDefaults;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.service.InsertIntoLatchSpin;
import com.espertech.esper.core.service.InsertIntoLatchWait;
import com.espertech.esper.timer.TimeSourceService;

public class InsertIntoLatchFactory {
    private final String name;
    private final boolean stateless;
    private final boolean useSpin;
    private final TimeSourceService timeSourceService;
    private final long msecWait;
    private InsertIntoLatchSpin currentLatchSpin;
    private InsertIntoLatchWait currentLatchWait;

    public InsertIntoLatchFactory(String name, boolean stateless, long msecWait, ConfigurationEngineDefaults.Threading.Locking locking, TimeSourceService timeSourceService) {
        this.name = name;
        this.msecWait = msecWait;
        this.timeSourceService = timeSourceService;
        this.stateless = stateless;
        boolean bl = this.useSpin = locking == ConfigurationEngineDefaults.Threading.Locking.SPIN;
        if (this.useSpin) {
            this.currentLatchSpin = new InsertIntoLatchSpin(this);
        } else {
            this.currentLatchWait = new InsertIntoLatchWait(this);
        }
    }

    public Object newLatch(EventBean payload) {
        if (this.stateless) {
            return payload;
        }
        if (this.useSpin) {
            InsertIntoLatchSpin nextLatch;
            this.currentLatchSpin = nextLatch = new InsertIntoLatchSpin(this, this.currentLatchSpin, this.msecWait, payload);
            return nextLatch;
        }
        InsertIntoLatchWait nextLatch = new InsertIntoLatchWait(this.currentLatchWait, this.msecWait, payload);
        this.currentLatchWait.setLater(nextLatch);
        this.currentLatchWait = nextLatch;
        return nextLatch;
    }

    public TimeSourceService getTimeSourceService() {
        return this.timeSourceService;
    }

    public String getName() {
        return this.name;
    }
}

