/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.ConfigurationEngineDefaults;
import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.client.EPStatement;
import com.espertech.esper.client.EPStatementException;
import com.espertech.esper.client.EPStatementState;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.client.annotation.Hint;
import com.espertech.esper.client.annotation.HintEnum;
import com.espertech.esper.client.annotation.Name;
import com.espertech.esper.client.hook.ExceptionHandlerExceptionType;
import com.espertech.esper.client.soda.EPStatementObjectModel;
import com.espertech.esper.collection.NameParameterCountKey;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.service.EPIsolationUnitServices;
import com.espertech.esper.core.service.EPRuntimeSPI;
import com.espertech.esper.core.service.EPServiceProviderSPI;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.EPStatementListenerSet;
import com.espertech.esper.core.service.EPStatementSPI;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.InsertIntoLatchFactory;
import com.espertech.esper.core.service.NamedWindowSelectedProps;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.StatementLifecycleEvent;
import com.espertech.esper.core.service.StatementLifecycleObserver;
import com.espertech.esper.core.service.StatementLifecycleSvc;
import com.espertech.esper.core.service.StatementLifecycleSvcUtil;
import com.espertech.esper.core.service.StatementMetadata;
import com.espertech.esper.core.service.StatementMetadataFactoryContext;
import com.espertech.esper.core.service.StatementMetadataFactoryDefault;
import com.espertech.esper.core.service.StatementType;
import com.espertech.esper.core.service.multimatch.MultiMatchHandler;
import com.espertech.esper.core.start.EPStatementDestroyMethod;
import com.espertech.esper.core.start.EPStatementStartMethod;
import com.espertech.esper.core.start.EPStatementStartMethodFactory;
import com.espertech.esper.core.start.EPStatementStartResult;
import com.espertech.esper.core.start.EPStatementStopMethod;
import com.espertech.esper.epl.agg.rollup.GroupByExpressionHelper;
import com.espertech.esper.epl.annotation.AnnotationUtil;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.declexpr.ExprDeclaredNode;
import com.espertech.esper.epl.expression.core.ExprChainedSpec;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprIdentNodeImpl;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.dot.ExprDotNode;
import com.espertech.esper.epl.expression.ops.ExprAndNodeImpl;
import com.espertech.esper.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.epl.expression.subquery.ExprSubselectRowNode;
import com.espertech.esper.epl.expression.table.ExprTableAccessNode;
import com.espertech.esper.epl.expression.visitor.ExprNodeIdentifierCollectVisitor;
import com.espertech.esper.epl.expression.visitor.ExprNodeSubselectDeclaredDotVisitor;
import com.espertech.esper.epl.expression.visitor.ExprNodeSummaryVisitor;
import com.espertech.esper.epl.expression.visitor.ExprNodeTableAccessVisitor;
import com.espertech.esper.epl.expression.visitor.ExprNodeViewResourceVisitor;
import com.espertech.esper.epl.named.NamedWindowMgmtService;
import com.espertech.esper.epl.script.jsr223.JSR223Helper;
import com.espertech.esper.epl.script.mvel.MVELHelper;
import com.espertech.esper.epl.script.mvel.MVELInvoker;
import com.espertech.esper.epl.spec.ColumnDesc;
import com.espertech.esper.epl.spec.ContextDetailNested;
import com.espertech.esper.epl.spec.CreateSchemaDesc;
import com.espertech.esper.epl.spec.ExpressionDeclDesc;
import com.espertech.esper.epl.spec.ExpressionDeclItem;
import com.espertech.esper.epl.spec.ExpressionScriptProvided;
import com.espertech.esper.epl.spec.FilterSpecRaw;
import com.espertech.esper.epl.spec.FilterStreamSpecCompiled;
import com.espertech.esper.epl.spec.FilterStreamSpecRaw;
import com.espertech.esper.epl.spec.GroupByClauseExpressions;
import com.espertech.esper.epl.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.epl.spec.OnTriggerMergeDesc;
import com.espertech.esper.epl.spec.OrderByItem;
import com.espertech.esper.epl.spec.OuterJoinDesc;
import com.espertech.esper.epl.spec.PatternStreamSpecCompiled;
import com.espertech.esper.epl.spec.SelectClauseElementCompiled;
import com.espertech.esper.epl.spec.SelectClauseElementRaw;
import com.espertech.esper.epl.spec.SelectClauseElementWildcard;
import com.espertech.esper.epl.spec.SelectClauseExprCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseExprRawSpec;
import com.espertech.esper.epl.spec.SelectClauseSpecCompiled;
import com.espertech.esper.epl.spec.SelectClauseSpecRaw;
import com.espertech.esper.epl.spec.SelectClauseStreamCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseStreamRawSpec;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StatementSpecRaw;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecOptions;
import com.espertech.esper.epl.spec.StreamSpecRaw;
import com.espertech.esper.epl.spec.ViewSpec;
import com.espertech.esper.epl.spec.util.StatementSpecCompiledAnalyzer;
import com.espertech.esper.epl.spec.util.StatementSpecCompiledAnalyzerResult;
import com.espertech.esper.epl.spec.util.StatementSpecRawAnalyzer;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.event.NativeEventType;
import com.espertech.esper.event.arr.ObjectArrayEventType;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.event.map.MapEventType;
import com.espertech.esper.filter.FilterNonPropertyRegisteryService;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.pattern.EvalFilterFactoryNode;
import com.espertech.esper.pattern.EvalNodeAnalysisResult;
import com.espertech.esper.pattern.EvalNodeUtil;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.util.EventRepresentationUtil;
import com.espertech.esper.util.ManagedReadWriteLock;
import com.espertech.esper.view.ViewProcessingException;
import com.espertech.esper.view.Viewable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StatementLifecycleSvcImpl
implements StatementLifecycleSvc {
    private static Log log = LogFactory.getLog(StatementLifecycleSvcImpl.class);
    protected final EPServicesContext services;
    protected final Map<Integer, EPStatementDesc> stmtIdToDescMap;
    protected final Map<String, EPStatement> stmtNameToStmtMap;
    private final EPServiceProviderSPI epServiceProvider;
    private final ManagedReadWriteLock eventProcessingRWLock;
    private final Map<String, Integer> stmtNameToIdMap;
    private final Set<StatementLifecycleObserver> observers;
    private int lastStatementId;

    public StatementLifecycleSvcImpl(EPServiceProvider epServiceProvider, EPServicesContext services) {
        this.services = services;
        this.epServiceProvider = (EPServiceProviderSPI)epServiceProvider;
        this.eventProcessingRWLock = services.getEventProcessingRWLock();
        this.stmtIdToDescMap = new HashMap<Integer, EPStatementDesc>();
        this.stmtNameToStmtMap = new HashMap<String, EPStatement>();
        this.stmtNameToIdMap = new LinkedHashMap<String, Integer>();
        this.observers = new CopyOnWriteArraySet<StatementLifecycleObserver>();
    }

    @Override
    public void addObserver(StatementLifecycleObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeObserver(StatementLifecycleObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public void destroy() {
        this.destroyAllStatements();
    }

    @Override
    public void init() {
    }

    @Override
    public Map<String, EPStatement> getStmtNameToStmt() {
        return this.stmtNameToStmtMap;
    }

    @Override
    public synchronized EPStatement createAndStart(StatementSpecRaw statementSpec, String expression, boolean isPattern, String optStatementName, Object userObject, EPIsolationUnitServices isolationUnitServices, Integer optionalStatementId, EPStatementObjectModel optionalModel) {
        Integer assignedStatementId = optionalStatementId;
        if (assignedStatementId == null) {
            do {
                ++this.lastStatementId;
            } while (this.stmtIdToDescMap.containsKey(assignedStatementId = Integer.valueOf(this.lastStatementId)));
        }
        EPStatementDesc desc = this.createStoppedAssignName(statementSpec, expression, isPattern, optStatementName, assignedStatementId, null, userObject, isolationUnitServices, optionalModel);
        this.start(assignedStatementId, desc, true, false, false);
        return desc.getEpStatement();
    }

    protected synchronized EPStatementDesc createStoppedAssignName(StatementSpecRaw statementSpec, String expression, boolean isPattern, String optStatementName, int statementId, Map<String, Object> optAdditionalContext, Object userObject, EPIsolationUnitServices isolationUnitServices, EPStatementObjectModel optionalModel) {
        boolean nameProvided = false;
        String statementName = "stmt_" + Integer.toString(statementId);
        Annotation[] annotations = AnnotationUtil.compileAnnotations(statementSpec.getAnnotations(), this.services.getEngineImportService(), expression);
        if (optStatementName == null && annotations != null && annotations.length != 0) {
            for (Annotation annotation : annotations) {
                Name name;
                if (!(annotation instanceof Name) || (name = (Name)annotation).value() == null) continue;
                optStatementName = name.value();
            }
        }
        if (optStatementName != null) {
            optStatementName = optStatementName.trim();
            statementName = this.getUniqueStatementName(optStatementName, statementId);
            nameProvided = true;
        }
        return this.createStopped(statementSpec, annotations, expression, isPattern, statementName, nameProvided, statementId, optAdditionalContext, userObject, isolationUnitServices, false, optionalModel);
    }

    protected synchronized EPStatementDesc createStopped(StatementSpecRaw statementSpec, Annotation[] annotations, String expression, boolean isPattern, String statementName, boolean nameProvided, int statementId, Map<String, Object> optAdditionalContext, Object statementUserObject, EPIsolationUnitServices isolationUnitServices, boolean isFailed, EPStatementObjectModel optionalModel) {
        EPStatementDesc statementDesc;
        StatementSpecCompiled compiledSpec;
        ExprNodeSubselectDeclaredDotVisitor visitor;
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof Hint)) continue;
                statementSpec.setHasVariables(true);
            }
        }
        try {
            visitor = StatementSpecRawAnalyzer.walkSubselectAndDeclaredDotExpr(statementSpec);
        }
        catch (ExprValidationException ex) {
            throw new EPStatementException(ex.getMessage(), expression);
        }
        Set<ExprTableAccessNode> tableAccessNodes = this.determineTableAccessNodes(statementSpec.getTableExpressions(), visitor);
        new HashSet();
        if (statementSpec.getTableExpressions() != null) {
            tableAccessNodes.addAll(statementSpec.getTableExpressions());
        }
        if (visitor.getDeclaredExpressions() != null) {
            ExprNodeTableAccessVisitor tableAccessVisitor = new ExprNodeTableAccessVisitor(tableAccessNodes);
            for (ExprDeclaredNode declared : visitor.getDeclaredExpressions()) {
                declared.getBody().accept(tableAccessVisitor);
            }
        }
        for (ExprSubselectNode subselectNode : visitor.getSubselects()) {
            if (subselectNode.getStatementSpecRaw().getTableExpressions() == null) continue;
            tableAccessNodes.addAll(subselectNode.getStatementSpecRaw().getTableExpressions());
        }
        List<ExprSubselectNode> subselectNodes = visitor.getSubselects();
        if (!visitor.getChainedExpressionsDot().isEmpty()) {
            StatementLifecycleSvcImpl.rewriteNamedWindowSubselect(visitor.getChainedExpressionsDot(), subselectNodes, this.services.getNamedWindowMgmtService());
        }
        this.validateScripts(expression, statementSpec.getScriptExpressions(), statementSpec.getExpressionDeclDesc());
        StatementType statementType = StatementMetadataFactoryDefault.getStatementType(statementSpec, isPattern);
        boolean stateless = StatementLifecycleSvcImpl.determineStatelessSelect(statementType, statementSpec, !subselectNodes.isEmpty(), isPattern);
        boolean writesToTables = StatementLifecycleSvcUtil.isWritesToTables(statementSpec, this.services.getTableService());
        StatementContext statementContext = this.services.getStatementContextFactory().makeContext(statementId, statementName, expression, statementType, this.services, optAdditionalContext, false, annotations, isolationUnitServices, stateless, statementSpec, subselectNodes, writesToTables, statementUserObject);
        try {
            compiledSpec = StatementLifecycleSvcImpl.compile(statementSpec, expression, statementContext, false, false, annotations, visitor.getSubselects(), visitor.getDeclaredExpressions(), tableAccessNodes, this.services);
        }
        catch (RuntimeException ex) {
            this.handleRemove(statementId, statementName);
            throw ex;
        }
        statementContext.setStatementSpecCompiled(compiledSpec);
        if (statementSpec.getInsertIntoDesc() != null || statementSpec.getOnTriggerDesc() instanceof OnTriggerMergeDesc) {
            String insertIntoStreamName = statementSpec.getInsertIntoDesc() != null ? statementSpec.getInsertIntoDesc().getEventTypeName() : "merge";
            String latchFactoryNameBack = "insert_stream_B_" + insertIntoStreamName + "_" + statementName;
            String latchFactoryNameFront = "insert_stream_F_" + insertIntoStreamName + "_" + statementName;
            long msecTimeout = this.services.getEngineSettingsService().getEngineSettings().getThreading().getInsertIntoDispatchTimeout();
            ConfigurationEngineDefaults.Threading.Locking locking = this.services.getEngineSettingsService().getEngineSettings().getThreading().getInsertIntoDispatchLocking();
            InsertIntoLatchFactory latchFactoryFront = new InsertIntoLatchFactory(latchFactoryNameFront, stateless, msecTimeout, locking, this.services.getTimeSource());
            InsertIntoLatchFactory latchFactoryBack = new InsertIntoLatchFactory(latchFactoryNameBack, stateless, msecTimeout, locking, this.services.getTimeSource());
            statementContext.getEpStatementHandle().setInsertIntoFrontLatchFactory(latchFactoryFront);
            statementContext.getEpStatementHandle().setInsertIntoBackLatchFactory(latchFactoryBack);
        }
        boolean needDedup = false;
        StatementSpecCompiledAnalyzerResult streamAnalysis = StatementSpecCompiledAnalyzer.analyzeFilters(compiledSpec);
        FilterSpecCompiled[] filterSpecAll = streamAnalysis.getFilters().toArray(new FilterSpecCompiled[streamAnalysis.getFilters().size()]);
        NamedWindowConsumerStreamSpec[] namedWindowConsumersAll = streamAnalysis.getNamedWindowConsumers().toArray(new NamedWindowConsumerStreamSpec[streamAnalysis.getNamedWindowConsumers().size()]);
        compiledSpec.setFilterSpecsOverall(filterSpecAll);
        compiledSpec.setNamedWindowConsumersAll(namedWindowConsumersAll);
        for (FilterSpecCompiled filter : filterSpecAll) {
            if (filter.getParameters().length > 1) {
                needDedup = true;
            }
            StatementLifecycleSvcUtil.assignFilterSpecIds(filter, filterSpecAll);
            StatementLifecycleSvcImpl.registerNonPropertyGetters(filter, statementName, this.services.getFilterNonPropertyRegisteryService());
        }
        boolean isSubselectPreeval = this.services.getEngineSettingsService().getEngineSettings().getExpression().isSelfSubselectPreeval();
        MultiMatchHandler multiMatchHandler = !needDedup ? (subselectNodes.isEmpty() ? this.services.getMultiMatchHandlerFactory().makeNoDedupNoSubq() : (isSubselectPreeval ? this.services.getMultiMatchHandlerFactory().makeNoDedupSubselectPreval() : this.services.getMultiMatchHandlerFactory().makeNoDedupSubselectPosteval())) : (subselectNodes.isEmpty() ? this.services.getMultiMatchHandlerFactory().makeDedupNoSubq() : this.services.getMultiMatchHandlerFactory().makeDedupSubq(isSubselectPreeval));
        statementContext.getEpStatementHandle().setMultiMatchHandler(multiMatchHandler);
        boolean canSelfJoin = this.isPotentialSelfJoin(compiledSpec) || needDedup;
        statementContext.getEpStatementHandle().setCanSelfJoin(canSelfJoin);
        this.services.getStatementEventTypeRefService().addReferences(statementName, compiledSpec.getEventTypeReferences());
        this.services.getStatementVariableRefService().addReferences(statementName, compiledSpec.getVariableReferences(), compiledSpec.getTableNodes());
        StatementMetadata statementMetadata = this.services.getStatementMetadataFactory().create(new StatementMetadataFactoryContext(statementName, statementId, statementContext, statementSpec, expression, isPattern, optionalModel));
        this.eventProcessingRWLock.acquireWriteLock();
        try {
            boolean preserveDispatchOrder = this.services.getEngineSettingsService().getEngineSettings().getThreading().isListenerDispatchPreserveOrder() && !stateless;
            boolean isSpinLocks = this.services.getEngineSettingsService().getEngineSettings().getThreading().getListenerDispatchLocking() == ConfigurationEngineDefaults.Threading.Locking.SPIN;
            long blockingTimeout = this.services.getEngineSettingsService().getEngineSettings().getThreading().getListenerDispatchTimeout();
            long timeLastStateChange = this.services.getSchedulingService().getTime();
            EPStatementSPI statement = this.services.getEpStatementFactory().make(statementSpec.getExpressionNoAnnotations(), isPattern, this.services.getDispatchService(), this, timeLastStateChange, preserveDispatchOrder, isSpinLocks, blockingTimeout, this.services.getTimeSource(), statementMetadata, statementUserObject, statementContext, isFailed, nameProvided);
            statementContext.setStatement(statement);
            boolean isInsertInto = statementSpec.getInsertIntoDesc() != null;
            boolean isDistinct = statementSpec.getSelectClauseSpec().isDistinct();
            boolean isForClause = statementSpec.getForClauseSpec() != null;
            statementContext.getStatementResultService().setContext(statement, this.epServiceProvider, isInsertInto, isPattern, isDistinct, isForClause, statementContext.getEpStatementHandle().getMetricsHandle());
            EPStatementStartMethod startMethod = EPStatementStartMethodFactory.makeStartMethod(compiledSpec);
            statementDesc = new EPStatementDesc(statement, startMethod, statementContext);
            this.stmtIdToDescMap.put(statementId, statementDesc);
            this.stmtNameToStmtMap.put(statementName, statement);
            this.stmtNameToIdMap.put(statementName, statementId);
            this.dispatchStatementLifecycleEvent(new StatementLifecycleEvent(statement, StatementLifecycleEvent.LifecycleEventType.CREATE, new Object[0]));
        }
        catch (RuntimeException ex) {
            this.stmtIdToDescMap.remove(statementId);
            this.stmtNameToIdMap.remove(statementName);
            this.stmtNameToStmtMap.remove(statementName);
            throw ex;
        }
        finally {
            this.eventProcessingRWLock.releaseWriteLock();
        }
        return statementDesc;
    }

    private Set<ExprTableAccessNode> determineTableAccessNodes(Set<ExprTableAccessNode> statementDirectTableAccess, ExprNodeSubselectDeclaredDotVisitor visitor) {
        HashSet<ExprTableAccessNode> tableAccessNodes = new HashSet<ExprTableAccessNode>();
        if (statementDirectTableAccess != null) {
            tableAccessNodes.addAll(statementDirectTableAccess);
        }
        ExprNodeTableAccessVisitor tableAccessVisitor = new ExprNodeTableAccessVisitor(tableAccessNodes);
        for (ExprDeclaredNode declared : visitor.getDeclaredExpressions()) {
            declared.getBody().accept(tableAccessVisitor);
        }
        for (ExprSubselectNode subselectNode : visitor.getSubselects()) {
            if (subselectNode.getStatementSpecRaw().getTableExpressions() == null) continue;
            tableAccessNodes.addAll(subselectNode.getStatementSpecRaw().getTableExpressions());
        }
        return tableAccessNodes;
    }

    private void validateScripts(String epl, List<ExpressionScriptProvided> scripts, ExpressionDeclDesc expressionDeclDesc) {
        if (scripts == null) {
            return;
        }
        try {
            HashSet<NameParameterCountKey> scriptsSet = new HashSet<NameParameterCountKey>();
            for (ExpressionScriptProvided script : scripts) {
                this.validateScript(script);
                NameParameterCountKey key = new NameParameterCountKey(script.getName(), script.getParameterNames().size());
                if (scriptsSet.contains(key)) {
                    throw new ExprValidationException("Script name '" + script.getName() + "' has already been defined with the same number of parameters");
                }
                scriptsSet.add(key);
            }
            if (expressionDeclDesc != null) {
                for (ExpressionDeclItem declItem : expressionDeclDesc.getExpressions()) {
                    if (!scriptsSet.contains(new NameParameterCountKey(declItem.getName(), 0))) continue;
                    throw new ExprValidationException("Script name '" + declItem.getName() + "' overlaps with another expression of the same name");
                }
            }
        }
        catch (ExprValidationException ex) {
            throw new EPStatementException(ex.getMessage(), ex, epl);
        }
    }

    private void validateScript(ExpressionScriptProvided script) throws ExprValidationException {
        String dialect;
        String string = dialect = script.getOptionalDialect() == null ? this.services.getConfigSnapshot().getEngineDefaults().getScripts().getDefaultDialect() : script.getOptionalDialect();
        if (dialect == null) {
            throw new ExprValidationException("Failed to determine script dialect for script '" + script.getName() + "', please configure a default dialect or provide a dialect explicitly");
        }
        if (dialect.trim().toLowerCase().equals("mvel")) {
            if (!MVELInvoker.isMVELInClasspath()) {
                throw new ExprValidationException("MVEL scripting engine not found in classpath, script dialect 'mvel' requires mvel in classpath for script '" + script.getName() + "'");
            }
            MVELHelper.verifyScript(script);
        } else {
            JSR223Helper.verifyCompileScript(script, dialect);
        }
        if (!script.getParameterNames().isEmpty()) {
            HashSet<String> parameters = new HashSet<String>();
            for (String param : script.getParameterNames()) {
                if (parameters.contains(param)) {
                    throw new ExprValidationException("Invalid script parameters for script '" + script.getName() + "', parameter '" + param + "' is defined more then once");
                }
                parameters.add(param);
            }
        }
    }

    private boolean isPotentialSelfJoin(StatementSpecCompiled spec) {
        if (spec.getContextDesc() != null && spec.getContextDesc().getContextDetail() instanceof ContextDetailNested) {
            return true;
        }
        if (spec.getOrderByList().length > 0) {
            return true;
        }
        for (StreamSpecCompiled streamSpec : spec.getStreamSpecs()) {
            if (!(streamSpec instanceof PatternStreamSpecCompiled)) continue;
            return true;
        }
        if (spec.getStreamSpecs().length <= 1 && spec.getSubSelectExpressions().length == 0) {
            return false;
        }
        ArrayList<EventType> filteredTypes = new ArrayList<EventType>();
        Set<EventType> optSubselectTypes = this.populateSubqueryTypes(spec.getSubSelectExpressions());
        boolean hasFilterStream = false;
        for (StreamSpecCompiled streamSpec : spec.getStreamSpecs()) {
            if (!(streamSpec instanceof FilterStreamSpecCompiled)) continue;
            EventType type = ((FilterStreamSpecCompiled)streamSpec).getFilterSpec().getFilterForEventType();
            filteredTypes.add(type);
            hasFilterStream = true;
        }
        if (filteredTypes.size() == 1 && optSubselectTypes.isEmpty()) {
            return false;
        }
        if (!hasFilterStream) {
            return false;
        }
        for (int i = 0; i < filteredTypes.size(); ++i) {
            for (int j = i + 1; j < filteredTypes.size(); ++j) {
                EventType typeTwo;
                EventType typeOne = (EventType)filteredTypes.get(i);
                if (typeOne == (typeTwo = (EventType)filteredTypes.get(j))) {
                    return true;
                }
                if (typeOne.getSuperTypes() != null) {
                    for (EventType typeOneSuper : typeOne.getSuperTypes()) {
                        if (typeOneSuper != typeTwo) continue;
                        return true;
                    }
                }
                if (typeTwo.getSuperTypes() == null) continue;
                for (EventType typeTwoSuper : typeTwo.getSuperTypes()) {
                    if (typeOne != typeTwoSuper) continue;
                    return true;
                }
            }
        }
        if (!optSubselectTypes.isEmpty()) {
            for (EventType typeOne : filteredTypes) {
                if (optSubselectTypes.contains(typeOne)) {
                    return true;
                }
                if (typeOne.getSuperTypes() == null) continue;
                for (EventType typeOneSuper : typeOne.getSuperTypes()) {
                    if (!optSubselectTypes.contains(typeOneSuper)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Set<EventType> populateSubqueryTypes(ExprSubselectNode[] subSelectExpressions) {
        HashSet<EventType> set = null;
        for (ExprSubselectNode subselect : subSelectExpressions) {
            for (StreamSpecCompiled streamSpec : subselect.getStatementSpecCompiled().getStreamSpecs()) {
                if (streamSpec instanceof FilterStreamSpecCompiled) {
                    EventType type = ((FilterStreamSpecCompiled)streamSpec).getFilterSpec().getFilterForEventType();
                    if (set == null) {
                        set = new HashSet<EventType>();
                    }
                    set.add(type);
                    continue;
                }
                if (!(streamSpec instanceof PatternStreamSpecCompiled)) continue;
                EvalNodeAnalysisResult evalNodeAnalysisResult = EvalNodeUtil.recursiveAnalyzeChildNodes(((PatternStreamSpecCompiled)streamSpec).getEvalFactoryNode());
                List<EvalFilterFactoryNode> filterNodes = evalNodeAnalysisResult.getFilterNodes();
                for (EvalFilterFactoryNode filterNode : filterNodes) {
                    if (set == null) {
                        set = new HashSet();
                    }
                    set.add(filterNode.getFilterSpec().getFilterForEventType());
                }
            }
        }
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start(int statementId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(".start Starting statement " + statementId));
        }
        this.eventProcessingRWLock.acquireWriteLock();
        try {
            EPStatementDesc desc = this.stmtIdToDescMap.get(statementId);
            if (desc == null) {
                throw new IllegalStateException("Cannot start statement, statement is in destroyed state");
            }
            this.startInternal(statementId, desc, false, false, false);
        }
        finally {
            this.eventProcessingRWLock.releaseWriteLock();
        }
    }

    public void start(int statementId, EPStatementDesc desc, boolean isNewStatement, boolean isRecoveringStatement, boolean isResilient) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(".start Starting statement " + statementId + " from desc=" + desc));
        }
        this.eventProcessingRWLock.acquireWriteLock();
        try {
            this.startInternal(statementId, desc, isNewStatement, isRecoveringStatement, isResilient);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.eventProcessingRWLock.releaseWriteLock();
        }
    }

    private void startInternal(int statementId, EPStatementDesc desc, boolean isNewStatement, boolean isRecoveringStatement, boolean isResilient) {
        EPStatementStartResult startResult;
        if (log.isDebugEnabled()) {
            log.debug((Object)(".startInternal Starting statement " + statementId + " from desc=" + desc));
        }
        if (desc.getStartMethod() == null) {
            throw new IllegalStateException("Statement start method not found for id " + statementId);
        }
        EPStatementSPI statement = desc.getEpStatement();
        if (statement.getState() == EPStatementState.STARTED) {
            log.debug((Object)".startInternal - Statement already started");
            return;
        }
        try {
            startResult = desc.getStartMethod().start(this.services, desc.getStatementContext(), isNewStatement, isRecoveringStatement, isResilient);
            this.services.getNamedWindowConsumerMgmtService().start(desc.getStatementContext().getStatementName());
        }
        catch (EPStatementException ex) {
            this.handleRemove(statementId, statement.getName());
            log.debug((Object)".start Error starting statement", (Throwable)ex);
            throw ex;
        }
        catch (ExprValidationException ex) {
            this.handleRemove(statementId, statement.getName());
            log.debug((Object)".start Error starting statement", (Throwable)ex);
            throw new EPStatementException("Error starting statement: " + ex.getMessage(), ex, statement.getText());
        }
        catch (ViewProcessingException ex) {
            this.handleRemove(statementId, statement.getName());
            log.debug((Object)".start Error starting statement", (Throwable)ex);
            throw new EPStatementException("Error starting statement: " + ex.getMessage(), ex, statement.getText());
        }
        catch (RuntimeException ex) {
            this.handleRemove(statementId, statement.getName());
            log.debug((Object)".start Error starting statement", (Throwable)ex);
            throw new EPStatementException("Unexpected exception starting statement: " + ex.getMessage(), ex, statement.getText());
        }
        Viewable parentView = startResult.getViewable();
        desc.setStopMethod(startResult.getStopMethod());
        desc.setDestroyMethod(startResult.getDestroyMethod());
        statement.setParentView(parentView);
        long timeLastStateChange = this.services.getSchedulingService().getTime();
        statement.setCurrentState(EPStatementState.STARTED, timeLastStateChange);
        this.dispatchStatementLifecycleEvent(new StatementLifecycleEvent(statement, StatementLifecycleEvent.LifecycleEventType.STATECHANGE, new Object[0]));
    }

    private void handleRemove(int statementId, String statementName) {
        this.stmtIdToDescMap.remove(statementId);
        this.stmtNameToIdMap.remove(statementName);
        this.stmtNameToStmtMap.remove(statementName);
        this.services.getStatementEventTypeRefService().removeReferencesStatement(statementName);
        this.services.getStatementVariableRefService().removeReferencesStatement(statementName);
        this.services.getFilterNonPropertyRegisteryService().removeReferencesStatement(statementName);
        this.services.getNamedWindowConsumerMgmtService().removeReferences(statementName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop(int statementId) {
        this.eventProcessingRWLock.acquireWriteLock();
        try {
            EPStatementDesc desc = this.stmtIdToDescMap.get(statementId);
            if (desc == null) {
                throw new IllegalStateException("Cannot stop statement, statement is in destroyed state");
            }
            EPStatementSPI statement = desc.getEpStatement();
            EPStatementStopMethod stopMethod = desc.getStopMethod();
            if (stopMethod == null) {
                throw new IllegalStateException("Stop method not found for statement " + statementId);
            }
            if (statement.getState() == EPStatementState.STOPPED) {
                log.debug((Object)".startInternal - Statement already stopped");
                return;
            }
            this.services.getNamedWindowConsumerMgmtService().stop(desc.getStatementContext().getStatementName());
            desc.getStatementContext().getStatementStopService().fireStatementStopped();
            stopMethod.stop();
            statement.setParentView(null);
            desc.setStopMethod(null);
            long timeLastStateChange = this.services.getSchedulingService().getTime();
            statement.setCurrentState(EPStatementState.STOPPED, timeLastStateChange);
            ((EPRuntimeSPI)this.epServiceProvider.getEPRuntime()).clearCaches();
            this.dispatchStatementLifecycleEvent(new StatementLifecycleEvent(statement, StatementLifecycleEvent.LifecycleEventType.STATECHANGE, new Object[0]));
        }
        finally {
            this.eventProcessingRWLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void destroy(int statementId) {
        this.eventProcessingRWLock.acquireWriteLock();
        try {
            EPStatementDesc desc = this.stmtIdToDescMap.get(statementId);
            if (desc == null) {
                log.debug((Object)".destroy - Statement already destroyed");
                return;
            }
            this.destroyInternal(desc);
        }
        finally {
            this.eventProcessingRWLock.releaseWriteLock();
        }
    }

    @Override
    public synchronized EPStatement getStatementByName(String name) {
        return this.stmtNameToStmtMap.get(name);
    }

    @Override
    public synchronized StatementSpecCompiled getStatementSpec(int statementId) {
        EPStatementDesc desc = this.stmtIdToDescMap.get(statementId);
        if (desc != null) {
            return desc.getStartMethod().getStatementSpec();
        }
        return null;
    }

    @Override
    public EPStatementSPI getStatementById(int statementId) {
        EPStatementDesc statementDesc = this.stmtIdToDescMap.get(statementId);
        if (statementDesc == null) {
            log.warn((Object)("Could not locate statement descriptor for statement id '" + statementId + "'"));
            return null;
        }
        return statementDesc.getEpStatement();
    }

    @Override
    public StatementContext getStatementContextById(int statementId) {
        EPStatementDesc statementDesc = this.stmtIdToDescMap.get(statementId);
        if (statementDesc == null) {
            return null;
        }
        return statementDesc.getEpStatement().getStatementContext();
    }

    @Override
    public synchronized String[] getStatementNames() {
        String[] statements = new String[this.stmtNameToStmtMap.size()];
        int count = 0;
        for (String key : this.stmtNameToStmtMap.keySet()) {
            statements[count++] = key;
        }
        return statements;
    }

    @Override
    public synchronized void startAllStatements() throws EPException {
        int[] statementIds = this.getStatementIds();
        for (int i = 0; i < statementIds.length; ++i) {
            EPStatementSPI statement = this.stmtIdToDescMap.get(statementIds[i]).getEpStatement();
            if (statement.getState() != EPStatementState.STOPPED) continue;
            this.start(statementIds[i]);
        }
    }

    @Override
    public synchronized void stopAllStatements() throws EPException {
        int[] statementIds = this.getStatementIds();
        for (int i = 0; i < statementIds.length; ++i) {
            EPStatementSPI statement = this.stmtIdToDescMap.get(statementIds[i]).getEpStatement();
            if (statement.getState() != EPStatementState.STARTED) continue;
            this.stop(statementIds[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void destroyAllStatements() throws EPException {
        this.eventProcessingRWLock.acquireWriteLock();
        try {
            int[] statementIds;
            for (int statementId : statementIds = this.getStatementIds()) {
                EPStatementDesc desc = this.stmtIdToDescMap.get(statementId);
                if (desc == null) continue;
                try {
                    this.destroyInternal(desc);
                }
                catch (RuntimeException ex) {
                    this.services.getExceptionHandlingService().handleException(ex, desc.getEpStatement().getName(), desc.getEpStatement().getText(), ExceptionHandlerExceptionType.STOP);
                }
            }
        }
        finally {
            this.eventProcessingRWLock.releaseWriteLock();
        }
    }

    private int[] getStatementIds() {
        int[] statementIds = new int[this.stmtNameToIdMap.size()];
        int count = 0;
        for (int id : this.stmtNameToIdMap.values()) {
            statementIds[count++] = id;
        }
        return statementIds;
    }

    private String getUniqueStatementName(String statementName, int statementId) {
        String finalStatementName;
        if (this.stmtNameToIdMap.containsKey(statementName)) {
            int count = 0;
            while (this.stmtNameToIdMap.containsKey(finalStatementName = statementName + "--" + count)) {
                if (count > 0x7FFFFFFD) {
                    throw new EPException("Failed to establish a unique statement name");
                }
                ++count;
            }
        } else {
            finalStatementName = statementName;
        }
        this.stmtNameToIdMap.put(finalStatementName, statementId);
        return finalStatementName;
    }

    @Override
    public String getStatementNameById(int statementId) {
        EPStatementDesc desc = this.stmtIdToDescMap.get(statementId);
        if (desc != null) {
            return desc.getEpStatement().getName();
        }
        return null;
    }

    @Override
    public void updatedListeners(EPStatement statement, EPStatementListenerSet listeners, boolean isRecovery) {
        log.debug((Object)".updatedListeners No action for base implementation");
    }

    protected static StatementSpecCompiled compile(StatementSpecRaw spec, String eplStatement, StatementContext statementContext, boolean isSubquery, boolean isOnDemandQuery, Annotation[] annotations, List<ExprSubselectNode> subselectNodes, List<ExprDeclaredNode> declaredNodes, Set<ExprTableAccessNode> tableAccessNodes, EPServicesContext servicesContext) throws EPStatementException {
        ArrayList<Object> compiledStreams;
        Object compiled;
        GroupByClauseExpressions groupByRollupExpressions;
        HashSet<String> eventTypeReferences = new HashSet<String>();
        if (spec.getStreamSpecs().size() == 1 && spec.getStreamSpecs().get(0) instanceof FilterStreamSpecRaw && spec.getStreamSpecs().get(0).getViewSpecs().length == 0 && spec.getFilterRootNode() != null && spec.getOnTriggerDesc() == null && !isSubquery && !isOnDemandQuery && (tableAccessNodes == null || tableAccessNodes.isEmpty())) {
            boolean disqualified;
            ExprNode whereClause = spec.getFilterRootNode();
            ExprNodeSubselectDeclaredDotVisitor visitor = new ExprNodeSubselectDeclaredDotVisitor();
            whereClause.accept(visitor);
            boolean bl = disqualified = visitor.getSubselects().size() > 0 || HintEnum.DISABLE_WHEREEXPR_MOVETO_FILTER.getHint(annotations) != null;
            if (!disqualified) {
                ExprNodeViewResourceVisitor viewResourceVisitor = new ExprNodeViewResourceVisitor();
                whereClause.accept(viewResourceVisitor);
                boolean bl2 = disqualified = viewResourceVisitor.getExprNodes().size() > 0;
            }
            if (!disqualified) {
                String alias = spec.getStreamSpecs().get(0).getOptionalStreamName();
                if (alias != null) {
                    ExprNodeIdentifierCollectVisitor v = new ExprNodeIdentifierCollectVisitor();
                    whereClause.accept(v);
                    for (ExprIdentNode node : v.getExprProperties()) {
                        if (node.getStreamOrPropertyName() == null || !node.getStreamOrPropertyName().equals(alias)) continue;
                        node.setStreamOrPropertyName(null);
                    }
                }
                spec.setFilterExprRootNode(null);
                FilterStreamSpecRaw streamSpec = (FilterStreamSpecRaw)spec.getStreamSpecs().get(0);
                streamSpec.getRawFilterSpec().getFilterExpressions().add(whereClause);
            }
        }
        SelectClauseSpecCompiled selectClauseCompiled = StatementLifecycleSvcUtil.compileSelectClause(spec.getSelectClauseSpec());
        ExprNodeSubselectDeclaredDotVisitor visitor = new ExprNodeSubselectDeclaredDotVisitor();
        StatementLifecycleSvcUtil.walkStreamSpecs(spec, visitor);
        for (ExprSubselectNode subselectNode : visitor.getSubselects()) {
            subselectNode.setFilterStreamSubselect(true);
        }
        visitor.reset();
        try {
            StatementLifecycleSvcUtil.walkStatement(spec, visitor);
            groupByRollupExpressions = GroupByExpressionHelper.getGroupByRollupExpressions(spec.getGroupByExpressions(), spec.getSelectClauseSpec(), spec.getHavingExprRootNode(), spec.getOrderByList(), visitor);
            List<ExprSubselectNode> subselects = visitor.getSubselects();
            if (!visitor.getChainedExpressionsDot().isEmpty()) {
                StatementLifecycleSvcImpl.rewriteNamedWindowSubselect(visitor.getChainedExpressionsDot(), subselects, statementContext.getNamedWindowMgmtService());
            }
        }
        catch (ExprValidationException ex) {
            throw new EPStatementException(ex.getMessage(), eplStatement);
        }
        if (isSubquery && !visitor.getSubselects().isEmpty()) {
            throw new EPStatementException("Invalid nested subquery, subquery-within-subquery is not supported", eplStatement);
        }
        if (isOnDemandQuery && !visitor.getSubselects().isEmpty()) {
            throw new EPStatementException("Subqueries are not a supported feature of on-demand queries", eplStatement);
        }
        for (ExprSubselectNode subselectNode : visitor.getSubselects()) {
            if (subselectNodes.contains(subselectNode)) continue;
            subselectNodes.add(subselectNode);
        }
        int subselectNumber = 0;
        for (ExprSubselectNode subselect : subselectNodes) {
            StatementSpecRaw raw = subselect.getStatementSpecRaw();
            compiled = StatementLifecycleSvcImpl.compile(raw, eplStatement, statementContext, true, isOnDemandQuery, new Annotation[0], Collections.<ExprSubselectNode>emptyList(), Collections.<ExprDeclaredNode>emptyList(), raw.getTableExpressions(), servicesContext);
            subselect.setStatementSpecCompiled((StatementSpecCompiled)compiled, ++subselectNumber);
        }
        try {
            compiledStreams = new ArrayList<Object>(spec.getStreamSpecs().size());
            int streamNum = 0;
            for (StreamSpecRaw rawSpec : spec.getStreamSpecs()) {
                compiled = rawSpec.compile(statementContext, eventTypeReferences, spec.getInsertIntoDesc() != null, Collections.singleton(++streamNum), spec.getStreamSpecs().size() > 1, false, spec.getOnTriggerDesc() != null, rawSpec.getOptionalStreamName());
                compiledStreams.add(compiled);
            }
        }
        catch (ExprValidationException ex) {
            log.info((Object)("Failed to compile statement: " + ex.getMessage()), (Throwable)ex);
            if (ex.getMessage() == null) {
                throw new EPStatementException("Unexpected exception compiling statement, please consult the log file and report the exception", eplStatement);
            }
            throw new EPStatementException(ex.getMessage(), eplStatement);
        }
        catch (RuntimeException ex) {
            String text = "Unexpected error compiling statement";
            log.error((Object)text, (Throwable)ex);
            throw new EPStatementException(text + ": " + ex.getClass().getName() + ":" + ex.getMessage(), eplStatement);
        }
        if (spec.getCreateWindowDesc() != null) {
            try {
                String selectFromTypeName;
                EventType selectFromType;
                StreamSpecCompiled createWindowTypeSpec = (StreamSpecCompiled)compiledStreams.get(0);
                if (createWindowTypeSpec instanceof FilterStreamSpecCompiled) {
                    FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)createWindowTypeSpec;
                    selectFromType = filterStreamSpec.getFilterSpec().getFilterForEventType();
                    selectFromTypeName = filterStreamSpec.getFilterSpec().getFilterForEventTypeName();
                    if (spec.getCreateWindowDesc().isInsert() || spec.getCreateWindowDesc().getInsertFilter() != null) {
                        throw new EPStatementException("A named window by name '" + selectFromTypeName + "' could not be located, use the insert-keyword with an existing named window", eplStatement);
                    }
                } else {
                    NamedWindowConsumerStreamSpec consumerStreamSpec = (NamedWindowConsumerStreamSpec)createWindowTypeSpec;
                    selectFromType = statementContext.getEventAdapterService().getExistsTypeByName(consumerStreamSpec.getWindowName());
                    selectFromTypeName = consumerStreamSpec.getWindowName();
                    if (spec.getCreateWindowDesc().getInsertFilter() != null) {
                        ExprNode insertIntoFilter = spec.getCreateWindowDesc().getInsertFilter();
                        String checkMinimal = ExprNodeUtility.isMinimalExpression(insertIntoFilter);
                        if (checkMinimal != null) {
                            throw new ExprValidationException("Create window where-clause may not have " + checkMinimal);
                        }
                        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(selectFromType, selectFromTypeName, true, statementContext.getEngineURI());
                        ExprEvaluatorContextStatement evaluatorContextStmt = new ExprEvaluatorContextStatement(statementContext, false);
                        ExprValidationContext validationContext = new ExprValidationContext(streamTypeService, statementContext.getMethodResolutionService(), null, statementContext.getSchedulingService(), statementContext.getVariableService(), statementContext.getTableService(), evaluatorContextStmt, statementContext.getEventAdapterService(), statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getAnnotations(), statementContext.getContextDescriptor(), false, false, false, false, null, false);
                        ExprNode insertFilter = ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.CREATEWINDOWFILTER, spec.getCreateWindowDesc().getInsertFilter(), validationContext);
                        spec.getCreateWindowDesc().setInsertFilter(insertFilter);
                    }
                    spec.getCreateWindowDesc().setInsertFromWindow(consumerStreamSpec.getWindowName());
                }
                Pair<FilterSpecCompiled, SelectClauseSpecRaw> newFilter = StatementLifecycleSvcImpl.handleCreateWindow(selectFromType, selectFromTypeName, spec.getCreateWindowDesc().getColumns(), spec, eplStatement, statementContext, servicesContext);
                eventTypeReferences.add(((EventTypeSPI)newFilter.getFirst().getFilterForEventType()).getMetadata().getPrimaryName());
                if (spec.getCreateWindowDesc().getViewSpecs().isEmpty()) {
                    throw new ExprValidationException("Named windows require one or more child views that are data window views");
                }
                compiledStreams.clear();
                ViewSpec[] views = ViewSpec.toArray(spec.getCreateWindowDesc().getViewSpecs());
                compiledStreams.add(new FilterStreamSpecCompiled(newFilter.getFirst(), views, null, spec.getCreateWindowDesc().getStreamSpecOptions()));
                spec.setSelectClauseSpec(newFilter.getSecond());
            }
            catch (ExprValidationException e) {
                throw new EPStatementException(e.getMessage(), eplStatement);
            }
        }
        return new StatementSpecCompiled(spec.getOnTriggerDesc(), spec.getCreateWindowDesc(), spec.getCreateIndexDesc(), spec.getCreateVariableDesc(), spec.getCreateTableDesc(), spec.getCreateSchemaDesc(), spec.getInsertIntoDesc(), spec.getSelectStreamSelectorEnum(), selectClauseCompiled, compiledStreams.toArray(new StreamSpecCompiled[compiledStreams.size()]), OuterJoinDesc.toArray(spec.getOuterJoinDescList()), spec.getFilterRootNode(), spec.getHavingExprRootNode(), spec.getOutputLimitSpec(), OrderByItem.toArray(spec.getOrderByList()), ExprSubselectNode.toArray(subselectNodes), ExprNodeUtility.toArray(declaredNodes), spec.getReferencedVariables(), spec.getRowLimitSpec(), CollectionUtil.toArray(eventTypeReferences), annotations, spec.getUpdateDesc(), spec.getMatchRecognizeSpec(), spec.getForClauseSpec(), spec.getSqlParameters(), spec.getCreateContextDesc(), spec.getOptionalContextName(), spec.getCreateDataFlowDesc(), spec.getCreateExpressionDesc(), spec.getFireAndForgetSpec(), groupByRollupExpressions, spec.getIntoTableSpec(), tableAccessNodes == null ? null : tableAccessNodes.toArray(new ExprTableAccessNode[tableAccessNodes.size()]));
    }

    private static boolean determineStatelessSelect(StatementType type, StatementSpecRaw spec, boolean hasSubselects, boolean isPattern) {
        if (hasSubselects || isPattern) {
            return false;
        }
        if (type != StatementType.SELECT && type != StatementType.INSERT_INTO) {
            return false;
        }
        if (spec.getStreamSpecs() == null || spec.getStreamSpecs().size() > 1 || spec.getStreamSpecs().isEmpty()) {
            return false;
        }
        StreamSpecRaw singleStream = spec.getStreamSpecs().get(0);
        if (!(singleStream instanceof FilterStreamSpecRaw) && !(singleStream instanceof NamedWindowConsumerStreamSpec)) {
            return false;
        }
        if (singleStream.getViewSpecs() != null && singleStream.getViewSpecs().length > 0) {
            return false;
        }
        if (spec.getOutputLimitSpec() != null) {
            return false;
        }
        if (spec.getMatchRecognizeSpec() != null) {
            return false;
        }
        List<ExprNode> expressions = StatementSpecRawAnalyzer.collectExpressionsShallow(spec);
        if (expressions.isEmpty()) {
            return true;
        }
        ExprNodeSummaryVisitor visitor = new ExprNodeSummaryVisitor();
        for (ExprNode expr : expressions) {
            if (expr == null) continue;
            expr.accept(visitor);
        }
        return !visitor.isHasAggregation() && !visitor.isHasPreviousPrior() && !visitor.isHasSubselect();
    }

    private static void rewriteNamedWindowSubselect(List<ExprDotNode> chainedExpressionsDot, List<ExprSubselectNode> subselects, NamedWindowMgmtService service) {
        for (ExprDotNode dotNode : chainedExpressionsDot) {
            String proposedWindow = dotNode.getChainSpec().get(0).getName();
            if (!service.isNamedWindow(proposedWindow)) continue;
            StatementSpecRaw raw = new StatementSpecRaw(SelectClauseStreamSelectorEnum.ISTREAM_ONLY);
            FilterSpecRaw filter = new FilterSpecRaw(proposedWindow, Collections.<ExprNode>emptyList(), null);
            raw.getStreamSpecs().add(new FilterStreamSpecRaw(filter, ViewSpec.EMPTY_VIEWSPEC_ARRAY, proposedWindow, new StreamSpecOptions()));
            ExprChainedSpec firstChain = dotNode.getChainSpec().remove(0);
            if (!firstChain.getParameters().isEmpty()) {
                if (firstChain.getParameters().size() == 1) {
                    raw.setFilterExprRootNode(firstChain.getParameters().get(0));
                } else {
                    ExprAndNodeImpl andNode = new ExprAndNodeImpl();
                    for (ExprNode node : firstChain.getParameters()) {
                        andNode.addChildNode(node);
                    }
                    raw.setFilterExprRootNode(andNode);
                }
            }
            ExprSubselectRowNode subselect = new ExprSubselectRowNode(raw);
            subselects.add(subselect);
            dotNode.setChildNodes(subselect);
        }
    }

    public static SelectClauseSpecCompiled compileSelectAllowSubselect(SelectClauseSpecRaw spec) throws ExprValidationException {
        ExprNodeSubselectDeclaredDotVisitor visitor = new ExprNodeSubselectDeclaredDotVisitor();
        ArrayList<SelectClauseElementCompiled> selectElements = new ArrayList<SelectClauseElementCompiled>();
        for (SelectClauseElementRaw raw : spec.getSelectExprList()) {
            SelectClauseElementRaw rawExpr;
            if (raw instanceof SelectClauseExprRawSpec) {
                rawExpr = (SelectClauseExprRawSpec)raw;
                ((SelectClauseExprRawSpec)rawExpr).getSelectExpression().accept(visitor);
                selectElements.add(new SelectClauseExprCompiledSpec(((SelectClauseExprRawSpec)rawExpr).getSelectExpression(), ((SelectClauseExprRawSpec)rawExpr).getOptionalAsName(), ((SelectClauseExprRawSpec)rawExpr).getOptionalAsName(), ((SelectClauseExprRawSpec)rawExpr).isEvents()));
                continue;
            }
            if (raw instanceof SelectClauseStreamRawSpec) {
                rawExpr = (SelectClauseStreamRawSpec)raw;
                selectElements.add(new SelectClauseStreamCompiledSpec(((SelectClauseStreamRawSpec)rawExpr).getStreamName(), ((SelectClauseStreamRawSpec)rawExpr).getOptionalAsName()));
                continue;
            }
            if (raw instanceof SelectClauseElementWildcard) {
                SelectClauseElementWildcard wildcard = (SelectClauseElementWildcard)raw;
                selectElements.add(wildcard);
                continue;
            }
            throw new IllegalStateException("Unexpected select clause element class : " + raw.getClass().getName());
        }
        return new SelectClauseSpecCompiled(selectElements.toArray(new SelectClauseElementCompiled[selectElements.size()]), spec.isDistinct());
    }

    private static Pair<FilterSpecCompiled, SelectClauseSpecRaw> handleCreateWindow(EventType selectFromType, String selectFromTypeName, List<ColumnDesc> columns, StatementSpecRaw spec, String eplStatement, StatementContext statementContext, EPServicesContext servicesContext) throws ExprValidationException {
        EventType targetType;
        LinkedHashMap<Object, Object> properties;
        String typeName = spec.getCreateWindowDesc().getWindowName();
        ExprEvaluatorContextStatement evaluatorContextStmt = new ExprEvaluatorContextStatement(statementContext, false);
        List<NamedWindowSelectedProps> select = StatementLifecycleSvcImpl.compileLimitedSelect(spec.getSelectClauseSpec(), eplStatement, selectFromType, selectFromTypeName, statementContext.getEngineURI(), evaluatorContextStmt, statementContext.getMethodResolutionService(), statementContext.getEventAdapterService(), statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getAnnotations());
        SelectClauseSpecRaw newSelectClauseSpecRaw = new SelectClauseSpecRaw();
        boolean hasProperties = false;
        if (columns != null && !columns.isEmpty()) {
            properties = EventTypeUtility.buildType(columns, statementContext.getEventAdapterService(), null, statementContext.getMethodResolutionService().getEngineImportService());
            hasProperties = true;
        } else {
            properties = new LinkedHashMap();
            for (NamedWindowSelectedProps selectElement : select) {
                if (selectElement.getFragmentType() != null) {
                    properties.put(selectElement.getAssignedName(), selectElement.getFragmentType());
                } else {
                    properties.put(selectElement.getAssignedName(), selectElement.getSelectExpressionType());
                }
                newSelectClauseSpecRaw.add(new SelectClauseExprRawSpec(new ExprIdentNodeImpl(selectElement.getAssignedName()), null, false));
                hasProperties = true;
            }
        }
        boolean isOnlyWildcard = spec.getSelectClauseSpec().isOnlyWildcard();
        boolean isWildcard = spec.getSelectClauseSpec().isUsingWildcard();
        if (statementContext.getValueAddEventService().isRevisionTypeName(selectFromTypeName)) {
            targetType = statementContext.getValueAddEventService().createRevisionType(typeName, selectFromTypeName, statementContext.getStatementStopService(), statementContext.getEventAdapterService(), servicesContext.getEventTypeIdGenerator());
        } else if (isWildcard && !isOnlyWildcard) {
            targetType = statementContext.getEventAdapterService().addWrapperType(typeName, selectFromType, properties, true, false);
        } else if (hasProperties && !isOnlyWildcard) {
            Map<String, Object> compiledProperties = EventTypeUtility.compileMapTypeProperties(properties, statementContext.getEventAdapterService());
            boolean mapType = EventRepresentationUtil.isMap(statementContext.getAnnotations(), servicesContext.getConfigSnapshot(), CreateSchemaDesc.AssignedType.NONE);
            targetType = mapType ? statementContext.getEventAdapterService().addNestableMapType(typeName, compiledProperties, null, false, false, false, true, false) : statementContext.getEventAdapterService().addNestableObjectArrayType(typeName, compiledProperties, null, false, false, false, true, false, false, null);
        } else if (selectFromType instanceof ObjectArrayEventType) {
            ObjectArrayEventType objectArrayEventType = (ObjectArrayEventType)selectFromType;
            targetType = statementContext.getEventAdapterService().addNestableObjectArrayType(typeName, objectArrayEventType.getTypes(), null, false, false, false, true, false, false, null);
        } else if (selectFromType instanceof MapEventType) {
            MapEventType mapType = (MapEventType)selectFromType;
            targetType = statementContext.getEventAdapterService().addNestableMapType(typeName, mapType.getTypes(), null, false, false, false, true, false);
        } else if (selectFromType instanceof BeanEventType) {
            BeanEventType beanType = (BeanEventType)selectFromType;
            targetType = statementContext.getEventAdapterService().addBeanTypeByName(typeName, beanType.getUnderlyingType(), true);
        } else {
            HashMap<String, Object> addOnTypes = new HashMap<String, Object>();
            targetType = statementContext.getEventAdapterService().addWrapperType(typeName, selectFromType, addOnTypes, true, false);
        }
        FilterSpecCompiled filter = new FilterSpecCompiled(targetType, typeName, new List[0], null);
        return new Pair<FilterSpecCompiled, SelectClauseSpecRaw>(filter, newSelectClauseSpecRaw);
    }

    private static List<NamedWindowSelectedProps> compileLimitedSelect(SelectClauseSpecRaw spec, String eplStatement, EventType singleType, String selectFromTypeName, String engineURI, ExprEvaluatorContext exprEvaluatorContext, MethodResolutionService methodResolutionService, EventAdapterService eventAdapterService, String statementName, int statementId, Annotation[] annotations) {
        LinkedList<NamedWindowSelectedProps> selectProps = new LinkedList<NamedWindowSelectedProps>();
        StreamTypeServiceImpl streams = new StreamTypeServiceImpl(new EventType[]{singleType}, new String[]{"stream_0"}, new boolean[]{false}, engineURI, false);
        ExprValidationContext validationContext = new ExprValidationContext(streams, methodResolutionService, null, null, null, null, exprEvaluatorContext, eventAdapterService, statementName, statementId, annotations, null, false, false, false, false, null, false);
        for (SelectClauseElementRaw raw : spec.getSelectExprList()) {
            ExprIdentNode identNode;
            FragmentEventType fragmentEventType;
            ExprNode validatedExpression;
            if (!(raw instanceof SelectClauseExprRawSpec)) continue;
            SelectClauseExprRawSpec exprSpec = (SelectClauseExprRawSpec)raw;
            try {
                validatedExpression = ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.SELECT, exprSpec.getSelectExpression(), validationContext);
            }
            catch (ExprValidationException e) {
                throw new EPStatementException(e.getMessage(), e, eplStatement);
            }
            String asName = exprSpec.getOptionalAsName();
            if (asName == null) {
                asName = ExprNodeUtility.toExpressionStringMinPrecedenceSafe(validatedExpression);
            }
            EventType fragmentType = null;
            if (validatedExpression instanceof ExprIdentNode && !(singleType instanceof NativeEventType) && (fragmentEventType = singleType.getFragmentType((identNode = (ExprIdentNode)validatedExpression).getFullUnresolvedName())) != null && !fragmentEventType.isNative()) {
                fragmentType = fragmentEventType.getFragmentType();
            }
            NamedWindowSelectedProps validatedElement = new NamedWindowSelectedProps(validatedExpression.getExprEvaluator().getType(), asName, fragmentType);
            selectProps.add(validatedElement);
        }
        return selectProps;
    }

    private static void registerNonPropertyGetters(FilterSpecCompiled filter, String statementName, FilterNonPropertyRegisteryService filterNonPropertyRegisteryService) {
        FilterSpecParam[][] arr$ = filter.getParameters();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            FilterSpecParam[] row;
            for (FilterSpecParam col : row = arr$[i$]) {
                if (!col.getLookupable().isNonPropertyGetter()) continue;
                filterNonPropertyRegisteryService.registerNonPropertyExpression(statementName, filter.getFilterForEventType(), col.getLookupable());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyInternal(EPStatementDesc desc) {
        EPStatementSPI statement;
        this.services.getStatementEventTypeRefService().removeReferencesStatement(desc.getEpStatement().getName());
        this.services.getNamedWindowMgmtService().removeNamedWindowLock(desc.getEpStatement().getName());
        if (this.services.getPatternSubexpressionPoolSvc() != null) {
            this.services.getPatternSubexpressionPoolSvc().removeStatement(desc.getEpStatement().getName());
        }
        if (this.services.getMatchRecognizeStatePoolEngineSvc() != null) {
            this.services.getMatchRecognizeStatePoolEngineSvc().removeStatement(desc.getEpStatement().getName());
        }
        if ((statement = desc.getEpStatement()).getState() == EPStatementState.STARTED) {
            desc.getStatementContext().getStatementStopService().fireStatementStopped();
            EPStatementStopMethod stopMethod = desc.getStopMethod();
            statement.setParentView(null);
            stopMethod.stop();
        }
        this.services.getFilterNonPropertyRegisteryService().removeReferencesStatement(desc.getEpStatement().getName());
        this.services.getStatementVariableRefService().removeReferencesStatement(desc.getEpStatement().getName());
        this.services.getNamedWindowConsumerMgmtService().destroy(desc.getStatementContext().getStatementName());
        if (desc.getDestroyMethod() != null) {
            desc.getDestroyMethod().destroy();
        }
        long timeLastStateChange = this.services.getSchedulingService().getTime();
        statement.setCurrentState(EPStatementState.DESTROYED, timeLastStateChange);
        this.stmtNameToStmtMap.remove(statement.getName());
        this.stmtNameToIdMap.remove(statement.getName());
        this.stmtIdToDescMap.remove(statement.getStatementId());
        if (!this.epServiceProvider.isDestroyed()) {
            ((EPRuntimeSPI)this.epServiceProvider.getEPRuntime()).clearCaches();
        }
        this.dispatchStatementLifecycleEvent(new StatementLifecycleEvent(statement, StatementLifecycleEvent.LifecycleEventType.STATECHANGE, new Object[0]));
    }

    @Override
    public void dispatchStatementLifecycleEvent(StatementLifecycleEvent theEvent) {
        for (StatementLifecycleObserver observer : this.observers) {
            observer.observe(theEvent);
        }
    }

    public static class EPStatementDesc {
        private final EPStatementSPI epStatement;
        private final EPStatementStartMethod startMethod;
        private final StatementContext statementContext;
        private EPStatementStopMethod stopMethod;
        private EPStatementDestroyMethod destroyMethod;

        public EPStatementDesc(EPStatementSPI epStatement, EPStatementStartMethod startMethod, StatementContext statementContext) {
            this.epStatement = epStatement;
            this.startMethod = startMethod;
            this.statementContext = statementContext;
        }

        public EPStatementSPI getEpStatement() {
            return this.epStatement;
        }

        public EPStatementStartMethod getStartMethod() {
            return this.startMethod;
        }

        public EPStatementStopMethod getStopMethod() {
            return this.stopMethod;
        }

        public void setStopMethod(EPStatementStopMethod stopMethod) {
            this.stopMethod = stopMethod;
        }

        public StatementContext getStatementContext() {
            return this.statementContext;
        }

        public void setDestroyMethod(EPStatementDestroyMethod destroyMethod) {
            this.destroyMethod = destroyMethod;
        }

        public EPStatementDestroyMethod getDestroyMethod() {
            return this.destroyMethod;
        }
    }
}

