/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service.resource;

import com.espertech.esper.core.context.mgr.ContextStatePathKey;
import com.espertech.esper.core.service.resource.StatementResourceHolder;
import com.espertech.esper.pattern.EvalRootState;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class StatementResourceService {
    private StatementResourceHolder resourcesUnpartitioned;
    private Map<Integer, StatementResourceHolder> resourcesPartitioned;
    private Map<ContextStatePathKey, EvalRootState> contextStartEndpoints;
    private Map<ContextStatePathKey, EvalRootState> contextEndEndpoints;

    public StatementResourceService(boolean partitioned) {
        if (partitioned) {
            this.resourcesPartitioned = new TreeMap<Integer, StatementResourceHolder>();
        }
    }

    public StatementResourceHolder getResourcesUnpartitioned() {
        return this.resourcesUnpartitioned;
    }

    public Map<Integer, StatementResourceHolder> getResourcesPartitioned() {
        return this.resourcesPartitioned;
    }

    public Map<ContextStatePathKey, EvalRootState> getContextEndEndpoints() {
        return this.contextEndEndpoints;
    }

    public Map<ContextStatePathKey, EvalRootState> getContextStartEndpoints() {
        return this.contextStartEndpoints;
    }

    public void startContextPattern(EvalRootState patternStopCallback, boolean startEndpoint, ContextStatePathKey path) {
        this.addContextPattern(patternStopCallback, startEndpoint, path);
    }

    public void stopContextPattern(boolean startEndpoint, ContextStatePathKey path) {
        this.removeContextPattern(startEndpoint, path);
    }

    public StatementResourceHolder getPartitioned(int agentInstanceId) {
        return this.resourcesPartitioned.get(agentInstanceId);
    }

    public void setUnpartitioned(StatementResourceHolder statementResourceHolder) {
        this.resourcesUnpartitioned = statementResourceHolder;
    }

    public void setPartitioned(int agentInstanceId, StatementResourceHolder statementResourceHolder) {
        this.resourcesPartitioned.put(agentInstanceId, statementResourceHolder);
    }

    public StatementResourceHolder getUnpartitioned() {
        return this.resourcesUnpartitioned;
    }

    public void deallocatePartitioned(int agentInstanceId) {
        this.resourcesPartitioned.remove(agentInstanceId);
    }

    public void deallocateUnpartitioned() {
        this.resourcesUnpartitioned = null;
    }

    private void removeContextPattern(boolean startEndpoint, ContextStatePathKey path) {
        if (startEndpoint) {
            if (this.contextStartEndpoints != null) {
                this.contextStartEndpoints.remove(path);
            }
        } else if (this.contextEndEndpoints != null) {
            this.contextEndEndpoints.remove(path);
        }
    }

    private void addContextPattern(EvalRootState rootState, boolean startEndpoint, ContextStatePathKey path) {
        if (startEndpoint) {
            if (this.contextStartEndpoints == null) {
                this.contextStartEndpoints = new HashMap<ContextStatePathKey, EvalRootState>();
            }
            this.contextStartEndpoints.put(path, rootState);
        } else {
            if (this.contextEndEndpoints == null) {
                this.contextEndEndpoints = new HashMap<ContextStatePathKey, EvalRootState>();
            }
            this.contextEndEndpoints.put(path, rootState);
        }
    }
}

