/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.annotation.HintEnum;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.activator.ViewableActivationResult;
import com.espertech.esper.core.context.activator.ViewableActivator;
import com.espertech.esper.core.context.subselect.SubSelectActivationCollection;
import com.espertech.esper.core.context.subselect.SubSelectActivationHolder;
import com.espertech.esper.core.context.subselect.SubSelectStrategyCollection;
import com.espertech.esper.core.context.subselect.SubSelectStrategyFactoryDesc;
import com.espertech.esper.core.context.subselect.SubSelectStrategyFactoryIndexShare;
import com.espertech.esper.core.context.subselect.SubSelectStrategyFactoryLocalViewPreloaded;
import com.espertech.esper.core.context.subselect.SubSelectStrategyHolder;
import com.espertech.esper.core.context.subselect.SubSelectStrategyRealization;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.ContextPropertyRegistry;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.start.EPStatementDestroyCallbackList;
import com.espertech.esper.core.start.EPStatementDestroyCallbackTableIdxRef;
import com.espertech.esper.core.start.EPStatementStartMethodHelperValidate;
import com.espertech.esper.core.start.EPStatementStartMethodHelperViewResources;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.agg.service.AggregationServiceFactoryDesc;
import com.espertech.esper.epl.agg.service.AggregationServiceFactoryFactory;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.core.ViewResourceDelegateUnverified;
import com.espertech.esper.epl.core.ViewResourceDelegateVerified;
import com.espertech.esper.epl.declexpr.ExprDeclaredNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeGroupKey;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeUtil;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprNodePropOrStreamDesc;
import com.espertech.esper.epl.expression.core.ExprNodePropOrStreamSet;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.prev.ExprPreviousNode;
import com.espertech.esper.epl.expression.prior.ExprPriorNode;
import com.espertech.esper.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.epl.expression.subquery.ExprSubselectStrategy;
import com.espertech.esper.epl.expression.visitor.ExprNodeIdentifierVisitor;
import com.espertech.esper.epl.expression.visitor.ExprNodeSubselectDeclaredNoTraverseVisitor;
import com.espertech.esper.epl.join.hint.ExcludePlanHint;
import com.espertech.esper.epl.join.hint.IndexHint;
import com.espertech.esper.epl.join.plan.CoercionDesc;
import com.espertech.esper.epl.join.plan.CoercionUtil;
import com.espertech.esper.epl.join.plan.QueryPlanIndexBuilder;
import com.espertech.esper.epl.join.table.EventTableFactory;
import com.espertech.esper.epl.join.util.IndexNameAndDescPair;
import com.espertech.esper.epl.join.util.QueryPlanIndexDescSubquery;
import com.espertech.esper.epl.join.util.QueryPlanIndexHook;
import com.espertech.esper.epl.join.util.QueryPlanIndexHookUtil;
import com.espertech.esper.epl.lookup.SubordFullTableScanLookupStrategyFactory;
import com.espertech.esper.epl.lookup.SubordPropHashKey;
import com.espertech.esper.epl.lookup.SubordPropPlan;
import com.espertech.esper.epl.lookup.SubordPropRangeKey;
import com.espertech.esper.epl.lookup.SubordPropUtil;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategy;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategyFactory;
import com.espertech.esper.epl.lookup.SubordinateTableLookupStrategyUtil;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.spec.FilterStreamSpecCompiled;
import com.espertech.esper.epl.spec.FilterStreamSpecRaw;
import com.espertech.esper.epl.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.epl.spec.SelectClauseElementCompiled;
import com.espertech.esper.epl.spec.SelectClauseElementWildcard;
import com.espertech.esper.epl.spec.SelectClauseExprCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseSpecCompiled;
import com.espertech.esper.epl.spec.SelectClauseStreamCompiledSpec;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecRaw;
import com.espertech.esper.epl.spec.TableQueryStreamSpec;
import com.espertech.esper.epl.subquery.SubselectAggregationPreprocessorBase;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.metrics.instrumentation.InstrumentationAgent;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.ViewFactoryChain;
import com.espertech.esper.view.ViewProcessingException;
import com.espertech.esper.view.ViewServiceHelper;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPStatementStartMethodHelperSubselect {
    private static final Log queryPlanLog = LogFactory.getLog((String)"com.espertech.esper.queryplan");
    private static final String MSG_SUBQUERY_REQUIRES_WINDOW = "Subqueries require one or more views to limit the stream, consider declaring a length or time window (applies to correlated or non-fully-aggregated subqueries)";

    protected static SubSelectActivationCollection createSubSelectActivation(EPServicesContext services, StatementSpecCompiled statementSpecContainer, StatementContext statementContext, EPStatementDestroyCallbackList destroyCallbacks) throws ExprValidationException, ViewProcessingException {
        SubSelectActivationCollection subSelectStreamDesc = new SubSelectActivationCollection();
        int subselectStreamNumber = 1024;
        for (ExprSubselectNode subselect : statementSpecContainer.getSubSelectExpressions()) {
            boolean disableIndexShare;
            StatementSpecCompiled statementSpec = subselect.getStatementSpecCompiled();
            StreamSpecCompiled streamSpec = statementSpec.getStreamSpecs()[0];
            if (streamSpec instanceof FilterStreamSpecCompiled) {
                FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)statementSpec.getStreamSpecs()[0];
                InstrumentationAgent instrumentationAgentSubquery = null;
                ViewableActivator activatorDeactivator = services.getViewableActivatorFactory().createFilterProxy(services, filterStreamSpec.getFilterSpec(), statementSpec.getAnnotations(), true, instrumentationAgentSubquery, false, null);
                ViewFactoryChain viewFactoryChain = services.getViewService().createFactories(++subselectStreamNumber, filterStreamSpec.getFilterSpec().getResultEventType(), filterStreamSpec.getViewSpecs(), filterStreamSpec.getOptions(), statementContext, true, subselect.getSubselectNumber());
                subselect.setRawEventType(viewFactoryChain.getEventType());
                subSelectStreamDesc.add(subselect, new SubSelectActivationHolder(subselectStreamNumber, filterStreamSpec.getFilterSpec().getResultEventType(), viewFactoryChain, activatorDeactivator, streamSpec));
                continue;
            }
            if (streamSpec instanceof TableQueryStreamSpec) {
                TableQueryStreamSpec table = (TableQueryStreamSpec)streamSpec;
                TableMetadata metadata = services.getTableService().getTableMetadata(table.getTableName());
                ViewFactoryChain viewFactoryChain = ViewFactoryChain.fromTypeNoViews(metadata.getInternalEventType());
                ViewableActivator viewableActivator = services.getViewableActivatorFactory().createTable(metadata, null);
                subSelectStreamDesc.add(subselect, new SubSelectActivationHolder(subselectStreamNumber, metadata.getInternalEventType(), viewFactoryChain, viewableActivator, streamSpec));
                subselect.setRawEventType(metadata.getInternalEventType());
                destroyCallbacks.addCallback(new EPStatementDestroyCallbackTableIdxRef(services.getTableService(), metadata, statementContext.getStatementName()));
                services.getStatementVariableRefService().addReferences(statementContext.getStatementName(), metadata.getTableName());
                continue;
            }
            NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)statementSpec.getStreamSpecs()[0];
            NamedWindowProcessor processor = services.getNamedWindowMgmtService().getProcessor(namedSpec.getWindowName());
            EventType namedWindowType = processor.getTailView().getEventType();
            if (namedSpec.getOptPropertyEvaluator() != null) {
                namedWindowType = namedSpec.getOptPropertyEvaluator().getFragmentEventType();
            }
            boolean bl = disableIndexShare = HintEnum.DISABLE_WINDOW_SUBQUERY_INDEXSHARE.getHint(statementSpecContainer.getAnnotations()) != null;
            if (disableIndexShare && processor.isVirtualDataWindow()) {
                disableIndexShare = false;
            }
            if (!namedSpec.getFilterExpressions().isEmpty() || !processor.isEnableSubqueryIndexShare() || disableIndexShare) {
                ViewableActivator activatorNamedWindow = services.getViewableActivatorFactory().createNamedWindow(processor, namedSpec, statementContext);
                ViewFactoryChain viewFactoryChain = services.getViewService().createFactories(0, namedWindowType, namedSpec.getViewSpecs(), namedSpec.getOptions(), statementContext, true, subselect.getSubselectNumber());
                subselect.setRawEventType(viewFactoryChain.getEventType());
                subSelectStreamDesc.add(subselect, new SubSelectActivationHolder(subselectStreamNumber, namedWindowType, viewFactoryChain, activatorNamedWindow, streamSpec));
                services.getNamedWindowConsumerMgmtService().addConsumer(statementContext, namedSpec);
                continue;
            }
            ViewFactoryChain viewFactoryChain = services.getViewService().createFactories(0, processor.getNamedWindowType(), namedSpec.getViewSpecs(), namedSpec.getOptions(), statementContext, true, subselect.getSubselectNumber());
            subselect.setRawEventType(processor.getNamedWindowType());
            ViewableActivator activator = services.getViewableActivatorFactory().makeSubqueryNWIndexShare();
            subSelectStreamDesc.add(subselect, new SubSelectActivationHolder(subselectStreamNumber, namedWindowType, viewFactoryChain, activator, streamSpec));
            services.getStatementVariableRefService().addReferences(statementContext.getStatementName(), processor.getNamedWindowType().getName());
        }
        return subSelectStreamDesc;
    }

    protected static SubSelectStrategyCollection planSubSelect(EPServicesContext services, StatementContext statementContext, boolean queryPlanLogging, SubSelectActivationCollection subSelectStreamDesc, String[] outerStreamNames, EventType[] outerEventTypesSelect, String[] outerEventTypeNamees, ExprDeclaredNode[] declaredExpressions, ContextPropertyRegistry contextPropertyRegistry) throws ExprValidationException, ViewProcessingException {
        int subqueryNum = -1;
        SubSelectStrategyCollection collection = new SubSelectStrategyCollection();
        Map<ExprDeclaredNode, List<ExprDeclaredNode>> declaredExpressionCallHierarchy = null;
        if (declaredExpressions.length > 0) {
            declaredExpressionCallHierarchy = ExprNodeUtility.getDeclaredExpressionCallHierarchy(declaredExpressions);
        }
        for (Map.Entry<ExprSubselectNode, SubSelectActivationHolder> entry : subSelectStreamDesc.getSubqueries().entrySet()) {
            ++subqueryNum;
            ExprSubselectNode subselect = entry.getKey();
            SubSelectActivationHolder subSelectActivation = entry.getValue();
            try {
                SubSelectStrategyFactoryDesc factoryDesc = EPStatementStartMethodHelperSubselect.planSubSelectInternal(subqueryNum, subselect, subSelectActivation, services, statementContext, queryPlanLogging, subSelectStreamDesc, outerStreamNames, outerEventTypesSelect, outerEventTypeNamees, declaredExpressions, contextPropertyRegistry, declaredExpressionCallHierarchy);
                collection.add(subselect, factoryDesc);
            }
            catch (Exception ex) {
                throw new ExprValidationException("Failed to plan " + EPStatementStartMethodHelperSubselect.getSubqueryInfoText(subqueryNum, subselect) + ": " + ex.getMessage(), ex);
            }
        }
        return collection;
    }

    public static Map<ExprSubselectNode, SubSelectStrategyHolder> startSubselects(EPServicesContext services, SubSelectStrategyCollection subSelectStrategyCollection, AgentInstanceContext agentInstanceContext, List<StopCallback> stopCallbackList, boolean isRecoveringResilient) {
        HashMap<ExprSubselectNode, SubSelectStrategyHolder> subselectStrategies = new HashMap<ExprSubselectNode, SubSelectStrategyHolder>();
        for (Map.Entry<ExprSubselectNode, SubSelectStrategyFactoryDesc> subselectEntry : subSelectStrategyCollection.getSubqueries().entrySet()) {
            ExprSubselectNode subselectNode = subselectEntry.getKey();
            SubSelectStrategyFactoryDesc factoryDesc = subselectEntry.getValue();
            SubSelectActivationHolder holder = factoryDesc.getSubSelectActivationHolder();
            ViewableActivationResult subselectActivationResult = holder.getActivator().activate(agentInstanceContext, true, isRecoveringResilient);
            stopCallbackList.add(subselectActivationResult.getStopCallback());
            SubSelectStrategyRealization result = factoryDesc.getFactory().instantiate(services, subselectActivationResult.getViewable(), agentInstanceContext, stopCallbackList, factoryDesc.getSubqueryNumber(), isRecoveringResilient);
            if (result.getSubselectView() instanceof StoppableView) {
                stopCallbackList.add((StoppableView)((Object)result.getSubselectView()));
            }
            if (result.getSubselectAggregationService() != null) {
                final AggregationService subselectAggregationService = result.getSubselectAggregationService();
                stopCallbackList.add(new StopCallback(){

                    @Override
                    public void stop() {
                        subselectAggregationService.stop();
                    }
                });
            }
            final SubordTableLookupStrategy lookupStrategy = result.getStrategy();
            final SubselectAggregationPreprocessorBase aggregationPreprocessor = result.getSubselectAggregationPreprocessor();
            ExprSubselectStrategy strategy = aggregationPreprocessor != null ? new ExprSubselectStrategy(){

                @Override
                public Collection<EventBean> evaluateMatching(EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
                    Collection<EventBean> matchingEvents = lookupStrategy.lookup(eventsPerStream, exprEvaluatorContext);
                    aggregationPreprocessor.evaluate(eventsPerStream, matchingEvents, exprEvaluatorContext);
                    return CollectionUtil.SINGLE_NULL_ROW_EVENT_SET;
                }
            } : new ExprSubselectStrategy(){

                @Override
                public Collection<EventBean> evaluateMatching(EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
                    return lookupStrategy.lookup(eventsPerStream, exprEvaluatorContext);
                }
            };
            SubSelectStrategyHolder instance = new SubSelectStrategyHolder(strategy, result.getSubselectAggregationService(), result.getPriorNodeStrategies(), result.getPreviousNodeStrategies(), result.getSubselectView(), result.getPostLoad(), subselectActivationResult);
            subselectStrategies.put(subselectNode, instance);
        }
        return subselectStrategies;
    }

    private static Pair<EventTableFactory, SubordTableLookupStrategyFactory> determineSubqueryIndexFactory(ExprNode filterExpr, EventType viewableEventType, EventType[] outerEventTypes, StreamTypeService subselectTypeService, boolean fullTableScan, boolean queryPlanLogging, Set<String> optionalUniqueProps, StatementContext statementContext, int subqueryNum) throws ExprValidationException {
        Pair<EventTableFactory, SubordTableLookupStrategyFactory> result = EPStatementStartMethodHelperSubselect.determineSubqueryIndexInternalFactory(filterExpr, viewableEventType, outerEventTypes, subselectTypeService, fullTableScan, optionalUniqueProps, statementContext);
        QueryPlanIndexHook hook = QueryPlanIndexHookUtil.getHook(statementContext.getAnnotations());
        if (queryPlanLogging && (queryPlanLog.isInfoEnabled() || hook != null)) {
            queryPlanLog.info((Object)"local index");
            queryPlanLog.info((Object)("strategy " + result.getSecond().toQueryPlan()));
            queryPlanLog.info((Object)("table " + result.getFirst().toQueryPlan()));
            if (hook != null) {
                String strategyName = result.getSecond().getClass().getSimpleName();
                hook.subquery(new QueryPlanIndexDescSubquery(new IndexNameAndDescPair[]{new IndexNameAndDescPair(null, result.getFirst().getEventTableClass().getSimpleName())}, subqueryNum, strategyName));
            }
        }
        return result;
    }

    private static Pair<EventTableFactory, SubordTableLookupStrategyFactory> determineSubqueryIndexInternalFactory(ExprNode filterExpr, EventType viewableEventType, EventType[] outerEventTypes, StreamTypeService subselectTypeService, boolean fullTableScan, Set<String> optionalUniqueProps, StatementContext statementContext) throws ExprValidationException {
        EventTableFactory eventTableFactory;
        CoercionDesc rangeCoercionDesc;
        CoercionDesc hashCoercionDesc;
        if (filterExpr == null || fullTableScan) {
            EventTableFactory tableFactory = statementContext.getEventTableIndexService().createUnindexed(0, null, false);
            SubordFullTableScanLookupStrategyFactory strategy = new SubordFullTableScanLookupStrategyFactory();
            return new Pair<EventTableFactory, SubordTableLookupStrategyFactory>(tableFactory, strategy);
        }
        ExcludePlanHint excludePlanHint = ExcludePlanHint.getHint(subselectTypeService.getStreamNames(), statementContext);
        SubordPropPlan joinPropDesc = QueryPlanIndexBuilder.getJoinProps(filterExpr, outerEventTypes.length, subselectTypeService.getEventTypes(), excludePlanHint);
        Map<String, SubordPropHashKey> hashKeys = joinPropDesc.getHashProps();
        Map<String, SubordPropRangeKey> rangeKeys = joinPropDesc.getRangeProps();
        ArrayList<SubordPropHashKey> hashKeyList = new ArrayList<SubordPropHashKey>(hashKeys.values());
        ArrayList<SubordPropRangeKey> rangeKeyList = new ArrayList<SubordPropRangeKey>(rangeKeys.values());
        boolean unique = false;
        ExprNode[] inKeywordSingleIdxKeys = null;
        ExprNode inKeywordMultiIdxKey = null;
        if (optionalUniqueProps != null && !optionalUniqueProps.isEmpty()) {
            boolean found = true;
            for (String uniqueProp : optionalUniqueProps) {
                if (hashKeys.containsKey(uniqueProp)) continue;
                found = false;
                break;
            }
            if (found) {
                String[] hashKeysArray;
                for (String hashKey : hashKeysArray = hashKeys.keySet().toArray(new String[hashKeys.keySet().size()])) {
                    if (optionalUniqueProps.contains(hashKey)) continue;
                    hashKeys.remove(hashKey);
                }
                hashKeyList = new ArrayList<SubordPropHashKey>(hashKeys.values());
                unique = true;
                rangeKeyList.clear();
                rangeKeys.clear();
            }
        }
        if (hashKeys.size() != 0 && rangeKeys.isEmpty()) {
            String[] indexedProps = hashKeys.keySet().toArray(new String[hashKeys.keySet().size()]);
            hashCoercionDesc = CoercionUtil.getCoercionTypesHash(viewableEventType, indexedProps, hashKeyList);
            rangeCoercionDesc = new CoercionDesc(false, null);
            eventTableFactory = hashKeys.size() == 1 ? (!hashCoercionDesc.isCoerce() ? statementContext.getEventTableIndexService().createSingle(0, viewableEventType, indexedProps[0], unique, null, null, false) : statementContext.getEventTableIndexService().createSingleCoerceAdd(0, viewableEventType, indexedProps[0], hashCoercionDesc.getCoercionTypes()[0], null, false)) : (!hashCoercionDesc.isCoerce() ? statementContext.getEventTableIndexService().createMultiKey(0, viewableEventType, indexedProps, unique, null, null, false) : statementContext.getEventTableIndexService().createMultiKeyCoerceAdd(0, viewableEventType, indexedProps, hashCoercionDesc.getCoercionTypes(), false));
        } else if (hashKeys.isEmpty() && rangeKeys.isEmpty()) {
            hashCoercionDesc = new CoercionDesc(false, null);
            rangeCoercionDesc = new CoercionDesc(false, null);
            if (joinPropDesc.getInKeywordSingleIndex() != null) {
                eventTableFactory = statementContext.getEventTableIndexService().createSingle(0, viewableEventType, joinPropDesc.getInKeywordSingleIndex().getIndexedProp(), unique, null, null, false);
                inKeywordSingleIdxKeys = joinPropDesc.getInKeywordSingleIndex().getExpressions();
            } else if (joinPropDesc.getInKeywordMultiIndex() != null) {
                eventTableFactory = statementContext.getEventTableIndexService().createInArray(0, viewableEventType, joinPropDesc.getInKeywordMultiIndex().getIndexedProp(), unique);
                inKeywordMultiIdxKey = joinPropDesc.getInKeywordMultiIndex().getExpression();
            } else {
                eventTableFactory = statementContext.getEventTableIndexService().createUnindexed(0, null, false);
            }
        } else if (hashKeys.isEmpty() && rangeKeys.size() == 1) {
            String indexedProp = rangeKeys.keySet().iterator().next();
            CoercionDesc coercionRangeTypes = CoercionUtil.getCoercionTypesRange(viewableEventType, rangeKeys, outerEventTypes);
            eventTableFactory = !coercionRangeTypes.isCoerce() ? statementContext.getEventTableIndexService().createSorted(0, viewableEventType, indexedProp, false) : statementContext.getEventTableIndexService().createSortedCoerce(0, viewableEventType, indexedProp, coercionRangeTypes.getCoercionTypes()[0], false);
            hashCoercionDesc = new CoercionDesc(false, null);
            rangeCoercionDesc = coercionRangeTypes;
        } else {
            String[] indexedKeyProps = hashKeys.keySet().toArray(new String[hashKeys.keySet().size()]);
            Class[] coercionKeyTypes = SubordPropUtil.getCoercionTypes(hashKeys.values());
            String[] indexedRangeProps = rangeKeys.keySet().toArray(new String[rangeKeys.keySet().size()]);
            CoercionDesc coercionRangeTypes = CoercionUtil.getCoercionTypesRange(viewableEventType, rangeKeys, outerEventTypes);
            eventTableFactory = statementContext.getEventTableIndexService().createComposite(0, viewableEventType, indexedKeyProps, coercionKeyTypes, indexedRangeProps, coercionRangeTypes.getCoercionTypes(), false);
            hashCoercionDesc = CoercionUtil.getCoercionTypesHash(viewableEventType, indexedKeyProps, hashKeyList);
            rangeCoercionDesc = coercionRangeTypes;
        }
        SubordTableLookupStrategyFactory subqTableLookupStrategyFactory = SubordinateTableLookupStrategyUtil.getLookupStrategy(outerEventTypes, hashKeyList, hashCoercionDesc, rangeKeyList, rangeCoercionDesc, inKeywordSingleIdxKeys, inKeywordMultiIdxKey, false);
        return new Pair<EventTableFactory, SubordTableLookupStrategyFactory>(eventTableFactory, subqTableLookupStrategyFactory);
    }

    private static StreamTypeService getDeclaredExprTypeService(ExprDeclaredNode[] declaredExpressions, Map<ExprDeclaredNode, List<ExprDeclaredNode>> declaredExpressionCallHierarchy, String[] outerStreamNames, EventType[] outerEventTypesSelect, String engineURI, ExprSubselectNode subselect, String subexpressionStreamName, EventType eventType) throws ExprValidationException {
        for (ExprDeclaredNode declaration : declaredExpressions) {
            ExprNodeSubselectDeclaredNoTraverseVisitor visitor = new ExprNodeSubselectDeclaredNoTraverseVisitor(declaration);
            visitor.reset();
            declaration.accept(visitor);
            if (!visitor.getSubselects().contains(subselect)) continue;
            if (declaration.getPrototype().isAlias()) {
                return null;
            }
            LinkedHashMap<String, Integer> outerStreamNamesMap = new LinkedHashMap<String, Integer>();
            int count = 0;
            for (String outerStreamName : outerStreamNames) {
                outerStreamNamesMap.put(outerStreamName, count++);
            }
            LinkedHashMap<String, Integer> outerStreamNamesForSubselect = outerStreamNamesMap;
            List<ExprDeclaredNode> callers = declaredExpressionCallHierarchy.get(declaration);
            for (ExprDeclaredNode caller : callers) {
                outerStreamNamesForSubselect = caller.getOuterStreamNames(outerStreamNamesForSubselect);
            }
            outerStreamNamesForSubselect = declaration.getOuterStreamNames(outerStreamNamesForSubselect);
            EventType[] eventTypes = new EventType[outerStreamNamesForSubselect.size() + 1];
            String[] streamNames = new String[outerStreamNamesForSubselect.size() + 1];
            eventTypes[0] = eventType;
            streamNames[0] = subexpressionStreamName;
            count = 0;
            for (Map.Entry entry : outerStreamNamesForSubselect.entrySet()) {
                eventTypes[count + 1] = outerEventTypesSelect[(Integer)entry.getValue()];
                streamNames[count + 1] = (String)entry.getKey();
                ++count;
            }
            StreamTypeServiceImpl availableTypes = new StreamTypeServiceImpl(eventTypes, streamNames, new boolean[eventTypes.length], engineURI, false);
            availableTypes.setRequireStreamNames(true);
            return availableTypes;
        }
        return null;
    }

    private static SubSelectStrategyFactoryDesc planSubSelectInternal(int subqueryNum, ExprSubselectNode subselect, SubSelectActivationHolder subSelectActivation, EPServicesContext services, StatementContext statementContext, boolean queryPlanLogging, SubSelectActivationCollection subSelectStreamDesc, String[] outerStreamNames, EventType[] outerEventTypesSelect, String[] outerEventTypeNamees, ExprDeclaredNode[] declaredExpressions, ContextPropertyRegistry contextPropertyRegistry, Map<ExprDeclaredNode, List<ExprDeclaredNode>> declaredExpressionCallHierarchy) throws ExprValidationException {
        NamedWindowConsumerStreamSpec namedSpec;
        boolean hasNonAggregatedProperties;
        if (queryPlanLogging && queryPlanLog.isInfoEnabled()) {
            queryPlanLog.info((Object)("For statement '" + statementContext.getStatementName() + "' subquery " + subqueryNum));
        }
        Annotation[] annotations = statementContext.getAnnotations();
        IndexHint indexHint = IndexHint.getIndexHint(statementContext.getAnnotations());
        StatementSpecCompiled statementSpec = subselect.getStatementSpecCompiled();
        StreamSpecCompiled filterStreamSpec = statementSpec.getStreamSpecs()[0];
        String subselecteventTypeName = null;
        if (filterStreamSpec instanceof FilterStreamSpecCompiled) {
            subselecteventTypeName = ((FilterStreamSpecCompiled)filterStreamSpec).getFilterSpec().getFilterForEventTypeName();
        } else if (filterStreamSpec instanceof NamedWindowConsumerStreamSpec) {
            subselecteventTypeName = ((NamedWindowConsumerStreamSpec)filterStreamSpec).getWindowName();
        } else if (filterStreamSpec instanceof TableQueryStreamSpec) {
            subselecteventTypeName = ((TableQueryStreamSpec)filterStreamSpec).getTableName();
        }
        ViewFactoryChain viewFactoryChain = subSelectStreamDesc.getViewFactoryChain(subselect);
        EventType eventType = viewFactoryChain.getEventType();
        String subexpressionStreamName = filterStreamSpec.getOptionalStreamName();
        int subselectStreamNumber = subSelectStreamDesc.getStreamNumber(subselect);
        if (subexpressionStreamName == null) {
            subexpressionStreamName = "$subselect_" + subselectStreamNumber;
        }
        String[] allStreamNames = new String[outerStreamNames.length + 1];
        System.arraycopy(outerStreamNames, 0, allStreamNames, 1, outerStreamNames.length);
        allStreamNames[0] = subexpressionStreamName;
        if (filterStreamSpec instanceof NamedWindowConsumerStreamSpec || filterStreamSpec instanceof TableQueryStreamSpec) {
            EPStatementStartMethodHelperValidate.validateNoDataWindowOnNamedWindow(viewFactoryChain.getViewFactoryChain());
        }
        StreamTypeService subselectTypeService = null;
        EventType[] outerEventTypes = null;
        if (declaredExpressions.length > 0 && (subselectTypeService = EPStatementStartMethodHelperSubselect.getDeclaredExprTypeService(declaredExpressions, declaredExpressionCallHierarchy, outerStreamNames, outerEventTypesSelect, services.getEngineURI(), subselect, subexpressionStreamName, eventType)) != null) {
            outerEventTypes = new EventType[subselectTypeService.getEventTypes().length - 1];
            System.arraycopy(subselectTypeService.getEventTypes(), 1, outerEventTypes, 0, subselectTypeService.getEventTypes().length - 1);
        }
        if (subselectTypeService == null) {
            if (subselect.getFilterSubqueryStreamTypes() != null) {
                subselectTypeService = subselect.getFilterSubqueryStreamTypes();
                outerEventTypes = new EventType[subselectTypeService.getEventTypes().length - 1];
                System.arraycopy(subselectTypeService.getEventTypes(), 1, outerEventTypes, 0, subselectTypeService.getEventTypes().length - 1);
            } else {
                LinkedHashMap<String, Pair<EventType, String>> namesAndTypes = new LinkedHashMap<String, Pair<EventType, String>>();
                namesAndTypes.put(subexpressionStreamName, new Pair<EventType, String>(eventType, subselecteventTypeName));
                for (int i = 0; i < outerEventTypesSelect.length; ++i) {
                    Pair<EventType, String> pair = new Pair<EventType, String>(outerEventTypesSelect[i], outerEventTypeNamees[i]);
                    namesAndTypes.put(outerStreamNames[i], pair);
                }
                subselectTypeService = new StreamTypeServiceImpl(namesAndTypes, services.getEngineURI(), true, true);
                outerEventTypes = outerEventTypesSelect;
            }
        }
        ViewResourceDelegateUnverified viewResourceDelegateSubselect = new ViewResourceDelegateUnverified();
        SelectClauseSpecCompiled selectClauseSpec = subselect.getStatementSpecCompiled().getSelectClauseSpec();
        AggregationServiceFactoryDesc aggregationServiceFactoryDesc = null;
        ArrayList<ExprNode> selectExpressions = new ArrayList<ExprNode>();
        ArrayList<String> assignedNames = new ArrayList<String>();
        boolean isWildcard = false;
        boolean isStreamWildcard = false;
        ExprEvaluator[] groupByEvaluators = null;
        ArrayList<ExprAggregateNode> aggExprNodes = new ArrayList<ExprAggregateNode>(2);
        ExprEvaluatorContextStatement evaluatorContextStmt = new ExprEvaluatorContextStatement(statementContext, false);
        ExprValidationContext validationContext = new ExprValidationContext(subselectTypeService, statementContext.getMethodResolutionService(), viewResourceDelegateSubselect, statementContext.getSchedulingService(), statementContext.getVariableService(), statementContext.getTableService(), evaluatorContextStmt, statementContext.getEventAdapterService(), statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getAnnotations(), statementContext.getContextDescriptor(), false, false, true, false, null, false);
        for (int i = 0; i < selectClauseSpec.getSelectExprList().length; ++i) {
            SelectClauseElementCompiled element = selectClauseSpec.getSelectExprList()[i];
            if (element instanceof SelectClauseExprCompiledSpec) {
                SelectClauseExprCompiledSpec compiled = (SelectClauseExprCompiledSpec)element;
                ExprNode selectExpression = compiled.getSelectExpression();
                selectExpression = ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.SELECT, selectExpression, validationContext);
                selectExpressions.add(selectExpression);
                if (compiled.getAssignedName() == null) {
                    assignedNames.add(ExprNodeUtility.toExpressionStringMinPrecedenceSafe(selectExpression));
                } else {
                    assignedNames.add(compiled.getAssignedName());
                }
                ExprAggregateNodeUtil.getAggregatesBottomUp(selectExpression, aggExprNodes);
                if (aggExprNodes.size() <= 0) continue;
                List<Pair<Integer, String>> propertiesNotAggregated = ExprNodeUtility.getExpressionProperties(selectExpression, false);
                for (Pair<Integer, String> pair : propertiesNotAggregated) {
                    if (pair.getFirst() != 0) continue;
                    throw new ExprValidationException("Subselect properties must all be within aggregation functions");
                }
                continue;
            }
            if (element instanceof SelectClauseElementWildcard) {
                isWildcard = true;
                continue;
            }
            if (!(element instanceof SelectClauseStreamCompiledSpec)) continue;
            isStreamWildcard = true;
        }
        ExprNodePropOrStreamSet nonAggregatedPropsSelect = ExprNodeUtility.getNonAggregatedProps(validationContext.getStreamTypeService().getEventTypes(), selectExpressions, contextPropertyRegistry);
        boolean bl = hasNonAggregatedProperties = !nonAggregatedPropsSelect.isEmpty();
        if (!selectExpressions.isEmpty()) {
            if (isWildcard || isStreamWildcard) {
                throw new ExprValidationException("Subquery multi-column select does not allow wildcard or stream wildcard when selecting multiple columns.");
            }
            if (selectExpressions.size() > 1 && !subselect.isAllowMultiColumnSelect()) {
                throw new ExprValidationException("Subquery multi-column select is not allowed in this context.");
            }
            if (statementSpec.getGroupByExpressions() == null && selectExpressions.size() > 1 && aggExprNodes.size() > 0 && hasNonAggregatedProperties) {
                throw new ExprValidationException("Subquery with multi-column select requires that either all or none of the selected columns are under aggregation, unless a group-by clause is also specified");
            }
            subselect.setSelectClause(selectExpressions.toArray(new ExprNode[selectExpressions.size()]));
            subselect.setSelectAsNames(assignedNames.toArray(new String[assignedNames.size()]));
        }
        ExprNodePropOrStreamSet propertiesGroupBy = null;
        if (aggExprNodes.size() > 0) {
            boolean hasGroupBy;
            if (statementSpec.getGroupByExpressions() != null && statementSpec.getGroupByExpressions().getGroupByRollupLevels() != null) {
                throw new ExprValidationException("Group-by expressions in a subselect may not have rollups");
            }
            ExprNode[] theGroupBy = statementSpec.getGroupByExpressions() == null ? null : statementSpec.getGroupByExpressions().getGroupByNodes();
            boolean bl2 = hasGroupBy = theGroupBy != null && theGroupBy.length > 0;
            if (hasGroupBy) {
                boolean allInGroupBy;
                ExprNode[] groupByNodes = statementSpec.getGroupByExpressions().getGroupByNodes();
                groupByEvaluators = new ExprEvaluator[groupByNodes.length];
                for (int i = 0; i < groupByNodes.length; ++i) {
                    groupByNodes[i] = ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.GROUPBY, groupByNodes[i], validationContext);
                    groupByEvaluators[i] = groupByNodes[i].getExprEvaluator();
                    String minimal = ExprNodeUtility.isMinimalExpression(groupByNodes[i]);
                    if (minimal == null) continue;
                    throw new ExprValidationException("Group-by expressions in a subselect may not have " + minimal);
                }
                propertiesGroupBy = ExprNodeUtility.getGroupByPropertiesValidateHasOne(groupByNodes);
                ExprNodePropOrStreamDesc firstNonZeroGroupBy = propertiesGroupBy.getFirstWithStreamNumNotZero();
                if (firstNonZeroGroupBy != null) {
                    throw new ExprValidationException("Subselect with group-by requires that group-by properties are provided by the subselect stream only (" + firstNonZeroGroupBy.getTextual() + " is not)");
                }
                String reasonMessage = propertiesGroupBy.notContainsAll(nonAggregatedPropsSelect);
                boolean bl3 = allInGroupBy = reasonMessage == null;
                if (!allInGroupBy) {
                    throw new ExprValidationException("Subselect with group-by requires non-aggregated properties in the select-clause to also appear in the group-by clause");
                }
            }
            for (ExprAggregateNode aggNode : aggExprNodes) {
                List<Pair<Integer, String>> propertiesNodesAggregated = ExprNodeUtility.getExpressionProperties(aggNode, true);
                for (Pair<Integer, String> pair : propertiesNodesAggregated) {
                    if (pair.getFirst() == 0) continue;
                    throw new ExprValidationException("Subselect aggregation functions cannot aggregate across correlated properties");
                }
                if (aggNode.getOptionalLocalGroupBy() == null) continue;
                throw new ExprValidationException("Subselect aggregations functions cannot specify a group-by");
            }
            ArrayList<ExprAggregateNodeGroupKey> groupKeyExpressions = null;
            ExprNode[] groupByExpressions = new ExprNode[]{};
            if (hasGroupBy) {
                groupByExpressions = statementSpec.getGroupByExpressions().getGroupByNodes();
                for (int i = 0; i < selectExpressions.size(); ++i) {
                    ExprNode selectExpression = (ExprNode)selectExpressions.get(i);
                    boolean revalidate = false;
                    for (int j = 0; j < groupByExpressions.length; ++j) {
                        List<Pair<ExprNode, ExprNode>> foundPairs = ExprNodeUtility.findExpression(selectExpression, groupByExpressions[j]);
                        for (Pair<ExprNode, ExprNode> pair : foundPairs) {
                            ExprAggregateNodeGroupKey replacement = new ExprAggregateNodeGroupKey(j, groupByEvaluators[j].getType());
                            if (pair.getFirst() == null) {
                                selectExpressions.set(i, replacement);
                            } else {
                                ExprNodeUtility.replaceChildNode(pair.getFirst(), pair.getSecond(), replacement);
                                revalidate = true;
                            }
                            if (groupKeyExpressions == null) {
                                groupKeyExpressions = new ArrayList<ExprAggregateNodeGroupKey>();
                            }
                            groupKeyExpressions.add(replacement);
                        }
                    }
                    if (!revalidate) continue;
                    selectExpression = ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.SELECT, selectExpression, validationContext);
                    selectExpressions.set(i, selectExpression);
                }
            }
            List<ExprAggregateNode> havingAgg = Collections.emptyList();
            List<ExprAggregateNode> orderByAgg = Collections.emptyList();
            aggregationServiceFactoryDesc = AggregationServiceFactoryFactory.getService(aggExprNodes, Collections.<ExprNode, String>emptyMap(), Collections.<ExprDeclaredNode>emptyList(), groupByExpressions, havingAgg, orderByAgg, groupKeyExpressions, hasGroupBy, annotations, statementContext.getVariableService(), false, true, statementSpec.getFilterRootNode(), statementSpec.getHavingExprRootNode(), statementContext.getAggregationServiceFactoryService(), subselectTypeService.getEventTypes(), statementContext.getMethodResolutionService(), null, statementSpec.getOptionalContextName(), null, null, false, false, false);
            if (!selectExpressions.isEmpty()) {
                subselect.setSelectClause(selectExpressions.toArray(new ExprNode[selectExpressions.size()]));
                subselect.setSelectAsNames(assignedNames.toArray(new String[assignedNames.size()]));
            }
        }
        if (statementSpec.getFilterRootNode() != null) {
            LinkedList<ExprAggregateNode> aggExprNodesFilter = new LinkedList<ExprAggregateNode>();
            ExprAggregateNodeUtil.getAggregatesBottomUp(statementSpec.getFilterRootNode(), aggExprNodesFilter);
            if (aggExprNodesFilter.size() > 0) {
                throw new ExprValidationException("Aggregation functions are not supported within subquery filters, consider using insert-into instead");
            }
        }
        ExprNode filterExpr = statementSpec.getFilterRootNode();
        if (filterStreamSpec instanceof TableQueryStreamSpec) {
            TableQueryStreamSpec table = (TableQueryStreamSpec)filterStreamSpec;
            filterExpr = ExprNodeUtility.connectExpressionsByLogicalAnd(table.getFilterExpressions(), filterExpr);
        }
        boolean correlatedSubquery = false;
        if (filterExpr != null) {
            if (JavaClassHelper.getBoxedType((filterExpr = ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.FILTER, filterExpr, validationContext)).getExprEvaluator().getType()) != Boolean.class) {
                throw new ExprValidationException("Subselect filter expression must return a boolean value");
            }
            ExprNodeIdentifierVisitor visitor = new ExprNodeIdentifierVisitor(true);
            filterExpr.accept(visitor);
            List<Pair<Integer, String>> propertiesNodes = visitor.getExprProperties();
            for (Pair<Integer, String> pair : propertiesNodes) {
                if (pair.getFirst() == 0) continue;
                correlatedSubquery = true;
                break;
            }
        }
        ViewResourceDelegateVerified viewResourceDelegateVerified = EPStatementStartMethodHelperViewResources.verifyPreviousAndPriorRequirements(new ViewFactoryChain[]{viewFactoryChain}, viewResourceDelegateSubselect);
        List<ExprPriorNode> priorNodes = viewResourceDelegateVerified.getPerStream()[0].getPriorRequestsAsList();
        List<ExprPreviousNode> previousNodes = viewResourceDelegateVerified.getPerStream()[0].getPreviousRequests();
        if (aggregationServiceFactoryDesc == null) {
            subselect.setSubselectAggregationType(ExprSubselectNode.SubqueryAggregationType.NONE);
        } else {
            subselect.setSubselectAggregationType(hasNonAggregatedProperties ? ExprSubselectNode.SubqueryAggregationType.AGGREGATED : ExprSubselectNode.SubqueryAggregationType.FULLY_AGGREGATED);
        }
        ExprEvaluator filterExprEval = filterExpr == null ? null : filterExpr.getExprEvaluator();
        ExprEvaluator assignedFilterExpr = aggregationServiceFactoryDesc != null ? null : filterExprEval;
        subselect.setFilterExpr(assignedFilterExpr);
        if (filterStreamSpec instanceof NamedWindowConsumerStreamSpec && correlatedSubquery && (namedSpec = (NamedWindowConsumerStreamSpec)filterStreamSpec).getOptPropertyEvaluator() != null) {
            throw new ExprValidationException("Failed to validate named window use in subquery, contained-event is only allowed for named windows when not correlated");
        }
        EPStatementStartMethodHelperSubselect.validateSubqueryDataWindow(subselect, correlatedSubquery, hasNonAggregatedProperties, propertiesGroupBy, nonAggregatedPropsSelect);
        if (filterStreamSpec instanceof NamedWindowConsumerStreamSpec && (namedSpec = (NamedWindowConsumerStreamSpec)filterStreamSpec).getFilterExpressions().isEmpty()) {
            boolean disableIndexShare;
            NamedWindowProcessor processor = services.getNamedWindowMgmtService().getProcessor(namedSpec.getWindowName());
            if (processor == null) {
                throw new ExprValidationException("A named window by name '" + namedSpec.getWindowName() + "' does not exist");
            }
            boolean bl4 = disableIndexShare = HintEnum.DISABLE_WINDOW_SUBQUERY_INDEXSHARE.getHint(annotations) != null;
            if (disableIndexShare && processor.isVirtualDataWindow()) {
                disableIndexShare = false;
            }
            if (!disableIndexShare && processor.isEnableSubqueryIndexShare()) {
                EPStatementStartMethodHelperSubselect.validateContextAssociation(statementContext, processor.getContextName(), "named window '" + processor.getNamedWindowName() + "'");
                if (queryPlanLogging && queryPlanLog.isInfoEnabled()) {
                    queryPlanLog.info((Object)"prefering shared index");
                }
                boolean fullTableScan = HintEnum.SET_NOINDEX.getHint(annotations) != null;
                ExcludePlanHint excludePlanHint = ExcludePlanHint.getHint(allStreamNames, statementContext);
                SubordPropPlan joinedPropPlan = QueryPlanIndexBuilder.getJoinProps(filterExpr, outerEventTypes.length, subselectTypeService.getEventTypes(), excludePlanHint);
                SubSelectStrategyFactoryIndexShare factory = new SubSelectStrategyFactoryIndexShare(statementContext.getStatementName(), statementContext.getStatementId(), subqueryNum, outerEventTypesSelect, processor, null, fullTableScan, indexHint, joinedPropPlan, filterExprEval, aggregationServiceFactoryDesc, groupByEvaluators, services.getTableService(), statementContext.getAnnotations(), statementContext.getStatementStopService());
                return new SubSelectStrategyFactoryDesc(subSelectActivation, factory, aggregationServiceFactoryDesc, priorNodes, previousNodes, subqueryNum);
            }
        }
        if (filterStreamSpec instanceof TableQueryStreamSpec) {
            TableQueryStreamSpec tableSpec = (TableQueryStreamSpec)filterStreamSpec;
            TableMetadata metadata = services.getTableService().getTableMetadata(tableSpec.getTableName());
            if (metadata == null) {
                throw new ExprValidationException("A table by name '" + tableSpec.getTableName() + "' does not exist");
            }
            EPStatementStartMethodHelperSubselect.validateContextAssociation(statementContext, metadata.getContextName(), "table '" + tableSpec.getTableName() + "'");
            boolean fullTableScan = HintEnum.SET_NOINDEX.getHint(annotations) != null;
            ExcludePlanHint excludePlanHint = ExcludePlanHint.getHint(allStreamNames, statementContext);
            SubordPropPlan joinedPropPlan = QueryPlanIndexBuilder.getJoinProps(filterExpr, outerEventTypes.length, subselectTypeService.getEventTypes(), excludePlanHint);
            SubSelectStrategyFactoryIndexShare factory = new SubSelectStrategyFactoryIndexShare(statementContext.getStatementName(), statementContext.getStatementId(), subqueryNum, outerEventTypesSelect, null, metadata, fullTableScan, indexHint, joinedPropPlan, filterExprEval, aggregationServiceFactoryDesc, groupByEvaluators, services.getTableService(), statementContext.getAnnotations(), statementContext.getStatementStopService());
            return new SubSelectStrategyFactoryDesc(subSelectActivation, factory, aggregationServiceFactoryDesc, priorNodes, previousNodes, subqueryNum);
        }
        Set<String> optionalUniqueProps = null;
        if (viewFactoryChain.getDataWindowViewFactoryCount() > 0) {
            optionalUniqueProps = ViewServiceHelper.getUniqueCandidateProperties(viewFactoryChain.getViewFactoryChain(), annotations);
        }
        if (filterStreamSpec instanceof NamedWindowConsumerStreamSpec) {
            NamedWindowConsumerStreamSpec namedSpec2 = (NamedWindowConsumerStreamSpec)filterStreamSpec;
            NamedWindowProcessor processor = services.getNamedWindowMgmtService().getProcessor(namedSpec2.getWindowName());
            optionalUniqueProps = processor.getOptionalUniqueKeyProps();
        }
        boolean fullTableScan = HintEnum.SET_NOINDEX.getHint(annotations) != null;
        Pair<EventTableFactory, SubordTableLookupStrategyFactory> indexPair = EPStatementStartMethodHelperSubselect.determineSubqueryIndexFactory(filterExpr, eventType, outerEventTypes, subselectTypeService, fullTableScan, queryPlanLogging, optionalUniqueProps, statementContext, subqueryNum);
        SubSelectStrategyFactoryLocalViewPreloaded factory = new SubSelectStrategyFactoryLocalViewPreloaded(subqueryNum, subSelectActivation, indexPair, filterExpr, filterExprEval, correlatedSubquery, aggregationServiceFactoryDesc, viewResourceDelegateVerified, groupByEvaluators);
        return new SubSelectStrategyFactoryDesc(subSelectActivation, factory, aggregationServiceFactoryDesc, priorNodes, previousNodes, subqueryNum);
    }

    public static String getSubqueryInfoText(int subqueryNum, ExprSubselectNode subselect) {
        String text = "subquery number " + (subqueryNum + 1);
        StreamSpecRaw streamRaw = subselect.getStatementSpecRaw().getStreamSpecs().get(0);
        if (streamRaw instanceof FilterStreamSpecRaw) {
            text = text + " querying " + ((FilterStreamSpecRaw)streamRaw).getRawFilterSpec().getEventTypeName();
        }
        return text;
    }

    private static String validateContextAssociation(StatementContext statementContext, String entityDeclaredContextName, String entityDesc) throws ExprValidationException {
        String optionalProvidedContextName;
        String string = optionalProvidedContextName = statementContext.getContextDescriptor() == null ? null : statementContext.getContextDescriptor().getContextName();
        if (!(entityDeclaredContextName == null || optionalProvidedContextName != null && optionalProvidedContextName.equals(entityDeclaredContextName))) {
            throw new ExprValidationException("Mismatch in context specification, the context for the " + entityDesc + " is '" + entityDeclaredContextName + "' and the query specifies " + (optionalProvidedContextName == null ? "no context " : "context '" + optionalProvidedContextName + "'"));
        }
        return null;
    }

    private static void validateSubqueryDataWindow(ExprSubselectNode subselectNode, boolean correlatedSubquery, boolean hasNonAggregatedProperties, ExprNodePropOrStreamSet propertiesGroupBy, ExprNodePropOrStreamSet nonAggregatedPropsSelect) throws ExprValidationException {
        StreamSpecCompiled streamSpec = subselectNode.getStatementSpecCompiled().getStreamSpecs()[0];
        if (!(streamSpec instanceof FilterStreamSpecCompiled) || streamSpec.getViewSpecs().length > 0) {
            return;
        }
        if (correlatedSubquery) {
            throw new ExprValidationException(MSG_SUBQUERY_REQUIRES_WINDOW);
        }
        if (hasNonAggregatedProperties) {
            if (propertiesGroupBy == null) {
                throw new ExprValidationException(MSG_SUBQUERY_REQUIRES_WINDOW);
            }
            String reason = nonAggregatedPropsSelect.notContainsAll(propertiesGroupBy);
            if (reason != null) {
                throw new ExprValidationException(MSG_SUBQUERY_REQUIRES_WINDOW);
            }
        }
    }
}

