/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.start.FireAndForgetInstance;
import com.espertech.esper.core.start.FireAndForgetInstanceTable;
import com.espertech.esper.core.start.FireAndForgetProcessor;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableService;
import com.espertech.esper.epl.table.mgmt.TableStateInstance;
import java.util.Collection;

public class FireAndForgetProcessorTable
extends FireAndForgetProcessor {
    private final TableService tableService;
    private final TableMetadata tableMetadata;

    public FireAndForgetProcessorTable(TableService tableService, TableMetadata tableMetadata) {
        this.tableService = tableService;
        this.tableMetadata = tableMetadata;
    }

    public TableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    @Override
    public EventType getEventTypeResultSetProcessor() {
        return this.tableMetadata.getInternalEventType();
    }

    @Override
    public EventType getEventTypePublic() {
        return this.tableMetadata.getPublicEventType();
    }

    @Override
    public String getContextName() {
        return this.tableMetadata.getContextName();
    }

    @Override
    public FireAndForgetInstance getProcessorInstanceContextById(int agentInstanceId) {
        TableStateInstance instance = this.tableService.getState(this.tableMetadata.getTableName(), agentInstanceId);
        if (instance == null) {
            return null;
        }
        return new FireAndForgetInstanceTable(instance);
    }

    @Override
    public FireAndForgetInstance getProcessorInstanceNoContext() {
        return this.getProcessorInstanceContextById(-1);
    }

    @Override
    public FireAndForgetInstance getProcessorInstance(AgentInstanceContext agentInstanceContext) {
        return this.getProcessorInstanceContextById(agentInstanceContext.getAgentInstanceId());
    }

    @Override
    public Collection<Integer> getProcessorInstancesAll() {
        return this.tableService.getAgentInstanceIds(this.tableMetadata.getTableName());
    }

    @Override
    public String getNamedWindowOrTableName() {
        return this.tableMetadata.getTableName();
    }

    @Override
    public boolean isVirtualDataWindow() {
        return false;
    }

    @Override
    public String[][] getUniqueIndexes(FireAndForgetInstance processorInstance) {
        return this.tableMetadata.getUniqueIndexes();
    }
}

