/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.dataflow.core;

import com.espertech.esper.client.dataflow.EPDataFlowSignal;
import com.espertech.esper.dataflow.core.OperatorStatisticsProvider;
import com.espertech.esper.dataflow.interfaces.EPDataFlowEmitter;

public class EPDataFlowEmitterWrapperWStatistics
implements EPDataFlowEmitter {
    private final EPDataFlowEmitter facility;
    private final int producerOpNum;
    private final OperatorStatisticsProvider statisticsProvider;
    private final boolean cpuStatistics;

    public EPDataFlowEmitterWrapperWStatistics(EPDataFlowEmitter facility, int producerOpNum, OperatorStatisticsProvider statisticsProvider, boolean cpuStatistics) {
        this.facility = facility;
        this.producerOpNum = producerOpNum;
        this.statisticsProvider = statisticsProvider;
        this.cpuStatistics = cpuStatistics;
    }

    @Override
    public void submit(Object object) {
        this.submitPort(0, object);
    }

    @Override
    public void submitSignal(EPDataFlowSignal signal) {
        this.facility.submitSignal(signal);
    }

    @Override
    public void submitPort(int portNumber, Object object) {
        if (!this.cpuStatistics) {
            this.facility.submitPort(portNumber, object);
            this.statisticsProvider.countSubmitPort(this.producerOpNum, portNumber);
        } else {
            long nanoTime = System.nanoTime();
            this.facility.submitPort(portNumber, object);
            long nanoTimDelta = System.nanoTime() - nanoTime;
            this.statisticsProvider.countSubmitPortWithTime(this.producerOpNum, portNumber, nanoTimDelta);
        }
    }
}

