/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.dataflow.ops;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.dataflow.EPDataFlowSignal;
import com.espertech.esper.client.dataflow.EPDataFlowSignalFinalMarker;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.context.activator.ViewableActivationResult;
import com.espertech.esper.core.context.activator.ViewableActivator;
import com.espertech.esper.core.context.activator.ViewableActivatorFactory;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactorySelectResult;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.StatementAgentInstanceUtil;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.StatementLifecycleSvcUtil;
import com.espertech.esper.core.start.EPStatementStartMethodHelperAssignExpr;
import com.espertech.esper.core.start.EPStatementStartMethodSelectDesc;
import com.espertech.esper.core.start.EPStatementStartMethodSelectUtil;
import com.espertech.esper.dataflow.annotations.DataFlowContext;
import com.espertech.esper.dataflow.annotations.DataFlowOpParameter;
import com.espertech.esper.dataflow.annotations.DataFlowOperator;
import com.espertech.esper.dataflow.interfaces.DataFlowOpCloseContext;
import com.espertech.esper.dataflow.interfaces.DataFlowOpInitializateContext;
import com.espertech.esper.dataflow.interfaces.DataFlowOpInitializeResult;
import com.espertech.esper.dataflow.interfaces.DataFlowOpInputPort;
import com.espertech.esper.dataflow.interfaces.DataFlowOpLifecycle;
import com.espertech.esper.dataflow.interfaces.DataFlowOpOpenContext;
import com.espertech.esper.dataflow.interfaces.DataFlowOpOutputPort;
import com.espertech.esper.dataflow.interfaces.EPDataFlowEmitter;
import com.espertech.esper.dataflow.ops.epl.EPLSelectDeliveryCallback;
import com.espertech.esper.dataflow.ops.epl.EPLSelectUpdateDispatchView;
import com.espertech.esper.dataflow.ops.epl.EPLSelectViewable;
import com.espertech.esper.dataflow.util.GraphTypeDesc;
import com.espertech.esper.epl.agg.rollup.GroupByExpressionHelper;
import com.espertech.esper.epl.annotation.AnnotationUtil;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.epl.expression.visitor.ExprNodeSubselectDeclaredDotVisitor;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.spec.FilterStreamSpecCompiled;
import com.espertech.esper.epl.spec.FilterStreamSpecRaw;
import com.espertech.esper.epl.spec.GroupByClauseExpressions;
import com.espertech.esper.epl.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.epl.spec.OrderByItem;
import com.espertech.esper.epl.spec.OuterJoinDesc;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.spec.OutputLimitRateType;
import com.espertech.esper.epl.spec.OutputLimitSpec;
import com.espertech.esper.epl.spec.SelectClauseSpecCompiled;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StatementSpecRaw;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecOptions;
import com.espertech.esper.epl.spec.StreamSpecRaw;
import com.espertech.esper.epl.spec.util.StatementSpecRawAnalyzer;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.view.OutputProcessViewCallback;
import com.espertech.esper.event.EventBeanAdapterFactory;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.metrics.instrumentation.InstrumentationAgent;
import com.espertech.esper.pattern.EvalRootFactoryNode;
import com.espertech.esper.pattern.PatternContext;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.HistoricalEventViewable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@DataFlowOperator
public class Select
implements OutputProcessViewCallback,
DataFlowOpLifecycle {
    private static final Log log = LogFactory.getLog(Select.class);
    @DataFlowOpParameter
    private StatementSpecRaw select;
    @DataFlowOpParameter
    private boolean iterate;
    private EPLSelectViewable[] viewablesPerPort;
    private EventBeanAdapterFactory[] adapterFactories;
    private AgentInstanceContext agentInstanceContext;
    private EPLSelectDeliveryCallback deliveryCallback;
    private StatementAgentInstanceFactorySelectResult selectResult;
    private boolean isOutputLimited;
    private boolean submitEventBean;
    @DataFlowContext
    private EPDataFlowEmitter graphContext;

    @Override
    public DataFlowOpInitializeResult initialize(DataFlowOpInitializateContext context) throws ExprValidationException {
        if (context.getInputPorts().isEmpty()) {
            throw new IllegalArgumentException("Select operator requires at least one input stream");
        }
        if (context.getOutputPorts().size() != 1) {
            throw new IllegalArgumentException("Select operator requires one output stream but produces " + context.getOutputPorts().size() + " streams");
        }
        DataFlowOpOutputPort portZero = context.getOutputPorts().get(0);
        if (portZero.getOptionalDeclaredType() != null && !portZero.getOptionalDeclaredType().isUnderlying()) {
            this.submitEventBean = true;
        }
        int numStreams = context.getInputPorts().size();
        this.adapterFactories = new EventBeanAdapterFactory[numStreams];
        for (int i = 0; i < numStreams; ++i) {
            EventType eventType = context.getInputPorts().get(i).getTypeDesc().getEventType();
            this.adapterFactories[i] = context.getStatementContext().getEventAdapterService().getAdapterFactoryForType(eventType);
        }
        StatementContext statementContext = context.getStatementContext();
        EPServicesContext servicesContext = context.getServicesContext();
        AgentInstanceContext agentInstanceContext = context.getAgentInstanceContext();
        if (this.select.getInsertIntoDesc() != null) {
            throw new ExprValidationException("Insert-into clause is not supported");
        }
        if (this.select.getSelectStreamSelectorEnum() != SelectClauseStreamSelectorEnum.ISTREAM_ONLY) {
            throw new ExprValidationException("Selecting remove-stream is not supported");
        }
        ExprNodeSubselectDeclaredDotVisitor visitor = StatementSpecRawAnalyzer.walkSubselectAndDeclaredDotExpr(this.select);
        GroupByClauseExpressions groupByExpressions = GroupByExpressionHelper.getGroupByRollupExpressions(this.select.getGroupByExpressions(), this.select.getSelectClauseSpec(), this.select.getHavingExprRootNode(), this.select.getOrderByList(), visitor);
        if (!visitor.getSubselects().isEmpty()) {
            throw new ExprValidationException("Subselects are not supported");
        }
        HashMap<Integer, FilterStreamSpecRaw> streams = new HashMap<Integer, FilterStreamSpecRaw>();
        for (int streamNum = 0; streamNum < this.select.getStreamSpecs().size(); ++streamNum) {
            StreamSpecRaw rawStreamSpec = this.select.getStreamSpecs().get(streamNum);
            if (!(rawStreamSpec instanceof FilterStreamSpecRaw)) {
                throw new ExprValidationException("From-clause must contain only streams and cannot contain patterns or other constructs");
            }
            streams.put(streamNum, (FilterStreamSpecRaw)rawStreamSpec);
        }
        ArrayList<FilterStreamSpecCompiled> streamSpecCompileds = new ArrayList<FilterStreamSpecCompiled>();
        for (int streamNum = 0; streamNum < this.select.getStreamSpecs().size(); ++streamNum) {
            FilterStreamSpecRaw filter = (FilterStreamSpecRaw)streams.get(streamNum);
            Map.Entry<Integer, DataFlowOpInputPort> inputPort = this.findInputPort(filter.getRawFilterSpec().getEventTypeName(), context.getInputPorts());
            if (inputPort == null) {
                throw new ExprValidationException("Failed to find stream '" + filter.getRawFilterSpec().getEventTypeName() + "' among input ports, input ports are " + Arrays.toString(this.getInputPortNames(context.getInputPorts())));
            }
            EventType eventType = inputPort.getValue().getTypeDesc().getEventType();
            String streamAlias = filter.getOptionalStreamName();
            FilterSpecCompiled filterSpecCompiled = new FilterSpecCompiled(eventType, streamAlias, new List[]{Collections.emptyList()}, null);
            FilterStreamSpecCompiled filterStreamSpecCompiled = new FilterStreamSpecCompiled(filterSpecCompiled, this.select.getStreamSpecs().get(0).getViewSpecs(), streamAlias, new StreamSpecOptions());
            streamSpecCompileds.add(filterStreamSpecCompiled);
        }
        SelectClauseSpecCompiled selectClauseCompiled = StatementLifecycleSvcUtil.compileSelectClause(this.select.getSelectClauseSpec());
        OutputLimitSpec outputLimitSpec = this.select.getOutputLimitSpec();
        boolean bl = this.isOutputLimited = outputLimitSpec != null;
        if (this.iterate) {
            if (outputLimitSpec != null) {
                throw new ExprValidationException("Output rate limiting is not supported with 'iterate'");
            }
            outputLimitSpec = new OutputLimitSpec(OutputLimitLimitType.SNAPSHOT, OutputLimitRateType.TERM);
        }
        Annotation[] mergedAnnotations = AnnotationUtil.mergeAnnotations(statementContext.getAnnotations(), context.getOperatorAnnotations());
        OrderByItem[] orderByArray = OrderByItem.toArray(this.select.getOrderByList());
        OuterJoinDesc[] outerJoinArray = OuterJoinDesc.toArray(this.select.getOuterJoinDescList());
        StreamSpecCompiled[] streamSpecArray = streamSpecCompileds.toArray(new StreamSpecCompiled[streamSpecCompileds.size()]);
        StatementSpecCompiled compiled = new StatementSpecCompiled(null, null, null, null, null, null, null, SelectClauseStreamSelectorEnum.ISTREAM_ONLY, selectClauseCompiled, streamSpecArray, outerJoinArray, this.select.getFilterExprRootNode(), this.select.getHavingExprRootNode(), outputLimitSpec, orderByArray, ExprSubselectNode.EMPTY_SUBSELECT_ARRAY, ExprNodeUtility.EMPTY_DECLARED_ARR, this.select.getReferencedVariables(), this.select.getRowLimitSpec(), CollectionUtil.EMPTY_STRING_ARRAY, mergedAnnotations, null, null, null, null, null, null, null, null, null, groupByExpressions, null, null);
        final EPLSelectViewable[] viewables = new EPLSelectViewable[context.getInputPorts().size()];
        this.viewablesPerPort = viewables;
        for (Map.Entry<Integer, DataFlowOpInputPort> entry : context.getInputPorts().entrySet()) {
            EPLSelectViewable viewable;
            viewables[entry.getKey().intValue()] = viewable = new EPLSelectViewable(entry.getValue().getTypeDesc().getEventType());
        }
        ViewableActivatorFactory activatorFactory = new ViewableActivatorFactory(){

            @Override
            public ViewableActivator createActivatorSimple(FilterStreamSpecCompiled filterStreamSpec) {
                EPLSelectViewable found = null;
                for (EPLSelectViewable viewable : viewables) {
                    if (viewable.getEventType() != filterStreamSpec.getFilterSpec().getFilterForEventType()) continue;
                    found = viewable;
                }
                if (found == null) {
                    throw new IllegalStateException("Failed to find viewable for filter");
                }
                final EPLSelectViewable viewable = found;
                return new ViewableActivator(){

                    @Override
                    public ViewableActivationResult activate(AgentInstanceContext agentInstanceContext, boolean isSubselect, boolean isRecoveringResilient) {
                        return new ViewableActivationResult(viewable, new StopCallback(){

                            @Override
                            public void stop() {
                            }
                        }, null, null, null, false, false, null);
                    }
                };
            }

            @Override
            public ViewableActivator createFilterProxy(EPServicesContext services, FilterSpecCompiled filterSpec, Annotation[] annotations, boolean subselect, InstrumentationAgent instrumentationAgentSubquery, boolean isCanIterate, Integer streamNumFromClause) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ViewableActivator createStreamReuseView(EPServicesContext services, StatementContext statementContext, StatementSpecCompiled statementSpec, FilterStreamSpecCompiled filterStreamSpec, boolean isJoin, ExprEvaluatorContextStatement evaluatorContextStmt, boolean filterSubselectSameStream, int streamNum, boolean isCanIterateUnbound) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ViewableActivator createPattern(PatternContext patternContext, EvalRootFactoryNode rootFactoryNode, EventType eventType, boolean consumingFilters, boolean suppressSameEventMatches, boolean discardPartialsOnMatch, boolean isCanIterateUnbound) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ViewableActivator createNamedWindow(NamedWindowProcessor processor, NamedWindowConsumerStreamSpec streamSpec, StatementContext statementContext) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ViewableActivator createTable(TableMetadata metadata, ExprEvaluator[] optionalTableFilters) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ViewableActivator makeHistorical(HistoricalEventViewable historicalEventViewable) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ViewableActivator makeSubqueryNWIndexShare() {
                throw new UnsupportedOperationException();
            }
        };
        Select optionalOutputProcessViewCallback = null;
        if (!this.iterate && !this.isOutputLimited) {
            this.deliveryCallback = new EPLSelectDeliveryCallback();
            optionalOutputProcessViewCallback = this;
        }
        EPStatementStartMethodSelectDesc selectDesc = EPStatementStartMethodSelectUtil.prepare(compiled, servicesContext, statementContext, false, agentInstanceContext, false, activatorFactory, optionalOutputProcessViewCallback, this.deliveryCallback);
        this.selectResult = (StatementAgentInstanceFactorySelectResult)selectDesc.getStatementAgentInstanceFactorySelect().newContext(agentInstanceContext, false);
        if (this.isOutputLimited) {
            this.selectResult.getFinalView().addView(new EPLSelectUpdateDispatchView(this));
        }
        EPStatementStartMethodHelperAssignExpr.assignExpressionStrategies(selectDesc, this.selectResult.getOptionalAggegationService(), this.selectResult.getSubselectStrategies(), this.selectResult.getPriorNodeStrategies(), this.selectResult.getPreviousNodeStrategies(), null, null, this.selectResult.getTableAccessEvalStrategies());
        EventType outputEventType = selectDesc.getResultSetProcessorPrototypeDesc().getResultSetProcessorFactory().getResultEventType();
        this.agentInstanceContext = agentInstanceContext;
        return new DataFlowOpInitializeResult(new GraphTypeDesc[]{new GraphTypeDesc(false, true, outputEventType)});
    }

    private String[] getInputPortNames(Map<Integer, DataFlowOpInputPort> inputPorts) {
        ArrayList<String> portNames = new ArrayList<String>();
        for (Map.Entry<Integer, DataFlowOpInputPort> entry : inputPorts.entrySet()) {
            if (entry.getValue().getOptionalAlias() != null) {
                portNames.add(entry.getValue().getOptionalAlias());
                continue;
            }
            if (entry.getValue().getStreamNames().size() != 1) continue;
            portNames.add(entry.getValue().getStreamNames().iterator().next());
        }
        return portNames.toArray(new String[portNames.size()]);
    }

    private Map.Entry<Integer, DataFlowOpInputPort> findInputPort(String eventTypeName, Map<Integer, DataFlowOpInputPort> inputPorts) {
        for (Map.Entry<Integer, DataFlowOpInputPort> entry : inputPorts.entrySet()) {
            if (entry.getValue().getOptionalAlias() != null && entry.getValue().getOptionalAlias().equals(eventTypeName)) {
                return entry;
            }
            if (entry.getValue().getStreamNames().size() != 1 || !entry.getValue().getStreamNames().iterator().next().equals(eventTypeName)) continue;
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInput(int originatingStream, Object row) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received row from stream " + originatingStream + " for select, row is " + row));
        }
        EventBean theEvent = this.adapterFactories[originatingStream].makeAdapter(row);
        this.agentInstanceContext.getStatementContext().getDefaultAgentInstanceLock().acquireWriteLock();
        try {
            this.viewablesPerPort[originatingStream].process(theEvent);
            if (this.viewablesPerPort.length > 1) {
                this.agentInstanceContext.getEpStatementAgentInstanceHandle().getOptionalDispatchable().execute();
            }
        }
        finally {
            if (this.agentInstanceContext.getStatementContext().getEpStatementHandle().isHasTableAccess()) {
                this.agentInstanceContext.getStatementContext().getTableExprEvaluatorContext().releaseAcquiredLocks();
            }
            this.agentInstanceContext.getStatementContext().getDefaultAgentInstanceLock().releaseWriteLock();
        }
    }

    public void onSignal(EPDataFlowSignal signal) {
        Iterator<EventBean> it;
        if (this.iterate && signal instanceof EPDataFlowSignalFinalMarker && (it = this.selectResult.getFinalView().iterator()) != null) {
            while (it.hasNext()) {
                EventBean event = it.next();
                if (this.submitEventBean) {
                    this.graphContext.submit(event);
                    continue;
                }
                this.graphContext.submit(event.getUnderlying());
            }
        }
    }

    @Override
    public void open(DataFlowOpOpenContext openContext) {
    }

    @Override
    public void close(DataFlowOpCloseContext openContext) {
        if (this.selectResult != null) {
            StatementAgentInstanceUtil.stopSafe(this.selectResult.getStopCallback(), this.agentInstanceContext.getStatementContext());
        }
    }

    @Override
    public void outputViaCallback(EventBean[] events) {
        Object[] delivered = this.deliveryCallback.getDelivered();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Submitting select-output row: " + Arrays.toString(delivered)));
        }
        this.graphContext.submit(this.deliveryCallback.getDelivered());
        this.deliveryCallback.reset();
    }

    public void outputOutputRateLimited(UniformPair<EventBean[]> result) {
        if (result == null || result.getFirst() == null || result.getFirst().length == 0) {
            return;
        }
        for (EventBean item : result.getFirst()) {
            if (this.submitEventBean) {
                this.graphContext.submit(item);
                continue;
            }
            this.graphContext.submit(item.getUnderlying());
        }
    }
}

