/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.aggregator;

import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AggregatorAvgBigDecimal
implements AggregationMethod {
    private static final Log log = LogFactory.getLog(AggregatorAvgBigDecimal.class);
    protected BigDecimal sum = new BigDecimal(0.0);
    protected long numDataPoints;
    protected MathContext optionalMathContext;

    public AggregatorAvgBigDecimal(MathContext optionalMathContext) {
        this.optionalMathContext = optionalMathContext;
    }

    @Override
    public void clear() {
        this.sum = new BigDecimal(0.0);
        this.numDataPoints = 0L;
    }

    @Override
    public void enter(Object object) {
        if (object == null) {
            return;
        }
        ++this.numDataPoints;
        if (object instanceof BigInteger) {
            this.sum = this.sum.add(new BigDecimal((BigInteger)object));
            return;
        }
        this.sum = this.sum.add((BigDecimal)object);
    }

    @Override
    public void leave(Object object) {
        if (object == null) {
            return;
        }
        if (this.numDataPoints <= 1L) {
            this.clear();
        } else {
            --this.numDataPoints;
            this.sum = object instanceof BigInteger ? this.sum.subtract(new BigDecimal((BigInteger)object)) : this.sum.subtract((BigDecimal)object);
        }
    }

    @Override
    public Object getValue() {
        if (this.numDataPoints == 0L) {
            return null;
        }
        try {
            if (this.optionalMathContext == null) {
                return this.sum.divide(new BigDecimal(this.numDataPoints));
            }
            return this.sum.divide(new BigDecimal(this.numDataPoints), this.optionalMathContext);
        }
        catch (ArithmeticException ex) {
            log.error((Object)("Error computing avg aggregation result: " + ex.getMessage()), (Throwable)ex);
            return new BigDecimal(0);
        }
    }

    @Override
    public Class getValueType() {
        return Double.class;
    }
}

