/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service;

import com.espertech.esper.client.annotation.Hint;
import com.espertech.esper.client.annotation.HintEnum;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.access.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.service.AggSvcGroupByReclaimAgedEvalFunc;
import com.espertech.esper.epl.agg.service.AggSvcGroupByReclaimAgedEvalFuncConstant;
import com.espertech.esper.epl.agg.service.AggSvcGroupByReclaimAgedEvalFuncFactory;
import com.espertech.esper.epl.agg.service.AggSvcGroupByReclaimAgedEvalFuncVariable;
import com.espertech.esper.epl.agg.service.AggSvcGroupByReclaimAgedImpl;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.agg.service.AggregationServiceFactoryBase;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.variable.VariableMetaData;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.epl.variable.VariableServiceUtil;
import com.espertech.esper.type.DoubleValue;
import com.espertech.esper.util.JavaClassHelper;

public class AggSvcGroupByReclaimAgedFactory
extends AggregationServiceFactoryBase {
    private static final long DEFAULT_MAX_AGE_MSEC = 60000L;
    protected final AggregationAccessorSlotPair[] accessors;
    protected final AggregationStateFactory[] accessAggregations;
    protected final boolean isJoin;
    protected final AggSvcGroupByReclaimAgedEvalFuncFactory evaluationFunctionMaxAge;
    protected final AggSvcGroupByReclaimAgedEvalFuncFactory evaluationFunctionFrequency;

    public AggSvcGroupByReclaimAgedFactory(ExprEvaluator[] evaluators, AggregationMethodFactory[] prototypes, Object groupKeyBinding, Hint reclaimGroupAged, Hint reclaimGroupFrequency, VariableService variableService, AggregationAccessorSlotPair[] accessors, AggregationStateFactory[] accessAggregations, boolean isJoin, String optionalContextName) throws ExprValidationException {
        super(evaluators, prototypes, groupKeyBinding);
        this.accessors = accessors;
        this.accessAggregations = accessAggregations;
        this.isJoin = isJoin;
        String hintValueMaxAge = HintEnum.RECLAIM_GROUP_AGED.getHintAssignedValue(reclaimGroupAged);
        if (hintValueMaxAge == null) {
            throw new ExprValidationException("Required hint value for hint '" + (Object)((Object)HintEnum.RECLAIM_GROUP_AGED) + "' has not been provided");
        }
        this.evaluationFunctionMaxAge = this.getEvaluationFunction(variableService, hintValueMaxAge, optionalContextName);
        String hintValueFrequency = HintEnum.RECLAIM_GROUP_FREQ.getHintAssignedValue(reclaimGroupAged);
        this.evaluationFunctionFrequency = reclaimGroupFrequency == null || hintValueFrequency == null ? this.evaluationFunctionMaxAge : this.getEvaluationFunction(variableService, hintValueFrequency, optionalContextName);
    }

    @Override
    public AggregationService makeService(AgentInstanceContext agentInstanceContext, MethodResolutionService methodResolutionService, boolean isSubquery, Integer subqueryNumber) {
        AggSvcGroupByReclaimAgedEvalFunc max = this.evaluationFunctionMaxAge.make(agentInstanceContext);
        AggSvcGroupByReclaimAgedEvalFunc freq = this.evaluationFunctionFrequency.make(agentInstanceContext);
        return new AggSvcGroupByReclaimAgedImpl(this.evaluators, this.aggregators, this.groupKeyBinding, this.accessors, this.accessAggregations, this.isJoin, max, freq, methodResolutionService);
    }

    private AggSvcGroupByReclaimAgedEvalFuncFactory getEvaluationFunction(final VariableService variableService, String hintValue, String optionalContextName) throws ExprValidationException {
        Double valueDouble;
        final VariableMetaData variableMetaData = variableService.getVariableMetaData(hintValue);
        if (variableMetaData != null) {
            if (!JavaClassHelper.isNumeric(variableMetaData.getType())) {
                throw new ExprValidationException("Variable type of variable '" + variableMetaData.getVariableName() + "' is not numeric");
            }
            String message = VariableServiceUtil.checkVariableContextName(optionalContextName, variableMetaData);
            if (message != null) {
                throw new ExprValidationException(message);
            }
            return new AggSvcGroupByReclaimAgedEvalFuncFactory(){

                @Override
                public AggSvcGroupByReclaimAgedEvalFunc make(AgentInstanceContext agentInstanceContext) {
                    VariableReader reader = variableService.getReader(variableMetaData.getVariableName(), agentInstanceContext.getAgentInstanceId());
                    return new AggSvcGroupByReclaimAgedEvalFuncVariable(reader);
                }
            };
        }
        try {
            valueDouble = DoubleValue.parseString(hintValue);
        }
        catch (RuntimeException ex) {
            throw new ExprValidationException("Failed to parse hint parameter value '" + hintValue + "' as a double-typed seconds value or variable name");
        }
        if (valueDouble <= 0.0) {
            throw new ExprValidationException("Hint parameter value '" + hintValue + "' is an invalid value, expecting a double-typed seconds value or variable name");
        }
        return new AggSvcGroupByReclaimAgedEvalFuncFactory(){

            @Override
            public AggSvcGroupByReclaimAgedEvalFunc make(AgentInstanceContext agentInstanceContext) {
                return new AggSvcGroupByReclaimAgedEvalFuncConstant(valueDouble);
            }
        };
    }
}

