/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.service.AggregationMethodPairRow;
import com.espertech.esper.epl.agg.service.AggregationRowRemovedCallback;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.agg.service.AggregationServiceVisitor;
import com.espertech.esper.epl.agg.service.AggregationServiceVisitorWGroupDetail;
import com.espertech.esper.epl.agg.util.AggregationLocalGroupByColumn;
import com.espertech.esper.epl.agg.util.AggregationLocalGroupByLevel;
import com.espertech.esper.epl.agg.util.AggregationLocalGroupByPlan;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AggSvcGroupLocalGroupByBase
implements AggregationService {
    protected final MethodResolutionService methodResolutionService;
    protected final boolean isJoin;
    protected final AggregationLocalGroupByPlan localGroupByPlan;
    protected final Object groupKeyBinding;
    protected AggregationMethod[] aggregatorsTopLevel;
    protected AggregationState[] statesTopLevel;
    protected Map<Object, AggregationMethodPairRow>[] aggregatorsPerLevelAndGroup;
    protected List<Pair<Integer, Object>> removedKeys;

    protected abstract Object computeGroupKey(AggregationLocalGroupByLevel var1, Object var2, ExprEvaluator[] var3, EventBean[] var4, boolean var5, ExprEvaluatorContext var6);

    public AggSvcGroupLocalGroupByBase(MethodResolutionService methodResolutionService, boolean isJoin, AggregationLocalGroupByPlan localGroupByPlan, Object groupKeyBinding) {
        this.methodResolutionService = methodResolutionService;
        this.isJoin = isJoin;
        this.localGroupByPlan = localGroupByPlan;
        this.groupKeyBinding = groupKeyBinding;
        this.aggregatorsPerLevelAndGroup = new Map[localGroupByPlan.getAllLevels().length];
        for (int i = 0; i < localGroupByPlan.getAllLevels().length; ++i) {
            this.aggregatorsPerLevelAndGroup[i] = new HashMap<Object, AggregationMethodPairRow>();
        }
        this.removedKeys = new ArrayList<Pair<Integer, Object>>();
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
        AggSvcGroupLocalGroupByBase.clearResults(this.aggregatorsPerLevelAndGroup, this.aggregatorsTopLevel, this.statesTopLevel);
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, Object groupByKeyProvided, ExprEvaluatorContext exprEvaluatorContext) {
        this.handleRemovedKeys();
        if (this.localGroupByPlan.getOptionalLevelTop() != null) {
            if (this.aggregatorsTopLevel == null) {
                this.aggregatorsTopLevel = this.methodResolutionService.newAggregators(this.localGroupByPlan.getOptionalLevelTop().getMethodFactories(), exprEvaluatorContext.getAgentInstanceId(), null, null, null);
                this.statesTopLevel = this.methodResolutionService.newAccesses(exprEvaluatorContext.getAgentInstanceId(), this.isJoin, this.localGroupByPlan.getOptionalLevelTop().getStateFactories(), null, null, null, null);
            }
            AggSvcGroupLocalGroupByBase.aggregateIntoEnter(this.localGroupByPlan.getOptionalLevelTop(), this.aggregatorsTopLevel, this.statesTopLevel, eventsPerStream, exprEvaluatorContext);
            this.internalHandleUpdatedTop();
        }
        for (int levelNum = 0; levelNum < this.localGroupByPlan.getAllLevels().length; ++levelNum) {
            ExprEvaluator[] partitionEval;
            AggregationLocalGroupByLevel level = this.localGroupByPlan.getAllLevels()[levelNum];
            Object groupByKey = this.computeGroupKey(level, groupByKeyProvided, partitionEval = level.getPartitionEvaluators(), eventsPerStream, true, exprEvaluatorContext);
            AggregationMethodPairRow row = this.aggregatorsPerLevelAndGroup[levelNum].get(groupByKey);
            if (row == null) {
                AggregationMethod[] rowAggregators = this.methodResolutionService.newAggregators(level.getMethodFactories(), exprEvaluatorContext.getAgentInstanceId(), groupByKey, null, null);
                AggregationState[] rowStates = this.methodResolutionService.newAccesses(exprEvaluatorContext.getAgentInstanceId(), this.isJoin, level.getStateFactories(), groupByKey, null, null, null);
                row = new AggregationMethodPairRow(this.methodResolutionService.getCurrentRowCount(rowAggregators, rowStates) + 1L, rowAggregators, rowStates);
                this.aggregatorsPerLevelAndGroup[levelNum].put(groupByKey, row);
            } else {
                row.increaseRefcount();
            }
            AggSvcGroupLocalGroupByBase.aggregateIntoEnter(level, row.getMethods(), row.getStates(), eventsPerStream, exprEvaluatorContext);
            this.internalHandleUpdatedGroup(levelNum, groupByKey, row);
        }
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, Object groupByKeyProvided, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.localGroupByPlan.getOptionalLevelTop() != null) {
            if (this.aggregatorsTopLevel == null) {
                this.aggregatorsTopLevel = this.methodResolutionService.newAggregators(this.localGroupByPlan.getOptionalLevelTop().getMethodFactories(), exprEvaluatorContext.getAgentInstanceId(), null, null, null);
                this.statesTopLevel = this.methodResolutionService.newAccesses(exprEvaluatorContext.getAgentInstanceId(), this.isJoin, this.localGroupByPlan.getOptionalLevelTop().getStateFactories(), null, null, null, null);
            }
            AggSvcGroupLocalGroupByBase.aggregateIntoLeave(this.localGroupByPlan.getOptionalLevelTop(), this.aggregatorsTopLevel, this.statesTopLevel, eventsPerStream, exprEvaluatorContext);
            this.internalHandleUpdatedTop();
        }
        for (int levelNum = 0; levelNum < this.localGroupByPlan.getAllLevels().length; ++levelNum) {
            ExprEvaluator[] partitionEval;
            AggregationLocalGroupByLevel level = this.localGroupByPlan.getAllLevels()[levelNum];
            Object groupByKey = this.computeGroupKey(level, groupByKeyProvided, partitionEval = level.getPartitionEvaluators(), eventsPerStream, true, exprEvaluatorContext);
            AggregationMethodPairRow row = this.aggregatorsPerLevelAndGroup[levelNum].get(groupByKey);
            if (row == null) {
                AggregationMethod[] rowAggregators = this.methodResolutionService.newAggregators(level.getMethodFactories(), exprEvaluatorContext.getAgentInstanceId(), groupByKey, null, null);
                AggregationState[] rowStates = this.methodResolutionService.newAccesses(exprEvaluatorContext.getAgentInstanceId(), this.isJoin, level.getStateFactories(), groupByKey, null, null, null);
                row = new AggregationMethodPairRow(this.methodResolutionService.getCurrentRowCount(rowAggregators, rowStates) + 1L, rowAggregators, rowStates);
                this.aggregatorsPerLevelAndGroup[levelNum].put(groupByKey, row);
            } else {
                row.decreaseRefcount();
                if (row.getRefcount() <= 0L) {
                    this.removedKeys.add(new Pair<Integer, Object>(levelNum, groupByKey));
                }
            }
            AggSvcGroupLocalGroupByBase.aggregateIntoLeave(level, row.getMethods(), row.getStates(), eventsPerStream, exprEvaluatorContext);
            this.internalHandleUpdatedGroup(levelNum, groupByKey, row);
        }
    }

    @Override
    public Collection<EventBean> getCollectionOfEvents(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        AggregationLocalGroupByColumn col = this.localGroupByPlan.getColumns()[column];
        if (col.getPartitionEvaluators().length == 0) {
            return col.getPair().getAccessor().getEnumerableEvents(this.statesTopLevel[col.getPair().getSlot()], eventsPerStream, isNewData, context);
        }
        Object groupByKey = AggSvcGroupLocalGroupByBase.computeGroupKey(col.getPartitionEvaluators(), eventsPerStream, isNewData, context);
        AggregationMethodPairRow row = this.aggregatorsPerLevelAndGroup[col.getLevelNum()].get(groupByKey);
        return col.getPair().getAccessor().getEnumerableEvents(row.getStates()[col.getPair().getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public Collection<Object> getCollectionScalar(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        AggregationLocalGroupByColumn col = this.localGroupByPlan.getColumns()[column];
        if (col.getPartitionEvaluators().length == 0) {
            return col.getPair().getAccessor().getEnumerableScalar(this.statesTopLevel[col.getPair().getSlot()], eventsPerStream, isNewData, context);
        }
        Object groupByKey = AggSvcGroupLocalGroupByBase.computeGroupKey(col.getPartitionEvaluators(), eventsPerStream, isNewData, context);
        AggregationMethodPairRow row = this.aggregatorsPerLevelAndGroup[col.getLevelNum()].get(groupByKey);
        return col.getPair().getAccessor().getEnumerableScalar(row.getStates()[col.getPair().getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public EventBean getEventBean(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        AggregationLocalGroupByColumn col = this.localGroupByPlan.getColumns()[column];
        if (col.getPartitionEvaluators().length == 0) {
            return col.getPair().getAccessor().getEnumerableEvent(this.statesTopLevel[col.getPair().getSlot()], eventsPerStream, isNewData, context);
        }
        Object groupByKey = AggSvcGroupLocalGroupByBase.computeGroupKey(col.getPartitionEvaluators(), eventsPerStream, isNewData, context);
        AggregationMethodPairRow row = this.aggregatorsPerLevelAndGroup[col.getLevelNum()].get(groupByKey);
        return col.getPair().getAccessor().getEnumerableEvent(row.getStates()[col.getPair().getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public boolean isGrouped() {
        return true;
    }

    @Override
    public void setRemovedCallback(AggregationRowRemovedCallback callback) {
    }

    @Override
    public void accept(AggregationServiceVisitor visitor) {
        visitor.visitAggregations(this.getNumGroups(), this.aggregatorsTopLevel, this.statesTopLevel, this.aggregatorsPerLevelAndGroup);
    }

    @Override
    public void acceptGroupDetail(AggregationServiceVisitorWGroupDetail visitor) {
        visitor.visitGrouped(this.getNumGroups());
        if (this.aggregatorsTopLevel != null) {
            visitor.visitGroup(null, this.aggregatorsTopLevel, this.statesTopLevel);
        }
        for (int i = 0; i < this.localGroupByPlan.getAllLevels().length; ++i) {
            for (Map.Entry<Object, AggregationMethodPairRow> entry : this.aggregatorsPerLevelAndGroup[i].entrySet()) {
                visitor.visitGroup(entry.getKey(), entry.getValue());
            }
        }
    }

    public void internalHandleUpdatedGroup(int level, Object groupByKey, AggregationMethodPairRow row) {
    }

    public void internalHandleUpdatedTop() {
    }

    public void internalHandleGroupRemove(Pair<Integer, Object> groupByKey) {
    }

    public void handleRemovedKeys() {
        if (!this.removedKeys.isEmpty()) {
            for (Pair<Integer, Object> removedKey : this.removedKeys) {
                this.aggregatorsPerLevelAndGroup[removedKey.getFirst()].remove(removedKey.getSecond());
                this.internalHandleGroupRemove(removedKey);
            }
            this.removedKeys.clear();
        }
    }

    @Override
    public Object getGroupKey(int agentInstanceId) {
        return null;
    }

    @Override
    public Collection<Object> getGroupKeys(ExprEvaluatorContext exprEvaluatorContext) {
        throw new UnsupportedOperationException();
    }

    public static Object computeGroupKey(ExprEvaluator[] partitionEval, EventBean[] eventsPerStream, boolean b, ExprEvaluatorContext exprEvaluatorContext) {
        if (partitionEval.length == 1) {
            return partitionEval[0].evaluate(eventsPerStream, true, exprEvaluatorContext);
        }
        Object[] keys = new Object[partitionEval.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = partitionEval[i].evaluate(eventsPerStream, true, exprEvaluatorContext);
        }
        return new MultiKeyUntyped(keys);
    }

    public static void aggregateIntoEnter(AggregationLocalGroupByLevel level, AggregationMethod[] methods, AggregationState[] states, EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        int i;
        for (i = 0; i < level.getMethodEvaluators().length; ++i) {
            Object value = level.getMethodEvaluators()[i].evaluate(eventsPerStream, true, exprEvaluatorContext);
            methods[i].enter(value);
        }
        for (i = 0; i < states.length; ++i) {
            states[i].applyEnter(eventsPerStream, exprEvaluatorContext);
        }
    }

    public static void aggregateIntoLeave(AggregationLocalGroupByLevel level, AggregationMethod[] methods, AggregationState[] states, EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        int i;
        for (i = 0; i < level.getMethodEvaluators().length; ++i) {
            Object value = level.getMethodEvaluators()[i].evaluate(eventsPerStream, false, exprEvaluatorContext);
            methods[i].leave(value);
        }
        for (i = 0; i < states.length; ++i) {
            states[i].applyLeave(eventsPerStream, exprEvaluatorContext);
        }
    }

    protected static void clearResults(Map<Object, AggregationMethodPairRow>[] aggregatorsPerLevelAndGroup, AggregationMethod[] aggregatorsTopLevel, AggregationState[] statesTopLevel) {
        for (Map<Object, AggregationMethodPairRow> aggregatorsPerGroup : aggregatorsPerLevelAndGroup) {
            aggregatorsPerGroup.clear();
        }
        if (aggregatorsTopLevel != null) {
            for (AggregationMethod method : aggregatorsTopLevel) {
                method.clear();
            }
            for (AggregationState state : statesTopLevel) {
                state.clear();
            }
        }
    }

    public AggregationMethod[] getAggregatorsTopLevel() {
        return this.aggregatorsTopLevel;
    }

    public void setAggregatorsTopLevel(AggregationMethod[] aggregatorsTopLevel) {
        this.aggregatorsTopLevel = aggregatorsTopLevel;
    }

    public AggregationState[] getStatesTopLevel() {
        return this.statesTopLevel;
    }

    public void setStatesTopLevel(AggregationState[] statesTopLevel) {
        this.statesTopLevel = statesTopLevel;
    }

    public Map<Object, AggregationMethodPairRow>[] getAggregatorsPerLevelAndGroup() {
        return this.aggregatorsPerLevelAndGroup;
    }

    public void setAggregatorsPerLevelAndGroup(Map<Object, AggregationMethodPairRow>[] aggregatorsPerLevelAndGroup) {
        this.aggregatorsPerLevelAndGroup = aggregatorsPerLevelAndGroup;
    }

    public List<Pair<Integer, Object>> getRemovedKeys() {
        return this.removedKeys;
    }

    public void setRemovedKeys(List<Pair<Integer, Object>> removedKeys) {
        this.removedKeys = removedKeys;
    }

    @Override
    public void stop() {
    }

    private int getNumGroups() {
        int size = this.aggregatorsTopLevel != null ? 1 : 0;
        for (int i = 0; i < this.localGroupByPlan.getAllLevels().length; ++i) {
            size += this.aggregatorsPerLevelAndGroup[i].size();
        }
        return size;
    }
}

