/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service;

import com.espertech.esper.collection.MultiKeyUntyped;
import java.util.Arrays;

public class AggregationGroupByRollupLevel {
    private final int levelNumber;
    private final int levelOffset;
    private final int[] rollupKeys;

    public AggregationGroupByRollupLevel(int levelNumber, int levelOffset, int[] rollupKeys) {
        this.levelNumber = levelNumber;
        this.levelOffset = levelOffset;
        this.rollupKeys = rollupKeys;
    }

    public int getLevelNumber() {
        return this.levelNumber;
    }

    public int getAggregationOffset() {
        if (this.isAggregationTop()) {
            throw new IllegalArgumentException();
        }
        return this.levelOffset;
    }

    public boolean isAggregationTop() {
        return this.levelOffset == -1;
    }

    public int[] getRollupKeys() {
        return this.rollupKeys;
    }

    public Object computeSubkey(Object groupKey) {
        if (this.isAggregationTop()) {
            return null;
        }
        if (groupKey instanceof MultiKeyUntyped) {
            MultiKeyUntyped mk = (MultiKeyUntyped)groupKey;
            Object[] keys = mk.getKeys();
            if (this.rollupKeys.length == keys.length) {
                return mk;
            }
            if (this.rollupKeys.length == 1) {
                return keys[this.rollupKeys[0]];
            }
            Object[] subkeys = new Object[this.rollupKeys.length];
            int count = 0;
            for (int rollupKey : this.rollupKeys) {
                subkeys[count++] = keys[rollupKey];
            }
            return new MultiKeyUntyped(subkeys);
        }
        return groupKey;
    }

    public String toString() {
        return "GroupByRollupLevel{levelOffset=" + this.levelOffset + ", rollupKeys=" + Arrays.toString(this.rollupKeys) + '}';
    }

    public MultiKeyUntyped computeMultiKey(Object subkey, int numExpected) {
        if (subkey instanceof MultiKeyUntyped) {
            MultiKeyUntyped mk = (MultiKeyUntyped)subkey;
            if (mk.getKeys().length == numExpected) {
                return mk;
            }
            Object[] keys = new Object[]{numExpected};
            for (int i = 0; i < this.rollupKeys.length; ++i) {
                keys[this.rollupKeys[i]] = mk.getKeys()[i];
            }
            return new MultiKeyUntyped(keys);
        }
        Object[] keys = new Object[numExpected];
        if (subkey == null) {
            return new MultiKeyUntyped(keys);
        }
        keys[this.rollupKeys[0]] = subkey;
        return new MultiKeyUntyped(keys);
    }
}

