/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service;

import com.espertech.esper.epl.agg.access.AggregationAccessor;
import com.espertech.esper.epl.agg.access.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.access.AggregationStateKey;
import com.espertech.esper.epl.agg.service.AggregationMultiFunctionAnalysisResult;
import com.espertech.esper.epl.agg.service.AggregationServiceAggExpressionDesc;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateLocalGroupByDesc;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class AggregationMultiFunctionAnalysisHelper {
    public static AggregationMultiFunctionAnalysisResult analyzeAccessAggregations(List<AggregationServiceAggExpressionDesc> aggregations) {
        int currentSlot = 0;
        ArrayDeque<AggregationMFIdentifier> accessProviderSlots = new ArrayDeque<AggregationMFIdentifier>();
        ArrayList<AggregationAccessorSlotPair> accessorPairs = new ArrayList<AggregationAccessorSlotPair>();
        ArrayList<AggregationStateFactory> stateFactories = new ArrayList<AggregationStateFactory>();
        for (AggregationServiceAggExpressionDesc aggregation : aggregations) {
            int slot;
            ExprAggregateNode aggregateNode = aggregation.getAggregationNode();
            if (!aggregateNode.getFactory().isAccessAggregation()) continue;
            AggregationStateKey providerKey = aggregateNode.getFactory().getAggregationStateKey(false);
            AggregationMFIdentifier existing = AggregationMultiFunctionAnalysisHelper.findExisting(accessProviderSlots, providerKey, aggregateNode.getOptionalLocalGroupBy());
            if (existing == null) {
                accessProviderSlots.add(new AggregationMFIdentifier(providerKey, aggregateNode.getOptionalLocalGroupBy(), currentSlot));
                slot = currentSlot++;
                AggregationStateFactory providerFactory = aggregateNode.getFactory().getAggregationStateFactory(false);
                stateFactories.add(providerFactory);
            } else {
                slot = existing.getSlot();
            }
            AggregationAccessor accessor = aggregateNode.getFactory().getAccessor();
            accessorPairs.add(new AggregationAccessorSlotPair(slot, accessor));
        }
        AggregationAccessorSlotPair[] pairs = accessorPairs.toArray(new AggregationAccessorSlotPair[accessorPairs.size()]);
        AggregationStateFactory[] accessAggregations = stateFactories.toArray(new AggregationStateFactory[stateFactories.size()]);
        return new AggregationMultiFunctionAnalysisResult(pairs, accessAggregations);
    }

    private static AggregationMFIdentifier findExisting(Deque<AggregationMFIdentifier> accessProviderSlots, AggregationStateKey providerKey, ExprAggregateLocalGroupByDesc optionalOver) {
        for (AggregationMFIdentifier ident : accessProviderSlots) {
            if (!providerKey.equals(ident.getAggregationStateKey())) continue;
            if (optionalOver == null && ident.optionalLocalGroupBy == null) {
                return ident;
            }
            if (optionalOver == null || ident.optionalLocalGroupBy == null || !ExprNodeUtility.deepEqualsIgnoreDupAndOrder(optionalOver.getPartitionExpressions(), ident.optionalLocalGroupBy.getPartitionExpressions())) continue;
            return ident;
        }
        return null;
    }

    private static class AggregationMFIdentifier {
        private final AggregationStateKey aggregationStateKey;
        private final ExprAggregateLocalGroupByDesc optionalLocalGroupBy;
        private final int slot;

        private AggregationMFIdentifier(AggregationStateKey aggregationStateKey, ExprAggregateLocalGroupByDesc optionalLocalGroupBy, int slot) {
            this.aggregationStateKey = aggregationStateKey;
            this.optionalLocalGroupBy = optionalLocalGroupBy;
            this.slot = slot;
        }

        public AggregationStateKey getAggregationStateKey() {
            return this.aggregationStateKey;
        }

        public ExprAggregateLocalGroupByDesc getOptionalLocalGroupBy() {
            return this.optionalLocalGroupBy;
        }

        public int getSlot() {
            return this.slot;
        }
    }
}

