/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.annotation.Hint;
import com.espertech.esper.client.annotation.HintEnum;
import com.espertech.esper.client.annotation.HookType;
import com.espertech.esper.epl.agg.access.AggregationAccessor;
import com.espertech.esper.epl.agg.access.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.access.AggregationAgent;
import com.espertech.esper.epl.agg.service.AggregationGroupByRollupDesc;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationMultiFunctionAnalysisHelper;
import com.espertech.esper.epl.agg.service.AggregationMultiFunctionAnalysisResult;
import com.espertech.esper.epl.agg.service.AggregationServiceAggExpressionDesc;
import com.espertech.esper.epl.agg.service.AggregationServiceFactory;
import com.espertech.esper.epl.agg.service.AggregationServiceFactoryDesc;
import com.espertech.esper.epl.agg.service.AggregationServiceFactoryService;
import com.espertech.esper.epl.agg.service.AggregationServiceMatchRecognizeFactoryDesc;
import com.espertech.esper.epl.agg.service.AggregationServiceMatchRecognizeFactoryImpl;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.agg.util.AggregationGroupByLocalGroupByAnalyzer;
import com.espertech.esper.epl.agg.util.AggregationGroupByLocalGroupDesc;
import com.espertech.esper.epl.agg.util.AggregationGroupByLocalGroupLevel;
import com.espertech.esper.epl.agg.util.AggregationLocalGroupByPlan;
import com.espertech.esper.epl.agg.util.AggregationLocalLevelHook;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.declexpr.ExprDeclaredNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateLocalGroupByDesc;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeGroupKey;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.methodagg.ExprMethodAggUtil;
import com.espertech.esper.epl.expression.table.ExprTableNodeUtil;
import com.espertech.esper.epl.expression.visitor.ExprNodePreviousVisitorWParent;
import com.espertech.esper.epl.spec.IntoTableSpec;
import com.espertech.esper.epl.table.mgmt.TableColumnMethodPair;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumnAggregation;
import com.espertech.esper.epl.table.mgmt.TableService;
import com.espertech.esper.epl.util.EPLValidationUtil;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class AggregationServiceFactoryFactory {
    public static AggregationServiceMatchRecognizeFactoryDesc getServiceMatchRecognize(int numStreams, Map<Integer, List<ExprAggregateNode>> measureExprNodesPerStream, EventType[] typesPerStream) throws ExprValidationException {
        TreeMap<Integer, ArrayList<AggregationServiceAggExpressionDesc>> equivalencyListPerStream = new TreeMap<Integer, ArrayList<AggregationServiceAggExpressionDesc>>();
        for (Map.Entry<Integer, List<ExprAggregateNode>> entry : measureExprNodesPerStream.entrySet()) {
            ArrayList<AggregationServiceAggExpressionDesc> equivalencyList = new ArrayList<AggregationServiceAggExpressionDesc>();
            equivalencyListPerStream.put(entry.getKey(), equivalencyList);
            for (ExprAggregateNode selectAggNode : entry.getValue()) {
                AggregationServiceFactoryFactory.addEquivalent(selectAggNode, equivalencyList);
            }
        }
        LinkedHashMap<Integer, AggregationMethodFactory[]> aggregatorsPerStream = new LinkedHashMap<Integer, AggregationMethodFactory[]>();
        HashMap<Integer, ExprEvaluator[]> evaluatorsPerStream = new HashMap<Integer, ExprEvaluator[]>();
        for (Map.Entry equivalencyPerStream : equivalencyListPerStream.entrySet()) {
            int index = 0;
            int stream = (Integer)equivalencyPerStream.getKey();
            AggregationMethodFactory[] aggregators = new AggregationMethodFactory[((List)equivalencyPerStream.getValue()).size()];
            aggregatorsPerStream.put(stream, aggregators);
            ExprEvaluator[] evaluators = new ExprEvaluator[((List)equivalencyPerStream.getValue()).size()];
            evaluatorsPerStream.put(stream, evaluators);
            for (AggregationServiceAggExpressionDesc aggregation : (List)equivalencyPerStream.getValue()) {
                ExprAggregateNode aggregateNode = aggregation.getAggregationNode();
                evaluators[index] = aggregateNode.getChildNodes().length > 1 ? ExprMethodAggUtil.getMultiNodeEvaluator(aggregateNode.getChildNodes(), typesPerStream.length > 1, typesPerStream) : (aggregateNode.getChildNodes().length > 0 ? aggregateNode.getChildNodes()[0].getExprEvaluator() : new ExprEvaluator(){

                    @Override
                    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                        return null;
                    }

                    @Override
                    public Class getType() {
                        return null;
                    }
                });
                aggregators[index] = aggregateNode.getFactory();
                ++index;
            }
        }
        int columnNumber = 0;
        ArrayList<AggregationServiceAggExpressionDesc> allExpressions = new ArrayList<AggregationServiceAggExpressionDesc>();
        for (Map.Entry equivalencyPerStream : equivalencyListPerStream.entrySet()) {
            for (AggregationServiceAggExpressionDesc entry : (List)equivalencyPerStream.getValue()) {
                entry.setColumnNum(columnNumber++);
            }
            allExpressions.addAll((Collection)equivalencyPerStream.getValue());
        }
        AggregationServiceMatchRecognizeFactoryImpl factory = new AggregationServiceMatchRecognizeFactoryImpl(numStreams, aggregatorsPerStream, evaluatorsPerStream);
        return new AggregationServiceMatchRecognizeFactoryDesc(factory, allExpressions);
    }

    public static AggregationServiceFactoryDesc getService(List<ExprAggregateNode> selectAggregateExprNodes, Map<ExprNode, String> selectClauseNamedNodes, List<ExprDeclaredNode> declaredExpressions, ExprNode[] groupByNodes, List<ExprAggregateNode> havingAggregateExprNodes, List<ExprAggregateNode> orderByAggregateExprNodes, List<ExprAggregateNodeGroupKey> groupKeyExpressions, boolean hasGroupByClause, Annotation[] annotations, VariableService variableService, boolean isJoin, boolean isDisallowNoReclaim, ExprNode whereClause, ExprNode havingClause, AggregationServiceFactoryService factoryService, EventType[] typesPerStream, MethodResolutionService methodResolutionService, AggregationGroupByRollupDesc groupByRollupDesc, String optionalContextName, IntoTableSpec intoTableSpec, TableService tableService, boolean isUnidirectional, boolean isFireAndForget, boolean isOnSelect) throws ExprValidationException {
        AggregationServiceFactory serviceFactory;
        if (selectAggregateExprNodes.isEmpty() && havingAggregateExprNodes.isEmpty()) {
            if (intoTableSpec != null) {
                throw new ExprValidationException("Into-table requires at least one aggregation function");
            }
            return new AggregationServiceFactoryDesc(factoryService.getNullAggregationService(), Collections.<AggregationServiceAggExpressionDesc>emptyList(), Collections.<ExprAggregateNodeGroupKey>emptyList());
        }
        if (whereClause != null || havingClause != null) {
            ExprNodePreviousVisitorWParent visitor = new ExprNodePreviousVisitorWParent();
            if (whereClause != null) {
                whereClause.accept(visitor);
            }
            if (havingClause != null) {
                havingClause.accept(visitor);
            }
            if (visitor.getPrevious() != null && !visitor.getPrevious().isEmpty()) {
                String funcname = visitor.getPrevious().get(0).getSecond().getPreviousType().toString().toLowerCase();
                throw new ExprValidationException("The '" + funcname + "' function may not occur in the where-clause or having-clause of a statement with aggregations as 'previous' does not provide remove stream data; Use the 'first','last','window' or 'count' aggregation functions instead");
            }
        }
        ArrayList<AggregationServiceAggExpressionDesc> aggregations = new ArrayList<AggregationServiceAggExpressionDesc>();
        for (ExprAggregateNode selectAggNode : selectAggregateExprNodes) {
            AggregationServiceFactoryFactory.addEquivalent(selectAggNode, aggregations);
        }
        for (ExprAggregateNode havingAggNode : havingAggregateExprNodes) {
            AggregationServiceFactoryFactory.addEquivalent(havingAggNode, aggregations);
        }
        for (ExprAggregateNode orderByAggNode : orderByAggregateExprNodes) {
            AggregationServiceFactoryFactory.addEquivalent(orderByAggNode, aggregations);
        }
        ArrayList<ExprEvaluator> methodAggEvaluatorsList = new ArrayList<ExprEvaluator>();
        for (AggregationServiceAggExpressionDesc aggregation : aggregations) {
            ExprAggregateNode aggregateNode = aggregation.getAggregationNode();
            if (aggregateNode.getFactory().isAccessAggregation()) continue;
            ExprEvaluator evaluator = aggregateNode.getFactory().getMethodAggregationEvaluator(typesPerStream.length > 1, typesPerStream);
            methodAggEvaluatorsList.add(evaluator);
        }
        AggregationGroupByLocalGroupDesc localGroupDesc = AggregationServiceFactoryFactory.analyzeLocalGroupBy(aggregations, groupByNodes, groupByRollupDesc, intoTableSpec);
        if (intoTableSpec != null) {
            TableMetadata metadata = tableService.getTableMetadata(intoTableSpec.getName());
            if (metadata == null) {
                throw new ExprValidationException("Invalid into-table clause: Failed to find table by name '" + intoTableSpec.getName() + "'");
            }
            EPLValidationUtil.validateContextName(true, intoTableSpec.getName(), metadata.getContextName(), optionalContextName, false);
            Class[] groupByTypes = ExprNodeUtility.getExprResultTypes(groupByNodes);
            ExprTableNodeUtil.validateExpressions(intoTableSpec.getName(), groupByTypes, "group-by", groupByNodes, metadata.getKeyTypes(), "group-by");
            BindingMatchResult bindingMatchResult = AggregationServiceFactoryFactory.matchBindingsAssignColumnNumbers(intoTableSpec, metadata, aggregations, selectClauseNamedNodes, methodAggEvaluatorsList, declaredExpressions);
            AggregationServiceFactory serviceFactory2 = !hasGroupByClause ? factoryService.getNoGroupWBinding(bindingMatchResult.getAccessors(), isJoin, bindingMatchResult.getMethodPairs(), intoTableSpec.getName(), bindingMatchResult.getTargetStates(), bindingMatchResult.getAccessStateExpr(), bindingMatchResult.getAgents()) : factoryService.getGroupWBinding(metadata, bindingMatchResult.getMethodPairs(), bindingMatchResult.getAccessors(), isJoin, intoTableSpec, bindingMatchResult.getTargetStates(), bindingMatchResult.getAccessStateExpr(), bindingMatchResult.getAgents(), groupByRollupDesc);
            return new AggregationServiceFactoryDesc(serviceFactory2, aggregations, groupKeyExpressions);
        }
        int columnNumber = 0;
        for (AggregationServiceAggExpressionDesc entry : aggregations) {
            if (entry.getFactory().isAccessAggregation()) continue;
            entry.setColumnNum(columnNumber++);
        }
        for (AggregationServiceAggExpressionDesc entry : aggregations) {
            if (!entry.getFactory().isAccessAggregation()) continue;
            entry.setColumnNum(columnNumber++);
        }
        ExprEvaluator[] methodAggEvaluators = methodAggEvaluatorsList.toArray(new ExprEvaluator[methodAggEvaluatorsList.size()]);
        AggregationMethodFactory[] methodAggFactories = new AggregationMethodFactory[methodAggEvaluators.length];
        int count = 0;
        for (AggregationServiceAggExpressionDesc aggregation : aggregations) {
            ExprAggregateNode aggregateNode = aggregation.getAggregationNode();
            if (aggregateNode.getFactory().isAccessAggregation()) continue;
            methodAggFactories[count] = aggregateNode.getFactory();
            ++count;
        }
        AggregationMultiFunctionAnalysisResult multiFunctionAggPlan = AggregationMultiFunctionAnalysisHelper.analyzeAccessAggregations(aggregations);
        AggregationAccessorSlotPair[] accessorPairs = multiFunctionAggPlan.getAccessorPairs();
        AggregationStateFactory[] accessAggregations = multiFunctionAggPlan.getStateFactories();
        AggregationLocalGroupByPlan localGroupByPlan = null;
        if (localGroupDesc != null) {
            localGroupByPlan = AggregationGroupByLocalGroupByAnalyzer.analyze(methodAggEvaluators, methodAggFactories, accessAggregations, localGroupDesc, groupByNodes, accessorPairs);
            try {
                AggregationLocalLevelHook hook = (AggregationLocalLevelHook)JavaClassHelper.getAnnotationHook(annotations, HookType.INTERNAL_AGGLOCALLEVEL, AggregationLocalLevelHook.class, null);
                if (hook != null) {
                    hook.planned(localGroupDesc, localGroupByPlan);
                }
            }
            catch (ExprValidationException e) {
                throw new EPException("Failed to obtain hook for " + (Object)((Object)HookType.INTERNAL_AGGLOCALLEVEL));
            }
        }
        if (!hasGroupByClause) {
            if (localGroupByPlan != null) {
                Object groupKeyBinding = methodResolutionService.getGroupKeyBinding(localGroupByPlan);
                serviceFactory = factoryService.getNoGroupLocalGroupBy(isJoin, localGroupByPlan, groupKeyBinding, isUnidirectional, isFireAndForget, isOnSelect);
            } else {
                serviceFactory = methodAggEvaluators.length > 0 && accessorPairs.length == 0 ? factoryService.getNoGroupNoAccess(methodAggEvaluators, methodAggFactories, isUnidirectional, isFireAndForget, isOnSelect) : (methodAggEvaluators.length == 0 && accessorPairs.length > 0 ? factoryService.getNoGroupAccessOnly(accessorPairs, accessAggregations, isJoin, isUnidirectional, isFireAndForget, isOnSelect) : factoryService.getNoGroupAccessMixed(methodAggEvaluators, methodAggFactories, accessorPairs, accessAggregations, isJoin, isUnidirectional, isFireAndForget, isOnSelect));
            }
        } else {
            boolean hasNoReclaim = HintEnum.DISABLE_RECLAIM_GROUP.getHint(annotations) != null;
            Hint reclaimGroupAged = HintEnum.RECLAIM_GROUP_AGED.getHint(annotations);
            Hint reclaimGroupFrequency = HintEnum.RECLAIM_GROUP_AGED.getHint(annotations);
            if (localGroupByPlan != null) {
                Object groupKeyBinding = methodResolutionService.getGroupKeyBinding(localGroupByPlan);
                serviceFactory = factoryService.getGroupLocalGroupBy(isJoin, localGroupByPlan, groupKeyBinding, isUnidirectional, isFireAndForget, isOnSelect);
            } else {
                Object groupKeyBinding = methodResolutionService.getGroupKeyBinding(groupByNodes, groupByRollupDesc);
                if (!isDisallowNoReclaim && hasNoReclaim) {
                    if (groupByRollupDesc != null) {
                        throw AggregationServiceFactoryFactory.getRollupReclaimEx();
                    }
                    serviceFactory = methodAggEvaluators.length > 0 && accessorPairs.length == 0 ? factoryService.getGroupedNoReclaimNoAccess(methodAggEvaluators, methodAggFactories, groupKeyBinding, isUnidirectional, isFireAndForget, isOnSelect) : (methodAggEvaluators.length == 0 && accessorPairs.length > 0 ? factoryService.getGroupNoReclaimAccessOnly(accessorPairs, accessAggregations, groupKeyBinding, isJoin, isUnidirectional, isFireAndForget, isOnSelect) : factoryService.getGroupNoReclaimMixed(methodAggEvaluators, methodAggFactories, accessorPairs, accessAggregations, isJoin, groupKeyBinding, isUnidirectional, isFireAndForget, isOnSelect));
                } else if (!isDisallowNoReclaim && reclaimGroupAged != null) {
                    if (groupByRollupDesc != null) {
                        throw AggregationServiceFactoryFactory.getRollupReclaimEx();
                    }
                    serviceFactory = factoryService.getGroupReclaimAged(methodAggEvaluators, methodAggFactories, reclaimGroupAged, reclaimGroupFrequency, variableService, accessorPairs, accessAggregations, isJoin, groupKeyBinding, optionalContextName, isUnidirectional, isFireAndForget, isOnSelect);
                } else {
                    serviceFactory = groupByRollupDesc != null ? factoryService.getGroupReclaimMixableRollup(methodAggEvaluators, methodAggFactories, accessorPairs, accessAggregations, isJoin, groupKeyBinding, groupByRollupDesc, isUnidirectional, isFireAndForget, isOnSelect) : (methodAggEvaluators.length > 0 && accessorPairs.length == 0 ? factoryService.getGroupReclaimNoAccess(methodAggEvaluators, methodAggFactories, accessorPairs, accessAggregations, isJoin, groupKeyBinding, isUnidirectional, isFireAndForget, isOnSelect) : factoryService.getGroupReclaimMixable(methodAggEvaluators, methodAggFactories, accessorPairs, accessAggregations, isJoin, groupKeyBinding, isUnidirectional, isFireAndForget, isOnSelect));
                }
            }
        }
        return new AggregationServiceFactoryDesc(serviceFactory, aggregations, groupKeyExpressions);
    }

    private static AggregationGroupByLocalGroupDesc analyzeLocalGroupBy(List<AggregationServiceAggExpressionDesc> aggregations, ExprNode[] groupByNodes, AggregationGroupByRollupDesc groupByRollupDesc, IntoTableSpec intoTableSpec) throws ExprValidationException {
        boolean hasOver = false;
        for (AggregationServiceAggExpressionDesc desc : aggregations) {
            if (desc.getAggregationNode().getOptionalLocalGroupBy() == null) continue;
            hasOver = true;
            break;
        }
        if (!hasOver) {
            return null;
        }
        if (groupByRollupDesc != null) {
            throw new ExprValidationException("Roll-up and group-by parameters cannot be combined");
        }
        if (intoTableSpec != null) {
            throw new ExprValidationException("Into-table and group-by parameters cannot be combined");
        }
        ArrayList<AggregationGroupByLocalGroupLevel> partitions = new ArrayList<AggregationGroupByLocalGroupLevel>();
        for (AggregationServiceAggExpressionDesc desc : aggregations) {
            ExprAggregateLocalGroupByDesc localGroupBy = desc.getAggregationNode().getOptionalLocalGroupBy();
            ExprNode[] partitionExpressions = localGroupBy == null ? groupByNodes : localGroupBy.getPartitionExpressions();
            List<AggregationServiceAggExpressionDesc> found = AggregationServiceFactoryFactory.findPartition(partitions, partitionExpressions);
            if (found == null) {
                found = new ArrayList<AggregationServiceAggExpressionDesc>();
                AggregationGroupByLocalGroupLevel level = new AggregationGroupByLocalGroupLevel(partitionExpressions, found);
                partitions.add(level);
            }
            found.add(desc);
        }
        if (partitions.size() == 1 && ExprNodeUtility.deepEqualsIgnoreDupAndOrder(((AggregationGroupByLocalGroupLevel)partitions.get(0)).getPartitionExpr(), groupByNodes)) {
            return null;
        }
        return new AggregationGroupByLocalGroupDesc(aggregations.size(), partitions.toArray(new AggregationGroupByLocalGroupLevel[partitions.size()]));
    }

    private static List<AggregationServiceAggExpressionDesc> findPartition(List<AggregationGroupByLocalGroupLevel> partitions, ExprNode[] partitionExpressions) {
        for (AggregationGroupByLocalGroupLevel level : partitions) {
            if (!ExprNodeUtility.deepEqualsIgnoreDupAndOrder(level.getPartitionExpr(), partitionExpressions)) continue;
            return level.getExpressions();
        }
        return null;
    }

    private static BindingMatchResult matchBindingsAssignColumnNumbers(IntoTableSpec bindings, TableMetadata metadata, List<AggregationServiceAggExpressionDesc> aggregations, Map<ExprNode, String> selectClauseNamedNodes, List<ExprEvaluator> methodAggEvaluatorsList, List<ExprDeclaredNode> declaredExpressions) throws ExprValidationException {
        LinkedHashMap<AggregationServiceAggExpressionDesc, TableMetadataColumnAggregation> methodAggs = new LinkedHashMap<AggregationServiceAggExpressionDesc, TableMetadataColumnAggregation>();
        LinkedHashMap<AggregationServiceAggExpressionDesc, TableMetadataColumnAggregation> accessAggs = new LinkedHashMap<AggregationServiceAggExpressionDesc, TableMetadataColumnAggregation>();
        for (AggregationServiceAggExpressionDesc aggDesc : aggregations) {
            String columnName = AggregationServiceFactoryFactory.findColumnNameForAggregation(selectClauseNamedNodes, declaredExpressions, aggDesc.getAggregationNode());
            if (columnName == null) {
                throw new ExprValidationException("Failed to find an expression among the select-clause expressions for expression '" + ExprNodeUtility.toExpressionStringMinPrecedenceSafe(aggDesc.getAggregationNode()) + "'");
            }
            TableMetadataColumnAggregation columnMetadata = (TableMetadataColumnAggregation)metadata.getTableColumns().get(columnName);
            if (columnMetadata == null) {
                throw new ExprValidationException("Failed to find name '" + columnName + "' among the columns for table '" + bindings.getName() + "'");
            }
            AggregationServiceFactoryFactory.validateIntoTableCompatible(bindings.getName(), columnName, columnMetadata, aggDesc);
            if (!columnMetadata.getFactory().isAccessAggregation()) {
                methodAggs.put(aggDesc, columnMetadata);
                continue;
            }
            accessAggs.put(aggDesc, columnMetadata);
        }
        TableColumnMethodPair[] methodPairs = new TableColumnMethodPair[methodAggEvaluatorsList.size()];
        int methodIndex = -1;
        for (Map.Entry methodEntry : methodAggs.entrySet()) {
            int targetIndex = ((TableMetadataColumnAggregation)methodEntry.getValue()).getMethodOffset();
            methodPairs[++methodIndex] = new TableColumnMethodPair(methodAggEvaluatorsList.get(methodIndex), targetIndex, ((AggregationServiceAggExpressionDesc)methodEntry.getKey()).getAggregationNode());
            ((AggregationServiceAggExpressionDesc)methodEntry.getKey()).setColumnNum(targetIndex);
        }
        LinkedHashMap<Integer, ExprAggregateNode> accessSlots = new LinkedHashMap<Integer, ExprAggregateNode>();
        ArrayList<AggregationAccessorSlotPair> accessReadPairs = new ArrayList<AggregationAccessorSlotPair>();
        int accessIndex = -1;
        ArrayList<AggregationAgent> agents = new ArrayList<AggregationAgent>();
        for (Map.Entry accessEntry : accessAggs.entrySet()) {
            ++accessIndex;
            int slot = ((TableMetadataColumnAggregation)accessEntry.getValue()).getAccessAccessorSlotPair().getSlot();
            AggregationMethodFactory aggregationMethodFactory = ((AggregationServiceAggExpressionDesc)accessEntry.getKey()).getFactory();
            AggregationAccessor accessor = aggregationMethodFactory.getAccessor();
            accessSlots.put(slot, ((AggregationServiceAggExpressionDesc)accessEntry.getKey()).getAggregationNode());
            accessReadPairs.add(new AggregationAccessorSlotPair(slot, accessor));
            ((AggregationServiceAggExpressionDesc)accessEntry.getKey()).setColumnNum(metadata.getNumberMethodAggregations() + accessIndex);
            agents.add(aggregationMethodFactory.getAggregationStateAgent());
        }
        AggregationAgent[] agentArr = agents.toArray(new AggregationAgent[agents.size()]);
        AggregationAccessorSlotPair[] accessReads = accessReadPairs.toArray(new AggregationAccessorSlotPair[accessReadPairs.size()]);
        int[] targetStates = new int[accessSlots.size()];
        ExprNode[] accessStateExpr = new ExprNode[accessSlots.size()];
        int count = 0;
        for (Map.Entry entry : accessSlots.entrySet()) {
            targetStates[count] = (Integer)entry.getKey();
            accessStateExpr[count] = (ExprNode)entry.getValue();
            ++count;
        }
        return new BindingMatchResult(methodPairs, accessReads, targetStates, accessStateExpr, agentArr);
    }

    private static String findColumnNameForAggregation(Map<ExprNode, String> selectClauseNamedNodes, List<ExprDeclaredNode> declaredExpressions, ExprAggregateNode aggregationNode) {
        if (selectClauseNamedNodes.containsKey(aggregationNode)) {
            return selectClauseNamedNodes.get(aggregationNode);
        }
        for (ExprDeclaredNode node : declaredExpressions) {
            if (node.getBody() != aggregationNode) continue;
            return node.getPrototype().getName();
        }
        return null;
    }

    private static void validateIntoTableCompatible(String tableName, String columnName, TableMetadataColumnAggregation columnMetadata, AggregationServiceAggExpressionDesc aggDesc) throws ExprValidationException {
        AggregationMethodFactory factoryProvided = aggDesc.getFactory();
        AggregationMethodFactory factoryRequired = columnMetadata.getFactory();
        try {
            factoryRequired.validateIntoTableCompatible(factoryProvided);
        }
        catch (ExprValidationException ex) {
            String text = AggregationServiceFactoryFactory.getMessage(tableName, columnName, factoryRequired.getAggregationExpression(), factoryProvided.getAggregationExpression());
            throw new ExprValidationException(text + ": " + ex.getMessage(), ex);
        }
    }

    private static String getMessage(String tableName, String columnName, ExprAggregateNodeBase aggregationRequired, ExprAggregateNodeBase aggregationProvided) {
        return "Incompatible aggregation function for table '" + tableName + "' column '" + columnName + "', expecting '" + ExprNodeUtility.toExpressionStringMinPrecedenceSafe(aggregationRequired) + "' and received '" + ExprNodeUtility.toExpressionStringMinPrecedenceSafe(aggregationProvided) + "'";
    }

    private static void addEquivalent(ExprAggregateNode aggNodeToAdd, List<AggregationServiceAggExpressionDesc> equivalencyList) {
        boolean foundEquivalent = false;
        for (AggregationServiceAggExpressionDesc existing : equivalencyList) {
            ExprAggregateNode aggNode = existing.getAggregationNode();
            if (!aggNode.equalsNode(aggNodeToAdd) || !ExprNodeUtility.deepEquals(aggNode.getPositionalParams(), aggNodeToAdd.getPositionalParams()) || (aggNode.getOptionalLocalGroupBy() != null || aggNodeToAdd.getOptionalLocalGroupBy() != null) && (aggNode.getOptionalLocalGroupBy() == null && aggNodeToAdd.getOptionalLocalGroupBy() != null || aggNode.getOptionalLocalGroupBy() != null && aggNodeToAdd.getOptionalLocalGroupBy() == null || !ExprNodeUtility.deepEqualsIgnoreDupAndOrder(aggNode.getOptionalLocalGroupBy().getPartitionExpressions(), aggNodeToAdd.getOptionalLocalGroupBy().getPartitionExpressions()))) continue;
            existing.addEquivalent(aggNodeToAdd);
            foundEquivalent = true;
            break;
        }
        if (!foundEquivalent) {
            equivalencyList.add(new AggregationServiceAggExpressionDesc(aggNodeToAdd, aggNodeToAdd.getFactory()));
        }
    }

    public static ExprValidationException getRollupReclaimEx() {
        return new ExprValidationException("Reclaim hints are not available with rollup");
    }

    private static class BindingMatchResult {
        private final TableColumnMethodPair[] methodPairs;
        private final AggregationAccessorSlotPair[] accessors;
        private final int[] targetStates;
        private final ExprNode[] accessStateExpr;
        private final AggregationAgent[] agents;

        private BindingMatchResult(TableColumnMethodPair[] methodPairs, AggregationAccessorSlotPair[] accessors, int[] targetStates, ExprNode[] accessStateExpr, AggregationAgent[] agents) {
            this.methodPairs = methodPairs;
            this.accessors = accessors;
            this.targetStates = targetStates;
            this.accessStateExpr = accessStateExpr;
            this.agents = agents;
        }

        public TableColumnMethodPair[] getMethodPairs() {
            return this.methodPairs;
        }

        public AggregationAccessorSlotPair[] getAccessors() {
            return this.accessors;
        }

        public int[] getTargetStates() {
            return this.targetStates;
        }

        public AggregationAgent[] getAgents() {
            return this.agents;
        }

        public ExprNode[] getAccessStateExpr() {
            return this.accessStateExpr;
        }
    }
}

