/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationServiceMatchRecognize;
import com.espertech.esper.epl.agg.service.AggregationServiceMatchRecognizeFactory;
import com.espertech.esper.epl.agg.service.AggregationServiceMatchRecognizeImpl;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import java.util.LinkedHashMap;
import java.util.Map;

public class AggregationServiceMatchRecognizeFactoryImpl
implements AggregationServiceMatchRecognizeFactory {
    private ExprEvaluator[][] evaluatorsEachStream;
    private AggregationMethodFactory[][] factoryEachStream;

    public AggregationServiceMatchRecognizeFactoryImpl(int countStreams, LinkedHashMap<Integer, AggregationMethodFactory[]> aggregatorsPerStream, Map<Integer, ExprEvaluator[]> evaluatorsPerStream) {
        this.evaluatorsEachStream = new ExprEvaluator[countStreams][];
        this.factoryEachStream = new AggregationMethodFactory[countStreams][];
        for (Map.Entry<Integer, AggregationMethodFactory[]> entry : aggregatorsPerStream.entrySet()) {
            this.factoryEachStream[entry.getKey().intValue()] = entry.getValue();
        }
        for (Map.Entry<Integer, Object[]> entry : evaluatorsPerStream.entrySet()) {
            this.evaluatorsEachStream[entry.getKey().intValue()] = (ExprEvaluator[])entry.getValue();
        }
    }

    @Override
    public AggregationServiceMatchRecognize makeService(AgentInstanceContext agentInstanceContext) {
        int aggId;
        AggregationMethod[][] aggregatorsEachStream = new AggregationMethod[this.factoryEachStream.length][];
        int count = 0;
        for (int stream = 0; stream < this.factoryEachStream.length; ++stream) {
            AggregationMethodFactory[] thatStream = this.factoryEachStream[stream];
            if (thatStream == null) continue;
            aggregatorsEachStream[stream] = new AggregationMethod[thatStream.length];
            for (aggId = 0; aggId < thatStream.length; ++aggId) {
                aggregatorsEachStream[stream][aggId] = this.factoryEachStream[stream][aggId].make(agentInstanceContext.getStatementContext().getMethodResolutionService(), agentInstanceContext.getAgentInstanceId(), 0, aggId);
                ++count;
            }
        }
        AggregationMethod[] aggregatorsAll = new AggregationMethod[count];
        count = 0;
        for (int stream = 0; stream < this.factoryEachStream.length; ++stream) {
            if (this.factoryEachStream[stream] == null) continue;
            for (aggId = 0; aggId < this.factoryEachStream[stream].length; ++aggId) {
                aggregatorsAll[count] = aggregatorsEachStream[stream][aggId];
                ++count;
            }
        }
        return new AggregationServiceMatchRecognizeImpl(this.evaluatorsEachStream, aggregatorsEachStream, aggregatorsAll);
    }
}

