/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.approx;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.util.CountMinSketchAgent;
import com.espertech.esper.client.util.CountMinSketchAgentContextAdd;
import com.espertech.esper.client.util.CountMinSketchAgentContextEstimate;
import com.espertech.esper.client.util.CountMinSketchAgentContextFromBytes;
import com.espertech.esper.client.util.CountMinSketchTopK;
import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.approx.CountMinSketchState;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import java.nio.ByteBuffer;
import java.util.Collection;

public class CountMinSketchAggState
implements AggregationState {
    protected final CountMinSketchState state;
    private final CountMinSketchAgent agent;
    private final CountMinSketchAgentContextAdd add;
    private final CountMinSketchAgentContextEstimate estimate;
    private final CountMinSketchAgentContextFromBytes fromBytes;

    public CountMinSketchAggState(CountMinSketchState state, CountMinSketchAgent agent) {
        this.state = state;
        this.agent = agent;
        this.add = new CountMinSketchAgentContextAdd(state);
        this.estimate = new CountMinSketchAgentContextEstimate(state);
        this.fromBytes = new CountMinSketchAgentContextFromBytes(state);
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        throw new UnsupportedOperationException("values are added through the add method");
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        throw new UnsupportedOperationException();
    }

    public void add(Object value) {
        this.add.setValue(value);
        this.agent.add(this.add);
    }

    public Long frequency(Object value) {
        this.estimate.setValue(value);
        return this.agent.estimate(this.estimate);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public CountMinSketchTopK[] getFromBytes() {
        Collection<ByteBuffer> bytes = this.state.getTopKValues();
        if (bytes.isEmpty()) {
            return new CountMinSketchTopK[0];
        }
        CountMinSketchTopK[] arr = new CountMinSketchTopK[bytes.size()];
        int index = 0;
        for (ByteBuffer buf : bytes) {
            Long frequency = this.state.frequency(buf.array());
            this.fromBytes.setBytes(buf.array());
            Object value = this.agent.fromBytes(this.fromBytes);
            if (frequency == null) continue;
            arr[index++] = new CountMinSketchTopK(frequency, value);
        }
        return arr;
    }
}

