/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.ConfigurationDataCache;
import com.espertech.esper.client.ConfigurationMethodRef;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.core.MethodPollingExecStrategyBase;
import com.espertech.esper.epl.core.MethodPollingExecStrategyEnum;
import com.espertech.esper.epl.core.MethodPollingExecStrategyMapArray;
import com.espertech.esper.epl.core.MethodPollingExecStrategyMapCollection;
import com.espertech.esper.epl.core.MethodPollingExecStrategyMapIterator;
import com.espertech.esper.epl.core.MethodPollingExecStrategyMapPlain;
import com.espertech.esper.epl.core.MethodPollingExecStrategyOAArray;
import com.espertech.esper.epl.core.MethodPollingExecStrategyOACollection;
import com.espertech.esper.epl.core.MethodPollingExecStrategyOAIterator;
import com.espertech.esper.epl.core.MethodPollingExecStrategyOAPlain;
import com.espertech.esper.epl.core.MethodPollingExecStrategyPOJOArray;
import com.espertech.esper.epl.core.MethodPollingExecStrategyPOJOCollection;
import com.espertech.esper.epl.core.MethodPollingExecStrategyPOJOIterator;
import com.espertech.esper.epl.core.MethodPollingExecStrategyPOJOPlain;
import com.espertech.esper.epl.core.MethodPollingViewable;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.db.DataCache;
import com.espertech.esper.epl.db.DataCacheFactory;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.MethodStreamSpec;
import com.espertech.esper.epl.variable.VariableMetaData;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.schedule.ScheduleBucket;
import com.espertech.esper.schedule.SchedulingService;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.HistoricalEventViewable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;

public class MethodPollingViewableFactory {
    public static HistoricalEventViewable createPollMethodView(int streamNumber, MethodStreamSpec methodStreamSpec, EventAdapterService eventAdapterService, EPStatementAgentInstanceHandle epStatementAgentInstanceHandle, MethodResolutionService methodResolutionService, EngineImportService engineImportService, SchedulingService schedulingService, ScheduleBucket scheduleBucket, ExprEvaluatorContext exprEvaluatorContext, VariableService variableService, String contextName, DataCacheFactory dataCacheFactory, StatementContext statementContext) throws ExprValidationException {
        FastMethod methodFastClass;
        Class<?> declaringClass;
        Method methodReflection;
        Object invocationTarget;
        VariableReader variableReader;
        MethodPollingExecStrategyEnum strategy;
        String variableName;
        VariableMetaData variableMetaData = variableService.getVariableMetaData(methodStreamSpec.getClassName());
        try {
            if (variableMetaData != null) {
                variableName = variableMetaData.getVariableName();
                if (variableMetaData.getContextPartitionName() != null) {
                    if (contextName == null || !contextName.equals(variableMetaData.getContextPartitionName())) {
                        throw new ExprValidationException("Variable by name '" + variableMetaData.getVariableName() + "' has been declared for context '" + variableMetaData.getContextPartitionName() + "' and can only be used within the same context");
                    }
                    strategy = MethodPollingExecStrategyEnum.TARGET_VAR_CONTEXT;
                    variableReader = null;
                    invocationTarget = null;
                } else {
                    variableReader = variableService.getReader(methodStreamSpec.getClassName(), -1);
                    if (variableMetaData.isConstant()) {
                        invocationTarget = variableReader.getValue();
                        if (invocationTarget instanceof EventBean) {
                            invocationTarget = ((EventBean)invocationTarget).getUnderlying();
                        }
                        strategy = MethodPollingExecStrategyEnum.TARGET_CONST;
                    } else {
                        invocationTarget = null;
                        strategy = MethodPollingExecStrategyEnum.TARGET_VAR;
                    }
                }
                methodReflection = methodResolutionService.resolveNonStaticMethod(variableMetaData.getType(), methodStreamSpec.getMethodName());
            } else {
                methodReflection = methodResolutionService.resolveMethod(methodStreamSpec.getClassName(), methodStreamSpec.getMethodName());
                invocationTarget = null;
                variableReader = null;
                variableName = null;
                strategy = MethodPollingExecStrategyEnum.TARGET_CONST;
            }
            declaringClass = methodReflection.getDeclaringClass();
            FastClass declaringFastClass = FastClass.create((ClassLoader)Thread.currentThread().getContextClassLoader(), methodReflection.getDeclaringClass());
            methodFastClass = declaringFastClass.getMethod(methodReflection);
        }
        catch (ExprValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExprValidationException(e.getMessage(), e);
        }
        Class beanClass = methodFastClass.getReturnType();
        if (beanClass == Void.TYPE || beanClass == Void.class || JavaClassHelper.isJavaBuiltinDataType(beanClass)) {
            throw new ExprValidationException("Invalid return type for static method '" + methodFastClass.getName() + "' of class '" + methodStreamSpec.getClassName() + "', expecting a Java class");
        }
        if (methodFastClass.getReturnType().isArray()) {
            beanClass = methodFastClass.getReturnType().getComponentType();
        }
        boolean isCollection = JavaClassHelper.isImplementsInterface(beanClass, Collection.class);
        Class collectionClass = null;
        if (isCollection) {
            beanClass = collectionClass = JavaClassHelper.getGenericReturnType(methodReflection, true);
        }
        boolean isIterator = JavaClassHelper.isImplementsInterface(beanClass, Iterator.class);
        Class iteratorClass = null;
        if (isIterator) {
            beanClass = iteratorClass = JavaClassHelper.getGenericReturnType(methodReflection, true);
        }
        Map mapType = null;
        String mapTypeName = null;
        if (JavaClassHelper.isImplementsInterface(methodFastClass.getReturnType(), Map.class) || methodFastClass.getReturnType().isArray() && JavaClassHelper.isImplementsInterface(methodFastClass.getReturnType().getComponentType(), Map.class) || isCollection && JavaClassHelper.isImplementsInterface(collectionClass, Map.class) || isIterator && JavaClassHelper.isImplementsInterface(iteratorClass, Map.class)) {
            MethodMetadataDesc metadata = variableMetaData != null ? MethodPollingViewableFactory.getCheckMetadataVariable(methodStreamSpec.getMethodName(), variableMetaData, variableReader, methodResolutionService, Map.class) : MethodPollingViewableFactory.getCheckMetadataNonVariable(methodStreamSpec.getMethodName(), methodStreamSpec.getClassName(), methodResolutionService, Map.class);
            mapTypeName = metadata.getTypeName();
            mapType = (Map)metadata.getTypeMetadata();
        }
        LinkedHashMap oaType = null;
        String oaTypeName = null;
        if (methodFastClass.getReturnType() == Object[].class || methodFastClass.getReturnType() == Object[][].class || isCollection && collectionClass == Object[].class || isIterator && iteratorClass == Object[].class) {
            MethodMetadataDesc metadata = variableMetaData != null ? MethodPollingViewableFactory.getCheckMetadataVariable(methodStreamSpec.getMethodName(), variableMetaData, variableReader, methodResolutionService, LinkedHashMap.class) : MethodPollingViewableFactory.getCheckMetadataNonVariable(methodStreamSpec.getMethodName(), methodStreamSpec.getClassName(), methodResolutionService, LinkedHashMap.class);
            oaTypeName = metadata.getTypeName();
            oaType = (LinkedHashMap)metadata.getTypeMetadata();
        }
        EventType eventType = mapType != null ? eventAdapterService.addNestableMapType(mapTypeName, mapType, null, false, true, true, false, false) : (oaType != null ? eventAdapterService.addNestableObjectArrayType(oaTypeName, oaType, null, false, true, true, false, false, false, null) : eventAdapterService.addBeanType(beanClass.getName(), beanClass, false, true, true));
        ConfigurationMethodRef configCache = engineImportService.getConfigurationMethodRef(declaringClass.getName());
        if (configCache == null) {
            configCache = engineImportService.getConfigurationMethodRef(declaringClass.getSimpleName());
        }
        ConfigurationDataCache dataCacheDesc = configCache != null ? configCache.getDataCacheDesc() : null;
        DataCache dataCache = dataCacheFactory.getDataCache(dataCacheDesc, statementContext, epStatementAgentInstanceHandle, schedulingService, scheduleBucket, streamNumber);
        MethodPollingExecStrategyBase methodPollStrategy = mapType != null ? (methodFastClass.getReturnType().isArray() ? new MethodPollingExecStrategyMapArray(eventAdapterService, methodFastClass, eventType, invocationTarget, strategy, variableReader, variableName, variableService) : (isCollection ? new MethodPollingExecStrategyMapCollection(eventAdapterService, methodFastClass, eventType, invocationTarget, strategy, variableReader, variableName, variableService) : (isIterator ? new MethodPollingExecStrategyMapIterator(eventAdapterService, methodFastClass, eventType, invocationTarget, strategy, variableReader, variableName, variableService) : new MethodPollingExecStrategyMapPlain(eventAdapterService, methodFastClass, eventType, invocationTarget, strategy, variableReader, variableName, variableService)))) : (oaType != null ? (methodFastClass.getReturnType() == Object[][].class ? new MethodPollingExecStrategyOAArray(eventAdapterService, methodFastClass, eventType, invocationTarget, strategy, variableReader, variableName, variableService) : (isCollection ? new MethodPollingExecStrategyOACollection(eventAdapterService, methodFastClass, eventType, invocationTarget, strategy, variableReader, variableName, variableService) : (isIterator ? new MethodPollingExecStrategyOAIterator(eventAdapterService, methodFastClass, eventType, invocationTarget, strategy, variableReader, variableName, variableService) : new MethodPollingExecStrategyOAPlain(eventAdapterService, methodFastClass, eventType, invocationTarget, strategy, variableReader, variableName, variableService)))) : (methodFastClass.getReturnType().isArray() ? new MethodPollingExecStrategyPOJOArray(eventAdapterService, methodFastClass, eventType, invocationTarget, strategy, variableReader, variableName, variableService) : (isCollection ? new MethodPollingExecStrategyPOJOCollection(eventAdapterService, methodFastClass, eventType, invocationTarget, strategy, variableReader, variableName, variableService) : (isIterator ? new MethodPollingExecStrategyPOJOIterator(eventAdapterService, methodFastClass, eventType, invocationTarget, strategy, variableReader, variableName, variableService) : new MethodPollingExecStrategyPOJOPlain(eventAdapterService, methodFastClass, eventType, invocationTarget, strategy, variableReader, variableName, variableService)))));
        return new MethodPollingViewable(variableMetaData == null, methodReflection.getDeclaringClass(), methodStreamSpec, streamNumber, methodStreamSpec.getExpressions(), methodPollStrategy, dataCache, eventType, exprEvaluatorContext);
    }

    private static MethodMetadataDesc getCheckMetadataVariable(String methodName, VariableMetaData variableMetaData, VariableReader variableReader, MethodResolutionService methodResolutionService, Class metadataClass) throws ExprValidationException {
        Method typeGetterMethod = MethodPollingViewableFactory.getRequiredTypeGetterMethodCanNonStatic(methodName, null, variableMetaData.getType(), methodResolutionService, metadataClass);
        if (Modifier.isStatic(typeGetterMethod.getModifiers())) {
            return MethodPollingViewableFactory.invokeMetadataMethod(null, variableMetaData.getClass().getSimpleName(), typeGetterMethod);
        }
        String messagePrefix = "Failed to access variable method invocation metadata: ";
        if (variableReader == null) {
            throw new ExprValidationException(messagePrefix + "The metadata method is an instance method however the variable is contextual, please declare the metadata method as static or remove the context declaration for the variable");
        }
        Object value = variableReader.getValue();
        if (value == null) {
            throw new ExprValidationException(messagePrefix + "The variable value is null and the metadata method is an instance method");
        }
        if (value instanceof EventBean) {
            value = ((EventBean)value).getUnderlying();
        }
        return MethodPollingViewableFactory.invokeMetadataMethod(value, variableMetaData.getClass().getSimpleName(), typeGetterMethod);
    }

    private static MethodMetadataDesc getCheckMetadataNonVariable(String methodName, String className, MethodResolutionService methodResolutionService, Class metadataClass) throws ExprValidationException {
        Method typeGetterMethod = MethodPollingViewableFactory.getRequiredTypeGetterMethodCanNonStatic(methodName, className, null, methodResolutionService, metadataClass);
        return MethodPollingViewableFactory.invokeMetadataMethod(null, className, typeGetterMethod);
    }

    private static Method getRequiredTypeGetterMethodCanNonStatic(String methodName, String classNameWhenNoClass, Class clazzWhenAvailable, MethodResolutionService methodResolutionService, Class metadataClass) throws ExprValidationException {
        boolean fail;
        Method typeGetterMethod;
        String getterMethodName = methodName + "Metadata";
        try {
            typeGetterMethod = clazzWhenAvailable != null ? methodResolutionService.resolveMethod(clazzWhenAvailable, getterMethodName, new Class[0], new boolean[0], new boolean[0]) : methodResolutionService.resolveMethod(classNameWhenNoClass, getterMethodName, new Class[0], new boolean[0], new boolean[0]);
        }
        catch (Exception e) {
            throw new ExprValidationException("Could not find getter method for method invocation, expected a method by name '" + getterMethodName + "' accepting no parameters");
        }
        if (metadataClass.isInterface()) {
            fail = !JavaClassHelper.isImplementsInterface(typeGetterMethod.getReturnType(), metadataClass);
        } else {
            boolean bl = fail = typeGetterMethod.getReturnType() != metadataClass;
        }
        if (fail) {
            throw new ExprValidationException("Getter method '" + typeGetterMethod.getName() + "' does not return " + JavaClassHelper.getClassNameFullyQualPretty(metadataClass));
        }
        return typeGetterMethod;
    }

    private static MethodMetadataDesc invokeMetadataMethod(Object target, String className, Method typeGetterMethod) throws ExprValidationException {
        Object resultType;
        try {
            resultType = typeGetterMethod.invoke(target, new Object[0]);
        }
        catch (Exception e) {
            throw new ExprValidationException("Error invoking metadata getter method for method invocation, for method by name '" + typeGetterMethod.getName() + "' accepting no parameters: " + e.getMessage(), e);
        }
        if (resultType == null) {
            throw new ExprValidationException("Error invoking metadata getter method for method invocation, method returned a null value");
        }
        return new MethodMetadataDesc(className + "." + typeGetterMethod.getName(), resultType);
    }

    public static class MethodMetadataDesc {
        private final String typeName;
        private final Object typeMetadata;

        public MethodMetadataDesc(String typeName, Object typeMetadata) {
            this.typeName = typeName;
            this.typeMetadata = typeMetadata;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public Object getTypeMetadata() {
            return this.typeMetadata;
        }
    }
}

