/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.rollup.GroupByRollupKey;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.core.OrderByElement;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.OrderByProcessorFactoryImpl;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeMap;

public class OrderByProcessorImpl
implements OrderByProcessor {
    private final OrderByProcessorFactoryImpl factory;
    private final AggregationService aggregationService;

    public OrderByProcessorImpl(OrderByProcessorFactoryImpl factory, AggregationService aggregationService) {
        this.factory = factory;
        this.aggregationService = aggregationService;
    }

    @Override
    public Object getSortKey(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return OrderByProcessorImpl.getSortKeyInternal(eventsPerStream, isNewData, exprEvaluatorContext, this.factory.getOrderBy());
    }

    @Override
    public Object getSortKey(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext, OrderByElement[] elementsForLevel) {
        return OrderByProcessorImpl.getSortKeyInternal(eventsPerStream, isNewData, exprEvaluatorContext, elementsForLevel);
    }

    private static Object getSortKeyInternal(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext, OrderByElement[] elements) {
        if (elements.length == 1) {
            return elements[0].getExpr().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        Object[] values = new Object[elements.length];
        int count = 0;
        for (OrderByElement sortPair : elements) {
            values[count++] = sortPair.getExpr().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        return new MultiKeyUntyped(values);
    }

    @Override
    public Object[] getSortKeyPerRow(EventBean[] generatingEvents, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (generatingEvents == null) {
            return null;
        }
        Object[] sortProperties = new Object[generatingEvents.length];
        int count = 0;
        EventBean[] evalEventsPerStream = new EventBean[1];
        if (this.factory.getOrderBy().length == 1) {
            ExprEvaluator singleEval = this.factory.getOrderBy()[0].getExpr();
            EventBean[] arr$ = generatingEvents;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                EventBean theEvent;
                evalEventsPerStream[0] = theEvent = arr$[i$];
                sortProperties[count] = singleEval.evaluate(evalEventsPerStream, isNewData, exprEvaluatorContext);
                ++count;
            }
        } else {
            for (EventBean theEvent : generatingEvents) {
                Object[] values = new Object[this.factory.getOrderBy().length];
                int countTwo = 0;
                evalEventsPerStream[0] = theEvent;
                for (OrderByElement sortPair : this.factory.getOrderBy()) {
                    values[countTwo++] = sortPair.getExpr().evaluate(evalEventsPerStream, isNewData, exprEvaluatorContext);
                }
                sortProperties[count] = new MultiKeyUntyped(values);
                ++count;
            }
        }
        return sortProperties;
    }

    @Override
    public EventBean[] sort(EventBean[] outgoingEvents, EventBean[][] generatingEvents, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (outgoingEvents == null || outgoingEvents.length < 2) {
            return outgoingEvents;
        }
        Object[] groupByKeys = null;
        if (this.factory.isNeedsGroupByKeys()) {
            groupByKeys = this.generateGroupKeys(generatingEvents, isNewData, exprEvaluatorContext);
        }
        return this.sort(outgoingEvents, generatingEvents, groupByKeys, isNewData, exprEvaluatorContext);
    }

    @Override
    public EventBean[] sort(EventBean[] outgoingEvents, List<GroupByRollupKey> currentGenerators, boolean isNewData, AgentInstanceContext exprEvaluatorContext, OrderByElement[][] elementsPerLevel) {
        List<Object> sortValuesMultiKeys = this.createSortPropertiesWRollup(currentGenerators, elementsPerLevel, isNewData, exprEvaluatorContext);
        return OrderByProcessorImpl.sortInternal(outgoingEvents, sortValuesMultiKeys, this.factory.getComparator());
    }

    @Override
    public EventBean[] sort(EventBean[] outgoingEvents, EventBean[][] generatingEvents, Object[] groupByKeys, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (outgoingEvents == null || outgoingEvents.length < 2) {
            return outgoingEvents;
        }
        List<Object> sortValuesMultiKeys = this.createSortProperties(generatingEvents, groupByKeys, isNewData, exprEvaluatorContext);
        return OrderByProcessorImpl.sortInternal(outgoingEvents, sortValuesMultiKeys, this.factory.getComparator());
    }

    private List<Object> createSortProperties(EventBean[][] generatingEvents, Object[] groupByKeys, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object[] sortProperties = new Object[generatingEvents.length];
        OrderByElement[] elements = this.factory.getOrderBy();
        if (elements.length == 1) {
            int count = 0;
            for (EventBean[] eventsPerStream : generatingEvents) {
                if (this.factory.isNeedsGroupByKeys()) {
                    this.aggregationService.setCurrentAccess(groupByKeys[count], exprEvaluatorContext.getAgentInstanceId(), null);
                }
                sortProperties[count] = elements[0].getExpr().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                ++count;
            }
        } else {
            int count = 0;
            for (EventBean[] eventsPerStream : generatingEvents) {
                if (this.factory.isNeedsGroupByKeys()) {
                    this.aggregationService.setCurrentAccess(groupByKeys[count], exprEvaluatorContext.getAgentInstanceId(), null);
                }
                Object[] values = new Object[this.factory.getOrderBy().length];
                int countTwo = 0;
                for (OrderByElement sortPair : this.factory.getOrderBy()) {
                    values[countTwo++] = sortPair.getExpr().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                }
                sortProperties[count] = new MultiKeyUntyped(values);
                ++count;
            }
        }
        return Arrays.asList(sortProperties);
    }

    @Override
    public EventBean[] sort(EventBean[] outgoingEvents, Object[] orderKeys, ExprEvaluatorContext exprEvaluatorContext) {
        TreeMap<Object, Object> sort = new TreeMap<Object, Object>(this.factory.getComparator());
        if (outgoingEvents == null || outgoingEvents.length < 2) {
            return outgoingEvents;
        }
        for (int i = 0; i < outgoingEvents.length; ++i) {
            ArrayList<EventBean> list;
            Object entry = sort.get(orderKeys[i]);
            if (entry == null) {
                sort.put(orderKeys[i], outgoingEvents[i]);
                continue;
            }
            if (entry instanceof EventBean) {
                list = new ArrayList<EventBean>();
                list.add((EventBean)entry);
                list.add(outgoingEvents[i]);
                sort.put(orderKeys[i], list);
                continue;
            }
            list = (ArrayList<EventBean>)entry;
            list.add(outgoingEvents[i]);
        }
        EventBean[] result = new EventBean[outgoingEvents.length];
        int count = 0;
        for (Object entry : sort.values()) {
            if (entry instanceof List) {
                List output = (List)entry;
                for (EventBean theEvent : output) {
                    result[count++] = theEvent;
                }
                continue;
            }
            result[count++] = (EventBean)entry;
        }
        return result;
    }

    private Object[] generateGroupKeys(EventBean[][] generatingEvents, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object[] keys = new Object[generatingEvents.length];
        int count = 0;
        for (EventBean[] eventsPerStream : generatingEvents) {
            keys[count++] = this.generateGroupKey(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        return keys;
    }

    private Object generateGroupKey(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        ExprEvaluator[] evals = this.factory.getGroupByNodes();
        if (evals.length == 1) {
            return evals[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        Object[] keys = new Object[evals.length];
        int count = 0;
        for (ExprEvaluator exprNode : evals) {
            keys[count] = exprNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            ++count;
        }
        return new MultiKeyUntyped(keys);
    }

    private List<Object> createSortPropertiesWRollup(List<GroupByRollupKey> currentGenerators, OrderByElement[][] elementsPerLevel, boolean isNewData, AgentInstanceContext exprEvaluatorContext) {
        Object[] sortProperties = new Object[currentGenerators.size()];
        OrderByElement[] elements = this.factory.getOrderBy();
        if (elements.length == 1) {
            int count = 0;
            for (GroupByRollupKey rollup : currentGenerators) {
                if (this.factory.isNeedsGroupByKeys()) {
                    this.aggregationService.setCurrentAccess(rollup.getGroupKey(), exprEvaluatorContext.getAgentInstanceId(), rollup.getLevel());
                }
                sortProperties[count] = elementsPerLevel[rollup.getLevel().getLevelNumber()][0].getExpr().evaluate(rollup.getGenerator(), isNewData, exprEvaluatorContext);
                ++count;
            }
        } else {
            int count = 0;
            for (GroupByRollupKey rollup : currentGenerators) {
                if (this.factory.isNeedsGroupByKeys()) {
                    this.aggregationService.setCurrentAccess(rollup.getGroupKey(), exprEvaluatorContext.getAgentInstanceId(), rollup.getLevel());
                }
                Object[] values = new Object[this.factory.getOrderBy().length];
                int countTwo = 0;
                for (OrderByElement sortPair : elementsPerLevel[rollup.getLevel().getLevelNumber()]) {
                    values[countTwo++] = sortPair.getExpr().evaluate(rollup.getGenerator(), isNewData, exprEvaluatorContext);
                }
                sortProperties[count] = new MultiKeyUntyped(values);
                ++count;
            }
        }
        return Arrays.asList(sortProperties);
    }

    private static EventBean[] sortInternal(EventBean[] outgoingEvents, List<Object> sortValuesMultiKeys, Comparator<Object> comparator) {
        HashMap<Object, ArrayList<EventBean>> sortToOutgoing = new HashMap<Object, ArrayList<EventBean>>();
        int countOne = 0;
        for (Object sortValues : sortValuesMultiKeys) {
            ArrayList<EventBean> list = (ArrayList<EventBean>)sortToOutgoing.get(sortValues);
            if (list == null) {
                list = new ArrayList<EventBean>();
            }
            list.add(outgoingEvents[countOne++]);
            sortToOutgoing.put(sortValues, list);
        }
        Collections.sort(sortValuesMultiKeys, comparator);
        LinkedHashSet<Object> sortSet = new LinkedHashSet<Object>(sortValuesMultiKeys);
        EventBean[] result = new EventBean[outgoingEvents.length];
        int countTwo = 0;
        for (Object e : sortSet) {
            Collection output = (Collection)sortToOutgoing.get(e);
            for (EventBean theEvent : output) {
                result[countTwo++] = theEvent;
            }
        }
        return result;
    }

    public EventBean determineLocalMinMax(EventBean[] outgoingEvents, EventBean[][] generatingEvents, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object[] groupByKeys = null;
        if (this.factory.isNeedsGroupByKeys()) {
            groupByKeys = this.generateGroupKeys(generatingEvents, isNewData, exprEvaluatorContext);
        }
        OrderByElement[] elements = this.factory.getOrderBy();
        Object localMinMax = null;
        EventBean outgoingMinMaxBean = null;
        if (elements.length == 1) {
            int count = 0;
            for (EventBean[] eventsPerStream : generatingEvents) {
                boolean newMinMax;
                if (this.factory.isNeedsGroupByKeys()) {
                    this.aggregationService.setCurrentAccess(groupByKeys[count], exprEvaluatorContext.getAgentInstanceId(), null);
                }
                Object sortKey = elements[0].getExpr().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                boolean bl = newMinMax = localMinMax == null || this.factory.getComparator().compare(localMinMax, sortKey) > 0;
                if (newMinMax) {
                    localMinMax = sortKey;
                    outgoingMinMaxBean = outgoingEvents[count];
                }
                ++count;
            }
        } else {
            int count = 0;
            Object[] values = new Object[this.factory.getOrderBy().length];
            MultiKeyUntyped valuesMk = new MultiKeyUntyped(values);
            for (EventBean[] eventsPerStream : generatingEvents) {
                boolean newMinMax;
                if (this.factory.isNeedsGroupByKeys()) {
                    this.aggregationService.setCurrentAccess(groupByKeys[count], exprEvaluatorContext.getAgentInstanceId(), null);
                }
                int countTwo = 0;
                for (OrderByElement sortPair : this.factory.getOrderBy()) {
                    values[countTwo++] = sortPair.getExpr().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                }
                boolean bl = newMinMax = localMinMax == null || this.factory.getComparator().compare(localMinMax, valuesMk) > 0;
                if (newMinMax) {
                    localMinMax = valuesMk;
                    values = new Object[this.factory.getOrderBy().length];
                    valuesMk = new MultiKeyUntyped(values);
                    outgoingMinMaxBean = outgoingEvents[count];
                }
                ++count;
            }
        }
        return outgoingMinMaxBean;
    }

    public EventBean determineLocalMinMax(EventBean[] outgoingEvents, Object[] orderKeys) {
        Object localMinMax = null;
        EventBean outgoingMinMaxBean = null;
        for (int i = 0; i < outgoingEvents.length; ++i) {
            boolean newMinMax;
            boolean bl = newMinMax = localMinMax == null || this.factory.getComparator().compare(localMinMax, orderKeys[i]) > 0;
            if (!newMinMax) continue;
            localMinMax = orderKeys[i];
            outgoingMinMaxBean = outgoingEvents[i];
        }
        return outgoingMinMaxBean;
    }
}

