/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.TransformEventIterator;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.core.ResultSetProcessorBaseSimple;
import com.espertech.esper.epl.core.ResultSetProcessorHandThroughFactory;
import com.espertech.esper.epl.core.ResultSetProcessorSimpleTransform;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.view.Viewable;
import java.util.Iterator;
import java.util.Set;

public class ResultSetProcessorHandThrough
extends ResultSetProcessorBaseSimple {
    private final ResultSetProcessorHandThroughFactory prototype;
    private final SelectExprProcessor selectExprProcessor;
    private AgentInstanceContext agentInstanceContext;

    public ResultSetProcessorHandThrough(ResultSetProcessorHandThroughFactory prototype, SelectExprProcessor selectExprProcessor, AgentInstanceContext agentInstanceContext) {
        this.prototype = prototype;
        this.selectExprProcessor = selectExprProcessor;
        this.agentInstanceContext = agentInstanceContext;
    }

    @Override
    public void setAgentInstanceContext(AgentInstanceContext agentInstanceContext) {
        this.agentInstanceContext = agentInstanceContext;
    }

    @Override
    public EventType getResultEventType() {
        return this.prototype.getResultEventType();
    }

    @Override
    public UniformPair<EventBean[]> processJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, boolean isSynthesize) {
        EventBean[] selectOldEvents = null;
        if (this.prototype.isSelectRStream()) {
            selectOldEvents = ResultSetProcessorHandThrough.getSelectEventsNoHaving(this.selectExprProcessor, oldEvents, false, isSynthesize, (ExprEvaluatorContext)this.agentInstanceContext);
        }
        EventBean[] selectNewEvents = ResultSetProcessorHandThrough.getSelectEventsNoHaving(this.selectExprProcessor, newEvents, true, isSynthesize, (ExprEvaluatorContext)this.agentInstanceContext);
        return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
    }

    @Override
    public UniformPair<EventBean[]> processViewResult(EventBean[] newData, EventBean[] oldData, boolean isSynthesize) {
        EventBean[] selectOldEvents = null;
        if (this.prototype.isSelectRStream()) {
            selectOldEvents = ResultSetProcessorHandThrough.getSelectEventsNoHaving(this.selectExprProcessor, oldData, false, isSynthesize, (ExprEvaluatorContext)this.agentInstanceContext);
        }
        EventBean[] selectNewEvents = ResultSetProcessorHandThrough.getSelectEventsNoHaving(this.selectExprProcessor, newData, true, isSynthesize, (ExprEvaluatorContext)this.agentInstanceContext);
        return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
    }

    protected static EventBean[] getSelectEventsNoHaving(SelectExprProcessor exprProcessor, EventBean[] events, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext agentInstanceContext) {
        if (events == null) {
            return null;
        }
        EventBean[] result = new EventBean[events.length];
        EventBean[] eventsPerStream = new EventBean[1];
        for (int i = 0; i < events.length; ++i) {
            eventsPerStream[0] = events[i];
            result[i] = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, agentInstanceContext);
        }
        return result;
    }

    protected static EventBean[] getSelectEventsNoHaving(SelectExprProcessor exprProcessor, Set<MultiKey<EventBean>> events, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext agentInstanceContext) {
        int length = events.size();
        if (length == 0) {
            return null;
        }
        EventBean[] result = new EventBean[length];
        int count = 0;
        for (MultiKey<EventBean> key : events) {
            EventBean[] eventsPerStream = key.getArray();
            result[count] = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, agentInstanceContext);
            ++count;
        }
        return result;
    }

    @Override
    public void clear() {
    }

    @Override
    public Iterator<EventBean> getIterator(Viewable parent) {
        return new TransformEventIterator(parent.iterator(), new ResultSetProcessorSimpleTransform(this));
    }

    @Override
    public Iterator<EventBean> getIterator(Set<MultiKey<EventBean>> joinSet) {
        UniformPair<EventBean[]> result = this.processJoinResult(joinSet, CollectionUtil.EMPTY_ROW_SET, true);
        return new ArrayEventIterator(result.getFirst());
    }

    @Override
    public boolean hasAggregation() {
        return false;
    }

    @Override
    public void applyViewResult(EventBean[] newData, EventBean[] oldData) {
    }

    @Override
    public void applyJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents) {
    }

    @Override
    public void processOutputLimitedLastAllNonBufferedView(EventBean[] newData, EventBean[] oldData, boolean isGenerateSynthetic, boolean isAll) {
    }

    @Override
    public void processOutputLimitedLastAllNonBufferedJoin(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, boolean isGenerateSynthetic, boolean isAll) {
    }

    @Override
    public UniformPair<EventBean[]> continueOutputLimitedLastAllNonBufferedView(boolean isSynthesize, boolean isAll) {
        return null;
    }

    @Override
    public UniformPair<EventBean[]> continueOutputLimitedLastAllNonBufferedJoin(boolean isSynthesize, boolean isAll) {
        return null;
    }

    @Override
    public void stop() {
    }
}

