/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorRowPerGroupRollup;
import com.espertech.esper.epl.core.ResultSetProcessorRowPerGroupRollupFactory;
import com.espertech.esper.epl.core.ResultSetProcessorRowPerGroupRollupUnboundHelper;
import com.espertech.esper.view.Viewable;
import java.util.Iterator;

public class ResultSetProcessorRowPerGroupRollupUnbound
extends ResultSetProcessorRowPerGroupRollup {
    private final ResultSetProcessorRowPerGroupRollupUnboundHelper unboundHelper;

    public ResultSetProcessorRowPerGroupRollupUnbound(ResultSetProcessorRowPerGroupRollupFactory prototype, OrderByProcessor orderByProcessor, AggregationService aggregationService, AgentInstanceContext agentInstanceContext) {
        super(prototype, orderByProcessor, aggregationService, agentInstanceContext);
        this.unboundHelper = prototype.getResultSetProcessorHelperFactory().makeRSRowPerGroupRollupSnapshotUnbound(agentInstanceContext, prototype);
    }

    @Override
    public void stop() {
        super.stop();
        this.unboundHelper.destroy();
    }

    @Override
    public void applyViewResult(EventBean[] newData, EventBean[] oldData) {
        int i;
        Object[][] newDataMultiKey = this.generateGroupKeysView(newData, this.unboundHelper.getBuffer(), true);
        Object[][] oldDataMultiKey = this.generateGroupKeysView(oldData, this.unboundHelper.getBuffer(), false);
        EventBean[] eventsPerStream = new EventBean[1];
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                eventsPerStream[0] = newData[i];
                this.aggregationService.applyEnter(eventsPerStream, newDataMultiKey[i], this.agentInstanceContext);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                eventsPerStream[0] = oldData[i];
                this.aggregationService.applyLeave(eventsPerStream, oldDataMultiKey[i], this.agentInstanceContext);
            }
        }
    }

    @Override
    public UniformPair<EventBean[]> processViewResult(EventBean[] newData, EventBean[] oldData, boolean isSynthesize) {
        EventBean[] selectNewEvents;
        int i;
        Object[][] newDataMultiKey = this.generateGroupKeysView(newData, this.unboundHelper.getBuffer(), true);
        Object[][] oldDataMultiKey = this.generateGroupKeysView(oldData, this.unboundHelper.getBuffer(), false);
        EventBean[] selectOldEvents = null;
        if (this.prototype.isSelectRStream()) {
            selectOldEvents = this.generateOutputEventsView(this.unboundHelper.getBuffer(), false, isSynthesize);
        }
        EventBean[] eventsPerStream = new EventBean[1];
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                eventsPerStream[0] = newData[i];
                this.aggregationService.applyEnter(eventsPerStream, newDataMultiKey[i], this.agentInstanceContext);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                eventsPerStream[0] = oldData[i];
                this.aggregationService.applyLeave(eventsPerStream, oldDataMultiKey[i], this.agentInstanceContext);
            }
        }
        if ((selectNewEvents = this.generateOutputEventsView(this.unboundHelper.getBuffer(), true, isSynthesize)) != null || selectOldEvents != null) {
            return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
        }
        return null;
    }

    @Override
    public Iterator<EventBean> getIterator(Viewable parent) {
        EventBean[] output = this.generateOutputEventsView(this.unboundHelper.getBuffer(), true, true);
        return new ArrayEventIterator(output);
    }
}

