/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.TransformEventIterator;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorBaseSimple;
import com.espertech.esper.epl.core.ResultSetProcessorSimpleFactory;
import com.espertech.esper.epl.core.ResultSetProcessorSimpleOutputAllHelper;
import com.espertech.esper.epl.core.ResultSetProcessorSimpleOutputLastHelper;
import com.espertech.esper.epl.core.ResultSetProcessorSimpleTransform;
import com.espertech.esper.epl.core.ResultSetProcessorUtil;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.view.Viewable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class ResultSetProcessorSimple
extends ResultSetProcessorBaseSimple {
    protected final ResultSetProcessorSimpleFactory prototype;
    private final SelectExprProcessor selectExprProcessor;
    private final OrderByProcessor orderByProcessor;
    protected ExprEvaluatorContext exprEvaluatorContext;
    private ResultSetProcessorSimpleOutputLastHelper outputLastHelper;
    private ResultSetProcessorSimpleOutputAllHelper outputAllHelper;

    public ResultSetProcessorSimple(ResultSetProcessorSimpleFactory prototype, SelectExprProcessor selectExprProcessor, OrderByProcessor orderByProcessor, AgentInstanceContext agentInstanceContext) {
        this.prototype = prototype;
        this.selectExprProcessor = selectExprProcessor;
        this.orderByProcessor = orderByProcessor;
        this.exprEvaluatorContext = agentInstanceContext;
        if (prototype.isOutputLast()) {
            this.outputLastHelper = prototype.getResultSetProcessorHelperFactory().makeRSSimpleOutputLast(prototype, this, agentInstanceContext);
        } else if (prototype.isOutputAll() && prototype.isEnableOutputLimitOpt()) {
            this.outputAllHelper = prototype.getResultSetProcessorHelperFactory().makeRSSimpleOutputAll(prototype, this, agentInstanceContext);
        }
    }

    @Override
    public void setAgentInstanceContext(AgentInstanceContext context) {
        this.exprEvaluatorContext = context;
    }

    @Override
    public EventType getResultEventType() {
        return this.prototype.getResultEventType();
    }

    @Override
    public UniformPair<EventBean[]> processJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, boolean isSynthesize) {
        EventBean[] selectNewEvents;
        EventBean[] selectOldEvents = null;
        if (this.prototype.getOptionalHavingExpr() == null) {
            if (this.prototype.isSelectRStream()) {
                selectOldEvents = this.orderByProcessor == null ? ResultSetProcessorUtil.getSelectJoinEventsNoHaving(this.selectExprProcessor, oldEvents, false, isSynthesize, this.exprEvaluatorContext) : ResultSetProcessorUtil.getSelectJoinEventsNoHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, oldEvents, false, isSynthesize, this.exprEvaluatorContext);
            }
            selectNewEvents = this.orderByProcessor == null ? ResultSetProcessorUtil.getSelectJoinEventsNoHaving(this.selectExprProcessor, newEvents, true, isSynthesize, this.exprEvaluatorContext) : ResultSetProcessorUtil.getSelectJoinEventsNoHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, newEvents, true, isSynthesize, this.exprEvaluatorContext);
        } else {
            if (this.prototype.isSelectRStream()) {
                selectOldEvents = this.orderByProcessor == null ? ResultSetProcessorUtil.getSelectJoinEventsHaving(this.selectExprProcessor, oldEvents, this.prototype.getOptionalHavingExpr(), false, isSynthesize, this.exprEvaluatorContext) : ResultSetProcessorUtil.getSelectJoinEventsHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, oldEvents, this.prototype.getOptionalHavingExpr(), false, isSynthesize, this.exprEvaluatorContext);
            }
            selectNewEvents = this.orderByProcessor == null ? ResultSetProcessorUtil.getSelectJoinEventsHaving(this.selectExprProcessor, newEvents, this.prototype.getOptionalHavingExpr(), true, isSynthesize, this.exprEvaluatorContext) : ResultSetProcessorUtil.getSelectJoinEventsHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, newEvents, this.prototype.getOptionalHavingExpr(), true, isSynthesize, this.exprEvaluatorContext);
        }
        return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
    }

    @Override
    public UniformPair<EventBean[]> processViewResult(EventBean[] newData, EventBean[] oldData, boolean isSynthesize) {
        EventBean[] selectNewEvents;
        EventBean[] selectOldEvents = null;
        if (this.prototype.getOptionalHavingExpr() == null) {
            if (this.prototype.isSelectRStream()) {
                selectOldEvents = this.orderByProcessor == null ? ResultSetProcessorUtil.getSelectEventsNoHaving(this.selectExprProcessor, oldData, false, isSynthesize, this.exprEvaluatorContext) : ResultSetProcessorUtil.getSelectEventsNoHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, oldData, false, isSynthesize, this.exprEvaluatorContext);
            }
            selectNewEvents = this.orderByProcessor == null ? ResultSetProcessorUtil.getSelectEventsNoHaving(this.selectExprProcessor, newData, true, isSynthesize, this.exprEvaluatorContext) : ResultSetProcessorUtil.getSelectEventsNoHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, newData, true, isSynthesize, this.exprEvaluatorContext);
        } else {
            if (this.prototype.isSelectRStream()) {
                selectOldEvents = this.orderByProcessor == null ? ResultSetProcessorUtil.getSelectEventsHaving(this.selectExprProcessor, oldData, this.prototype.getOptionalHavingExpr(), false, isSynthesize, this.exprEvaluatorContext) : ResultSetProcessorUtil.getSelectEventsHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, oldData, this.prototype.getOptionalHavingExpr(), false, isSynthesize, this.exprEvaluatorContext);
            }
            selectNewEvents = this.orderByProcessor == null ? ResultSetProcessorUtil.getSelectEventsHaving(this.selectExprProcessor, newData, this.prototype.getOptionalHavingExpr(), true, isSynthesize, this.exprEvaluatorContext) : ResultSetProcessorUtil.getSelectEventsHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, newData, this.prototype.getOptionalHavingExpr(), true, isSynthesize, this.exprEvaluatorContext);
        }
        return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
    }

    public UniformPair<EventBean[]> processViewResultIterator(EventBean[] newData) {
        EventBean[] selectNewEvents = this.prototype.getOptionalHavingExpr() == null ? ResultSetProcessorUtil.getSelectEventsNoHaving(this.selectExprProcessor, newData, true, true, this.exprEvaluatorContext) : ResultSetProcessorUtil.getSelectEventsHaving(this.selectExprProcessor, newData, this.prototype.getOptionalHavingExpr(), true, true, this.exprEvaluatorContext);
        return new UniformPair<Object>(selectNewEvents, null);
    }

    @Override
    public Iterator<EventBean> getIterator(Viewable parent) {
        if (this.orderByProcessor != null) {
            EventBean[] eventsPerStream = new EventBean[1];
            ArrayList<EventBean> events = new ArrayList<EventBean>();
            ArrayList<Object> orderKeys = new ArrayList<Object>();
            Iterator<EventBean> parentIterator = parent.iterator();
            if (parentIterator == null) {
                return CollectionUtil.NULL_EVENT_ITERATOR;
            }
            Iterator<EventBean> i$ = parent.iterator();
            while (i$.hasNext()) {
                EventBean aParent;
                eventsPerStream[0] = aParent = i$.next();
                Object orderKey = this.orderByProcessor.getSortKey(eventsPerStream, true, this.exprEvaluatorContext);
                UniformPair<EventBean[]> pair = this.processViewResultIterator(eventsPerStream);
                EventBean[] result = pair.getFirst();
                if (result != null && result.length != 0) {
                    events.add(result[0]);
                }
                orderKeys.add(orderKey);
            }
            EventBean[] outgoingEvents = events.toArray(new EventBean[events.size()]);
            Object[] orderKeysArr = orderKeys.toArray(new Object[orderKeys.size()]);
            EventBean[] orderedEvents = this.orderByProcessor.sort(outgoingEvents, orderKeysArr, this.exprEvaluatorContext);
            return new ArrayEventIterator(orderedEvents);
        }
        return new TransformEventIterator(parent.iterator(), new ResultSetProcessorSimpleTransform(this));
    }

    @Override
    public Iterator<EventBean> getIterator(Set<MultiKey<EventBean>> joinSet) {
        UniformPair<EventBean[]> result = this.processJoinResult(joinSet, CollectionUtil.EMPTY_ROW_SET, true);
        return new ArrayEventIterator(result.getFirst());
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean hasAggregation() {
        return false;
    }

    @Override
    public void applyViewResult(EventBean[] newData, EventBean[] oldData) {
    }

    @Override
    public void applyJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents) {
    }

    @Override
    public void processOutputLimitedLastAllNonBufferedView(EventBean[] newData, EventBean[] oldData, boolean isGenerateSynthetic, boolean isAll) {
        if (isAll) {
            this.outputAllHelper.processView(newData, oldData);
        } else {
            this.outputLastHelper.processView(newData, oldData);
        }
    }

    @Override
    public void processOutputLimitedLastAllNonBufferedJoin(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, boolean isGenerateSynthetic, boolean isAll) {
        if (isAll) {
            this.outputAllHelper.processJoin(newEvents, oldEvents);
        } else {
            this.outputLastHelper.processJoin(newEvents, oldEvents);
        }
    }

    @Override
    public UniformPair<EventBean[]> continueOutputLimitedLastAllNonBufferedView(boolean isSynthesize, boolean isAll) {
        if (isAll) {
            return this.outputAllHelper.outputView(isSynthesize);
        }
        return this.outputLastHelper.outputView(isSynthesize);
    }

    @Override
    public UniformPair<EventBean[]> continueOutputLimitedLastAllNonBufferedJoin(boolean isSynthesize, boolean isAll) {
        if (isAll) {
            return this.outputAllHelper.outputJoin(isSynthesize);
        }
        return this.outputLastHelper.outputJoin(isSynthesize);
    }

    @Override
    public void stop() {
        if (this.outputLastHelper != null) {
            this.outputLastHelper.destroy();
        }
        if (this.outputAllHelper != null) {
            this.outputAllHelper.destroy();
        }
    }
}

