/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.variable.VariableReader;

public class RowLimitProcessor {
    private final VariableReader numRowsVariableReader;
    private final VariableReader offsetVariableReader;
    private int currentRowLimit;
    private int currentOffset;

    public RowLimitProcessor(VariableReader numRowsVariableReader, VariableReader offsetVariableReader, int currentRowLimit, int currentOffset) {
        this.numRowsVariableReader = numRowsVariableReader;
        this.offsetVariableReader = offsetVariableReader;
        this.currentRowLimit = currentRowLimit;
        this.currentOffset = currentOffset;
    }

    public int getCurrentRowLimit() {
        return this.currentRowLimit;
    }

    public int getCurrentOffset() {
        return this.currentOffset;
    }

    protected EventBean[] determineLimitAndApply(EventBean[] outgoingEvents) {
        if (outgoingEvents == null) {
            return null;
        }
        this.determineCurrentLimit();
        return this.applyLimit(outgoingEvents);
    }

    protected void determineCurrentLimit() {
        Number varValue;
        if (this.numRowsVariableReader != null) {
            varValue = (Number)this.numRowsVariableReader.getValue();
            this.currentRowLimit = varValue != null ? varValue.intValue() : Integer.MAX_VALUE;
            if (this.currentRowLimit < 0) {
                this.currentRowLimit = Integer.MAX_VALUE;
            }
        }
        if (this.offsetVariableReader != null) {
            varValue = (Number)this.offsetVariableReader.getValue();
            this.currentOffset = varValue != null ? varValue.intValue() : 0;
            if (this.currentOffset < 0) {
                this.currentOffset = 0;
            }
        }
    }

    protected EventBean[] applyLimit(EventBean[] outgoingEvents) {
        if (this.currentOffset == 0) {
            if (outgoingEvents.length <= this.currentRowLimit) {
                return outgoingEvents;
            }
            if (this.currentRowLimit == 0) {
                return null;
            }
            EventBean[] limited = new EventBean[this.currentRowLimit];
            System.arraycopy(outgoingEvents, 0, limited, 0, this.currentRowLimit);
            return limited;
        }
        int maxInterested = this.currentRowLimit + this.currentOffset;
        if (this.currentRowLimit == Integer.MAX_VALUE) {
            maxInterested = Integer.MAX_VALUE;
        }
        if (outgoingEvents.length > maxInterested) {
            EventBean[] limited = new EventBean[this.currentRowLimit];
            System.arraycopy(outgoingEvents, this.currentOffset, limited, 0, this.currentRowLimit);
            return limited;
        }
        if (outgoingEvents.length <= this.currentOffset) {
            return null;
        }
        int size = outgoingEvents.length - this.currentOffset;
        EventBean[] limited = new EventBean[size];
        System.arraycopy(outgoingEvents, this.currentOffset, limited, 0, size);
        return limited;
    }
}

