/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.soda.ForClauseKeyword;
import com.espertech.esper.core.context.util.ContextDescriptor;
import com.espertech.esper.core.service.StatementResultService;
import com.espertech.esper.epl.core.BindProcessor;
import com.espertech.esper.epl.core.GroupByRollupInfo;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.SelectExprEventTypeRegistry;
import com.espertech.esper.epl.core.SelectExprJoinWildcardProcessorFactory;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.core.SelectExprProcessorDeliveryCallback;
import com.espertech.esper.epl.core.SelectExprProcessorHelper;
import com.espertech.esper.epl.core.SelectExprProcessorWDeliveryCallback;
import com.espertech.esper.epl.core.SelectExprResultProcessor;
import com.espertech.esper.epl.core.SelectExprWildcardProcessor;
import com.espertech.esper.epl.core.SelectExprWildcardTableProcessor;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.core.eval.SelectExprStreamDesc;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.dot.ExprDotNode;
import com.espertech.esper.epl.named.NamedWindowMgmtService;
import com.espertech.esper.epl.spec.ForClauseItemSpec;
import com.espertech.esper.epl.spec.ForClauseSpec;
import com.espertech.esper.epl.spec.InsertIntoDesc;
import com.espertech.esper.epl.spec.IntoTableSpec;
import com.espertech.esper.epl.spec.SelectClauseElementCompiled;
import com.espertech.esper.epl.spec.SelectClauseElementWildcard;
import com.espertech.esper.epl.spec.SelectClauseExprCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseStreamCompiledSpec;
import com.espertech.esper.epl.table.mgmt.TableService;
import com.espertech.esper.epl.table.mgmt.TableServiceUtil;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.event.vaevent.ValueAddEventService;
import com.espertech.esper.schedule.TimeProvider;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelectExprProcessorFactory {
    private static final Log log = LogFactory.getLog(SelectExprProcessorFactory.class);

    public static SelectExprProcessor getProcessor(Collection<Integer> assignedTypeNumberStack, SelectClauseElementCompiled[] selectionList, boolean isUsingWildcard, InsertIntoDesc insertIntoDesc, EventType optionalInsertIntoEventType, ForClauseSpec forClauseSpec, StreamTypeService typeService, EventAdapterService eventAdapterService, StatementResultService statementResultService, ValueAddEventService valueAddEventService, SelectExprEventTypeRegistry selectExprEventTypeRegistry, MethodResolutionService methodResolutionService, ExprEvaluatorContext exprEvaluatorContext, VariableService variableService, TableService tableService, TimeProvider timeProvider, String engineURI, int statementId, String statementName, Annotation[] annotations, ContextDescriptor contextDescriptor, ConfigurationInformation configuration, SelectExprProcessorDeliveryCallback selectExprProcessorCallback, NamedWindowMgmtService namedWindowMgmtService, IntoTableSpec intoTableClause, GroupByRollupInfo groupByRollupInfo) throws ExprValidationException {
        if (selectExprProcessorCallback != null) {
            BindProcessor bindProcessor = new BindProcessor(selectionList, typeService.getEventTypes(), typeService.getStreamNames(), tableService);
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            for (int i = 0; i < bindProcessor.getColumnNamesAssigned().length; ++i) {
                properties.put(bindProcessor.getColumnNamesAssigned()[i], bindProcessor.getExpressionTypes()[i]);
            }
            EventType eventType = eventAdapterService.createAnonymousObjectArrayType("Output_" + statementName, properties);
            return new SelectExprProcessorWDeliveryCallback(eventType, bindProcessor, selectExprProcessorCallback);
        }
        SelectExprProcessor synthetic = SelectExprProcessorFactory.getProcessorInternal(assignedTypeNumberStack, selectionList, isUsingWildcard, insertIntoDesc, optionalInsertIntoEventType, typeService, eventAdapterService, valueAddEventService, selectExprEventTypeRegistry, methodResolutionService, statementId, annotations, configuration, namedWindowMgmtService, tableService, groupByRollupInfo);
        if (statementResultService != null) {
            ExprNode[] groupedDeliveryExpr = null;
            boolean forDelivery = false;
            if (forClauseSpec != null) {
                for (ForClauseItemSpec item : forClauseSpec.getClauses()) {
                    if (item.getKeyword() == null) {
                        throw new ExprValidationException("Expected any of the " + Arrays.toString((Object[])ForClauseKeyword.values()).toLowerCase() + " for-clause keywords after reserved keyword 'for'");
                    }
                    try {
                        ForClauseKeyword keyword = ForClauseKeyword.valueOf(item.getKeyword().toUpperCase());
                        if (keyword == ForClauseKeyword.GROUPED_DELIVERY && item.getExpressions().isEmpty()) {
                            throw new ExprValidationException("The for-clause with the " + ForClauseKeyword.GROUPED_DELIVERY.getName() + " keyword requires one or more grouping expressions");
                        }
                        if (keyword == ForClauseKeyword.DISCRETE_DELIVERY && !item.getExpressions().isEmpty()) {
                            throw new ExprValidationException("The for-clause with the " + ForClauseKeyword.DISCRETE_DELIVERY.getName() + " keyword does not allow grouping expressions");
                        }
                        if (forDelivery) {
                            throw new ExprValidationException("The for-clause with delivery keywords may only occur once in a statement");
                        }
                    }
                    catch (RuntimeException ex) {
                        throw new ExprValidationException("Expected any of the " + Arrays.toString((Object[])ForClauseKeyword.values()).toLowerCase() + " for-clause keywords after reserved keyword 'for'");
                    }
                    StreamTypeServiceImpl type = new StreamTypeServiceImpl(synthetic.getResultEventType(), null, false, engineURI);
                    groupedDeliveryExpr = new ExprNode[item.getExpressions().size()];
                    ExprValidationContext validationContext = new ExprValidationContext(type, methodResolutionService, null, timeProvider, variableService, tableService, exprEvaluatorContext, eventAdapterService, statementName, statementId, annotations, null, false, false, true, false, intoTableClause == null ? null : intoTableClause.getName(), false);
                    for (int i = 0; i < item.getExpressions().size(); ++i) {
                        groupedDeliveryExpr[i] = ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.FORCLAUSE, item.getExpressions().get(i), validationContext);
                    }
                    forDelivery = true;
                }
            }
            BindProcessor bindProcessor = new BindProcessor(selectionList, typeService.getEventTypes(), typeService.getStreamNames(), tableService);
            statementResultService.setSelectClause(bindProcessor.getExpressionTypes(), bindProcessor.getColumnNamesAssigned(), forDelivery, ExprNodeUtility.getEvaluators(groupedDeliveryExpr), exprEvaluatorContext);
            return new SelectExprResultProcessor(statementResultService, synthetic, bindProcessor);
        }
        return synthetic;
    }

    private static SelectExprProcessor getProcessorInternal(Collection<Integer> assignedTypeNumberStack, SelectClauseElementCompiled[] selectionList, boolean isUsingWildcard, InsertIntoDesc insertIntoDesc, EventType optionalInsertIntoEventType, StreamTypeService typeService, EventAdapterService eventAdapterService, ValueAddEventService valueAddEventService, SelectExprEventTypeRegistry selectExprEventTypeRegistry, MethodResolutionService methodResolutionService, int statementId, Annotation[] annotations, ConfigurationInformation configuration, NamedWindowMgmtService namedWindowMgmtService, TableService tableService, GroupByRollupInfo groupByRollupInfo) throws ExprValidationException {
        if (isUsingWildcard && insertIntoDesc != null && !insertIntoDesc.getColumnNames().isEmpty()) {
            throw new ExprValidationException("Wildcard not allowed when insert-into specifies column order");
        }
        if (SelectExprProcessorFactory.isWildcardsOnly(selectionList)) {
            if (typeService.getStreamNames().length > 1) {
                log.debug((Object)".getProcessor Using SelectExprJoinWildcardProcessor");
                return SelectExprJoinWildcardProcessorFactory.create(assignedTypeNumberStack, statementId, typeService.getStreamNames(), typeService.getEventTypes(), eventAdapterService, insertIntoDesc, selectExprEventTypeRegistry, methodResolutionService, annotations, configuration, tableService);
            }
            if (insertIntoDesc == null) {
                log.debug((Object)".getProcessor Using wildcard processor");
                if (typeService.hasTableTypes()) {
                    String tableName = TableServiceUtil.getTableNameFromEventType(typeService.getEventTypes()[0]);
                    return new SelectExprWildcardTableProcessor(tableName, tableService);
                }
                return new SelectExprWildcardProcessor(typeService.getEventTypes()[0]);
            }
        }
        if (insertIntoDesc == null) {
            SelectExprProcessorFactory.verifyNameUniqueness(selectionList);
        }
        SelectExprBuckets buckets = SelectExprProcessorFactory.getSelectExpressionBuckets(selectionList);
        SelectExprProcessorHelper factory = new SelectExprProcessorHelper(assignedTypeNumberStack, buckets.expressions, buckets.selectedStreams, insertIntoDesc, optionalInsertIntoEventType, isUsingWildcard, typeService, eventAdapterService, valueAddEventService, selectExprEventTypeRegistry, methodResolutionService, statementId, annotations, configuration, namedWindowMgmtService, tableService, groupByRollupInfo);
        SelectExprProcessor processor = factory.getEvaluator();
        EventTypeSPI type = (EventTypeSPI)processor.getResultEventType();
        if (!typeService.isOnDemandStreams() && type.getMetadata().getTypeClass() != EventTypeMetadata.TypeClass.ANONYMOUS) {
            selectExprEventTypeRegistry.add(processor.getResultEventType());
        }
        return processor;
    }

    protected static void verifyNameUniqueness(SelectClauseElementCompiled[] selectionList) throws ExprValidationException {
        HashSet<String> names = new HashSet<String>();
        for (SelectClauseElementCompiled element : selectionList) {
            SelectClauseStreamCompiledSpec stream;
            if (element instanceof SelectClauseExprCompiledSpec) {
                SelectClauseExprCompiledSpec expr = (SelectClauseExprCompiledSpec)element;
                if (names.contains(expr.getAssignedName())) {
                    throw new ExprValidationException("Column name '" + expr.getAssignedName() + "' appears more then once in select clause");
                }
                names.add(expr.getAssignedName());
                continue;
            }
            if (!(element instanceof SelectClauseStreamCompiledSpec) || (stream = (SelectClauseStreamCompiledSpec)element).getOptionalName() == null) continue;
            if (names.contains(stream.getOptionalName())) {
                throw new ExprValidationException("Column name '" + stream.getOptionalName() + "' appears more then once in select clause");
            }
            names.add(stream.getOptionalName());
        }
    }

    private static boolean isWildcardsOnly(SelectClauseElementCompiled[] elements) {
        for (SelectClauseElementCompiled element : elements) {
            if (element instanceof SelectClauseElementWildcard) continue;
            return false;
        }
        return true;
    }

    private static SelectExprBuckets getSelectExpressionBuckets(SelectClauseElementCompiled[] elements) {
        ArrayList<SelectClauseExprCompiledSpec> expressions = new ArrayList<SelectClauseExprCompiledSpec>();
        ArrayList<SelectExprStreamDesc> selectedStreams = new ArrayList<SelectExprStreamDesc>();
        for (SelectClauseElementCompiled element : elements) {
            if (element instanceof SelectClauseExprCompiledSpec) {
                SelectClauseExprCompiledSpec expr = (SelectClauseExprCompiledSpec)element;
                if (!SelectExprProcessorFactory.isTransposingFunction(expr.getSelectExpression())) {
                    expressions.add(expr);
                    continue;
                }
                selectedStreams.add(new SelectExprStreamDesc(expr));
                continue;
            }
            if (!(element instanceof SelectClauseStreamCompiledSpec)) continue;
            selectedStreams.add(new SelectExprStreamDesc((SelectClauseStreamCompiledSpec)element));
        }
        return new SelectExprBuckets(expressions, selectedStreams);
    }

    private static boolean isTransposingFunction(ExprNode selectExpression) {
        if (!(selectExpression instanceof ExprDotNode)) {
            return false;
        }
        ExprDotNode dotNode = (ExprDotNode)selectExpression;
        return dotNode.getChainSpec().get(0).getName().toLowerCase().equals("transpose");
    }

    public static class SelectExprBuckets {
        private final List<SelectClauseExprCompiledSpec> expressions;
        private final List<SelectExprStreamDesc> selectedStreams;

        public SelectExprBuckets(List<SelectClauseExprCompiledSpec> expressions, List<SelectExprStreamDesc> selectedStreams) {
            this.expressions = expressions;
            this.selectedStreams = selectedStreams;
        }

        public List<SelectExprStreamDesc> getSelectedStreams() {
            return this.selectedStreams;
        }

        public List<SelectClauseExprCompiledSpec> getExpressions() {
            return this.expressions;
        }
    }
}

