/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.calop;

import com.espertech.esper.client.util.DateTime;
import com.espertech.esper.client.util.TimePeriod;
import com.espertech.esper.epl.datetime.calop.CalendarOpPlusFastAddResult;
import com.espertech.esper.epl.datetime.calop.CalendarOpPlusMinus;
import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CalendarOpPlusFastAddHelper {
    private static boolean DEBUG = false;
    private static Log log = LogFactory.getLog(CalendarOpPlusFastAddHelper.class);

    public static CalendarOpPlusFastAddResult computeNextDue(long currentTime, TimePeriod timePeriod, Calendar reference) {
        long multiplierRoundedLong;
        if (reference.getTimeInMillis() > currentTime) {
            return new CalendarOpPlusFastAddResult(0L, reference);
        }
        Calendar work = (Calendar)reference.clone();
        if (DEBUG && log.isDebugEnabled()) {
            log.debug((Object)("Work date is " + DateTime.print(work)));
        }
        CalendarOpPlusMinus.actionSafeOverflow(work, 1, timePeriod);
        long inMillis = work.getTimeInMillis();
        if (inMillis > currentTime) {
            return new CalendarOpPlusFastAddResult(1L, work);
        }
        if (DEBUG && log.isDebugEnabled()) {
            log.debug((Object)("Work date is " + DateTime.print(work)));
        }
        long factor = 1L;
        long deltaCurrentToStart = currentTime - reference.getTimeInMillis();
        long deltaAddedOne = work.getTimeInMillis() - reference.getTimeInMillis();
        double multiplierDbl = deltaCurrentToStart / deltaAddedOne - 1L;
        for (multiplierRoundedLong = (long)multiplierDbl; multiplierRoundedLong > Integer.MAX_VALUE; multiplierRoundedLong -= Integer.MAX_VALUE) {
            CalendarOpPlusMinus.actionSafeOverflow(work, Integer.MAX_VALUE, timePeriod);
            factor += Integer.MAX_VALUE;
            if (!DEBUG || !log.isDebugEnabled()) continue;
            log.debug((Object)("Work date is " + DateTime.print(work) + " factor " + factor));
        }
        int multiplierRoundedInt = (int)multiplierRoundedLong;
        CalendarOpPlusMinus.actionSafeOverflow(work, multiplierRoundedInt, timePeriod);
        factor += (long)multiplierRoundedInt;
        if (work.getTimeInMillis() <= currentTime) {
            while (work.getTimeInMillis() <= currentTime) {
                CalendarOpPlusMinus.actionSafeOverflow(work, 1, timePeriod);
                ++factor;
                if (!DEBUG || !log.isDebugEnabled()) continue;
                log.debug((Object)("Work date is " + DateTime.print(work) + " factor " + factor));
            }
            return new CalendarOpPlusFastAddResult(factor, work);
        }
        while (work.getTimeInMillis() > currentTime) {
            CalendarOpPlusMinus.actionSafeOverflow(work, -1, timePeriod);
            --factor;
            if (!DEBUG || !log.isDebugEnabled()) continue;
            log.debug((Object)("Work date is " + DateTime.print(work) + " factor " + factor));
        }
        CalendarOpPlusMinus.actionSafeOverflow(work, 1, timePeriod);
        if (DEBUG && log.isDebugEnabled()) {
            log.debug((Object)("Work date is " + DateTime.print(work) + " factor " + factor));
        }
        return new CalendarOpPlusFastAddResult(factor + 1L, work);
    }
}

