/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.calop;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.datetime.calop.CalendarOp;
import com.espertech.esper.epl.datetime.calop.CalendarOpWithDate;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import java.util.Calendar;

public class CalendarOpWithTime
implements CalendarOp {
    private ExprEvaluator hour;
    private ExprEvaluator min;
    private ExprEvaluator sec;
    private ExprEvaluator msec;

    public CalendarOpWithTime(ExprEvaluator hour, ExprEvaluator min, ExprEvaluator sec, ExprEvaluator msec) {
        this.hour = hour;
        this.min = min;
        this.sec = sec;
        this.msec = msec;
    }

    @Override
    public void evaluate(Calendar cal, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Integer hourNum = CalendarOpWithDate.getInt(this.hour, eventsPerStream, isNewData, context);
        Integer minNum = CalendarOpWithDate.getInt(this.min, eventsPerStream, isNewData, context);
        Integer secNum = CalendarOpWithDate.getInt(this.sec, eventsPerStream, isNewData, context);
        Integer msecNum = CalendarOpWithDate.getInt(this.msec, eventsPerStream, isNewData, context);
        CalendarOpWithTime.action(cal, hourNum, minNum, secNum, msecNum);
    }

    private static void action(Calendar cal, Integer hour, Integer minute, Integer second, Integer msec) {
        if (hour != null) {
            cal.set(11, hour);
        }
        if (minute != null) {
            cal.set(12, minute);
        }
        if (second != null) {
            cal.set(13, second);
        }
        if (msec != null) {
            cal.set(14, msec);
        }
    }
}

