/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.declexpr;

import com.espertech.esper.core.context.util.ContextDescriptor;
import com.espertech.esper.epl.declexpr.ExprDeclaredNodeImpl;
import com.espertech.esper.epl.declexpr.ExprDeclaredService;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.script.ExprNodeScript;
import com.espertech.esper.epl.spec.ExpressionDeclItem;
import com.espertech.esper.epl.spec.ExpressionScriptProvided;
import java.util.Collection;
import java.util.List;

public class ExprDeclaredHelper {
    public static ExprDeclaredNodeImpl getExistsDeclaredExpr(String name, List<ExprNode> parameters, Collection<ExpressionDeclItem> expressionDeclarations, ExprDeclaredService exprDeclaredService, ContextDescriptor contextDescriptor) {
        ExpressionDeclItem found;
        if (!expressionDeclarations.isEmpty()) {
            for (ExpressionDeclItem declNode : expressionDeclarations) {
                if (!declNode.getName().equals(name)) continue;
                return new ExprDeclaredNodeImpl(declNode, parameters, contextDescriptor);
            }
        }
        if ((found = exprDeclaredService.getExpression(name)) != null) {
            return new ExprDeclaredNodeImpl(found, parameters, contextDescriptor);
        }
        return null;
    }

    public static ExprNodeScript getExistsScript(String defaultDialect, String expressionName, List<ExprNode> parameters, Collection<ExpressionScriptProvided> scriptExpressions, ExprDeclaredService exprDeclaredService) {
        ExpressionScriptProvided script;
        if (!scriptExpressions.isEmpty() && (script = ExprDeclaredHelper.findScript(expressionName, parameters.size(), scriptExpressions)) != null) {
            return new ExprNodeScript(defaultDialect, script, parameters);
        }
        List<ExpressionScriptProvided> globalScripts = exprDeclaredService.getScriptsByName(expressionName);
        ExpressionScriptProvided script2 = ExprDeclaredHelper.findScript(expressionName, parameters.size(), globalScripts);
        if (script2 != null) {
            return new ExprNodeScript(defaultDialect, script2, parameters);
        }
        return null;
    }

    private static ExpressionScriptProvided findScript(String name, int parameterCount, Collection<ExpressionScriptProvided> scriptsByName) {
        if (scriptsByName == null || scriptsByName.isEmpty()) {
            return null;
        }
        ExpressionScriptProvided nameMatchedScript = null;
        for (ExpressionScriptProvided script : scriptsByName) {
            if (script.getName().equals(name) && script.getParameterNames().size() == parameterCount) {
                return script;
            }
            if (!script.getName().equals(name)) continue;
            nameMatchedScript = script;
        }
        return nameMatchedScript;
    }
}

