/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.enummethod.dot;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.service.ExpressionResultCacheEntry;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprEvaluatorEnumeration;
import com.espertech.esper.epl.expression.core.ExprEvaluatorEnumerationGivenEvent;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.event.EventAdapterService;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class PropertyExprEvaluatorEventCollection
implements ExprEvaluatorEnumeration,
ExprEvaluatorEnumerationGivenEvent {
    private final String propertyNameCache;
    private final int streamId;
    private final EventType fragmentType;
    private final EventPropertyGetter getter;
    private final boolean disablePropertyExpressionEventCollCache;

    public PropertyExprEvaluatorEventCollection(String propertyNameCache, int streamId, EventType fragmentType, EventPropertyGetter getter, boolean disablePropertyExpressionEventCollCache) {
        this.propertyNameCache = propertyNameCache;
        this.streamId = streamId;
        this.fragmentType = fragmentType;
        this.getter = getter;
        this.disablePropertyExpressionEventCollCache = disablePropertyExpressionEventCollCache;
    }

    @Override
    public Collection<EventBean> evaluateGetROCollectionEvents(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        EventBean eventInQuestion = eventsPerStream[this.streamId];
        if (eventInQuestion == null) {
            return null;
        }
        return this.evaluateInternal(eventInQuestion, context);
    }

    @Override
    public Collection<EventBean> evaluateEventGetROCollectionEvents(EventBean event, ExprEvaluatorContext context) {
        if (event == null) {
            return null;
        }
        return this.evaluateInternal(event, context);
    }

    private Collection<EventBean> evaluateInternal(EventBean eventInQuestion, ExprEvaluatorContext context) {
        List<EventBean> coll;
        ExpressionResultCacheEntry<EventBean, Collection<EventBean>> cacheEntry;
        if (!this.disablePropertyExpressionEventCollCache && (cacheEntry = context.getExpressionResultCacheService().getPropertyColl(this.propertyNameCache, eventInQuestion)) != null) {
            return cacheEntry.getResult();
        }
        EventBean[] events = (EventBean[])this.getter.getFragment(eventInQuestion);
        List<EventBean> list = coll = events == null ? null : Arrays.asList(events);
        if (!this.disablePropertyExpressionEventCollCache) {
            context.getExpressionResultCacheService().savePropertyColl(this.propertyNameCache, eventInQuestion, coll);
        }
        if (coll == null) {
            return null;
        }
        return coll;
    }

    @Override
    public EventType getEventTypeCollection(EventAdapterService eventAdapterService, int statementId) {
        return this.fragmentType;
    }

    @Override
    public Collection evaluateGetROCollectionScalar(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public Class getComponentTypeCollection() throws ExprValidationException {
        return null;
    }

    @Override
    public EventType getEventTypeSingle(EventAdapterService eventAdapterService, int statementId) throws ExprValidationException {
        return null;
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public Collection evaluateEventGetROCollectionScalar(EventBean event, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public EventBean evaluateEventGetEventBean(EventBean event, ExprEvaluatorContext context) {
        return null;
    }
}

