/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.enummethod.eval;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.enummethod.dot.ExprDotEvalEnumMethodBase;
import com.espertech.esper.epl.enummethod.dot.ExprDotEvalParam;
import com.espertech.esper.epl.enummethod.dot.ExprDotEvalParamLambda;
import com.espertech.esper.epl.enummethod.eval.EnumEval;
import com.espertech.esper.epl.enummethod.eval.EnumEvalSumEvents;
import com.espertech.esper.epl.enummethod.eval.EnumEvalSumScalar;
import com.espertech.esper.epl.enummethod.eval.EnumEvalSumScalarLambda;
import com.espertech.esper.epl.enummethod.eval.ExprDotEvalSumMethod;
import com.espertech.esper.epl.enummethod.eval.ExprDotEvalSumMethodFactory;
import com.espertech.esper.epl.expression.dot.ExprDotNodeUtility;
import com.espertech.esper.epl.rettype.EPTypeHelper;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.arr.ObjectArrayEventType;
import com.espertech.esper.util.JavaClassHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

public class ExprDotEvalSumOf
extends ExprDotEvalEnumMethodBase {
    @Override
    public EventType[] getAddStreamTypes(String enumMethodUsedName, List<String> goesToNames, EventType inputEventType, Class collectionComponentType, List<ExprDotEvalParam> bodiesAndParameters, EventAdapterService eventAdapterService) {
        return ExprDotNodeUtility.getSingleLambdaParamEventType(enumMethodUsedName, goesToNames, inputEventType, collectionComponentType, eventAdapterService);
    }

    @Override
    public EnumEval getEnumEval(MethodResolutionService methodResolutionService, EventAdapterService eventAdapterService, StreamTypeService streamTypeService, int statementId, String enumMethodUsedName, List<ExprDotEvalParam> bodiesAndParameters, EventType inputEventType, Class collectionComponentType, int numStreamsIncoming, boolean disablePropertyExpressionEventCollCache) {
        if (bodiesAndParameters.isEmpty()) {
            ExprDotEvalSumMethodFactory aggMethodFactory = ExprDotEvalSumOf.getAggregatorFactory(collectionComponentType);
            super.setTypeInfo(EPTypeHelper.singleValue(JavaClassHelper.getBoxedType(aggMethodFactory.getValueType())));
            return new EnumEvalSumScalar(numStreamsIncoming, aggMethodFactory);
        }
        ExprDotEvalParamLambda first = (ExprDotEvalParamLambda)bodiesAndParameters.get(0);
        ExprDotEvalSumMethodFactory aggMethodFactory = ExprDotEvalSumOf.getAggregatorFactory(first.getBodyEvaluator().getType());
        Class returnType = JavaClassHelper.getBoxedType(aggMethodFactory.getValueType());
        super.setTypeInfo(EPTypeHelper.singleValue(returnType));
        if (inputEventType == null) {
            return new EnumEvalSumScalarLambda(first.getBodyEvaluator(), first.getStreamCountIncoming(), aggMethodFactory, (ObjectArrayEventType)first.getGoesToTypes()[0]);
        }
        return new EnumEvalSumEvents(first.getBodyEvaluator(), first.getStreamCountIncoming(), aggMethodFactory);
    }

    private static ExprDotEvalSumMethodFactory getAggregatorFactory(Class evalType) {
        if (JavaClassHelper.isFloatingPointClass(evalType)) {
            return new ExprDotEvalSumMethodFactory(){

                @Override
                public ExprDotEvalSumMethod getSumAggregator() {
                    return new ExprDotEvalSumMethodDouble();
                }

                @Override
                public Class getValueType() {
                    return Double.class;
                }
            };
        }
        if (evalType == BigDecimal.class) {
            return new ExprDotEvalSumMethodFactory(){

                @Override
                public ExprDotEvalSumMethod getSumAggregator() {
                    return new ExprDotEvalSumMethodBigDecimal();
                }

                @Override
                public Class getValueType() {
                    return BigDecimal.class;
                }
            };
        }
        if (evalType == BigInteger.class) {
            return new ExprDotEvalSumMethodFactory(){

                @Override
                public ExprDotEvalSumMethod getSumAggregator() {
                    return new ExprDotEvalSumMethodBigInteger();
                }

                @Override
                public Class getValueType() {
                    return BigInteger.class;
                }
            };
        }
        if (JavaClassHelper.getBoxedType(evalType) == Long.class) {
            return new ExprDotEvalSumMethodFactory(){

                @Override
                public ExprDotEvalSumMethod getSumAggregator() {
                    return new ExprDotEvalSumMethodLong();
                }

                @Override
                public Class getValueType() {
                    return Long.class;
                }
            };
        }
        return new ExprDotEvalSumMethodFactory(){

            @Override
            public ExprDotEvalSumMethod getSumAggregator() {
                return new ExprDotEvalSumMethodInteger();
            }

            @Override
            public Class getValueType() {
                return Integer.class;
            }
        };
    }

    private static class ExprDotEvalSumMethodInteger
    implements ExprDotEvalSumMethod {
        protected int sum;
        protected long numDataPoints;

        private ExprDotEvalSumMethodInteger() {
        }

        @Override
        public void enter(Object object) {
            if (object == null) {
                return;
            }
            ++this.numDataPoints;
            this.sum += ((Integer)object).intValue();
        }

        @Override
        public Object getValue() {
            if (this.numDataPoints == 0L) {
                return null;
            }
            return this.sum;
        }
    }

    private static class ExprDotEvalSumMethodLong
    implements ExprDotEvalSumMethod {
        protected long sum;
        protected long numDataPoints;

        private ExprDotEvalSumMethodLong() {
        }

        @Override
        public void enter(Object object) {
            if (object == null) {
                return;
            }
            ++this.numDataPoints;
            this.sum += ((Long)object).longValue();
        }

        @Override
        public Object getValue() {
            if (this.numDataPoints == 0L) {
                return null;
            }
            return this.sum;
        }
    }

    private static class ExprDotEvalSumMethodBigInteger
    implements ExprDotEvalSumMethod {
        protected BigInteger sum = BigInteger.valueOf(0L);
        protected long numDataPoints;

        @Override
        public void enter(Object object) {
            if (object == null) {
                return;
            }
            ++this.numDataPoints;
            this.sum = this.sum.add((BigInteger)object);
        }

        @Override
        public Object getValue() {
            if (this.numDataPoints == 0L) {
                return null;
            }
            return this.sum;
        }
    }

    private static class ExprDotEvalSumMethodBigDecimal
    implements ExprDotEvalSumMethod {
        protected BigDecimal sum = new BigDecimal(0.0);
        protected long numDataPoints;

        @Override
        public void enter(Object object) {
            if (object == null) {
                return;
            }
            ++this.numDataPoints;
            this.sum = this.sum.add((BigDecimal)object);
        }

        @Override
        public Object getValue() {
            if (this.numDataPoints == 0L) {
                return null;
            }
            return this.sum;
        }
    }

    private static class ExprDotEvalSumMethodDouble
    implements ExprDotEvalSumMethod {
        protected double sum;
        protected long numDataPoints;

        private ExprDotEvalSumMethodDouble() {
        }

        @Override
        public void enter(Object object) {
            if (object == null) {
                return;
            }
            ++this.numDataPoints;
            this.sum += ((Double)object).doubleValue();
        }

        @Override
        public Object getValue() {
            if (this.numDataPoints == 0L) {
                return null;
            }
            return this.sum;
        }
    }
}

