/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import java.io.StringWriter;
import java.util.Arrays;

public class ExprContextPropertyNode
extends ExprNodeBase
implements ExprEvaluator {
    private static final long serialVersionUID = 2816977190089087618L;
    private final String propertyName;
    private Class returnType;
    private transient EventPropertyGetter getter;

    public ExprContextPropertyNode(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (validationContext.getContextDescriptor() == null) {
            throw new ExprValidationException("Context property '" + this.propertyName + "' cannot be used in the expression as provided");
        }
        EventType eventType = validationContext.getContextDescriptor().getContextPropertyRegistry().getContextEventType();
        if (eventType == null) {
            throw new ExprValidationException("Context property '" + this.propertyName + "' cannot be used in the expression as provided");
        }
        this.getter = eventType.getGetter(this.propertyName);
        if (this.getter == null) {
            throw new ExprValidationException("Context property '" + this.propertyName + "' is not a known property, known properties are " + Arrays.toString(eventType.getPropertyNames()));
        }
        this.returnType = eventType.getPropertyType(this.propertyName);
        return null;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (context.getContextProperties() != null) {
            return this.getter.get(context.getContextProperties());
        }
        return null;
    }

    @Override
    public Class getType() {
        return this.returnType;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append(this.propertyName);
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    public EventPropertyGetter getGetter() {
        return this.getter;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (this == node) {
            return true;
        }
        if (node == null || this.getClass() != node.getClass()) {
            return false;
        }
        ExprContextPropertyNode that = (ExprContextPropertyNode)node;
        return this.propertyName.equals(that.propertyName);
    }
}

