/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.core;

import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.core.context.util.ContextDescriptor;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.core.ViewResourceDelegateUnverified;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.table.mgmt.TableService;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.schedule.TimeProvider;
import java.lang.annotation.Annotation;

public class ExprValidationContext {
    private final StreamTypeService streamTypeService;
    private final MethodResolutionService methodResolutionService;
    private final ViewResourceDelegateUnverified viewResourceDelegate;
    private final TimeProvider timeProvider;
    private final VariableService variableService;
    private final TableService tableService;
    private final ExprEvaluatorContext exprEvaluatorContext;
    private final EventAdapterService eventAdapterService;
    private final String statementName;
    private final int statementId;
    private final Annotation[] annotations;
    private final ContextDescriptor contextDescriptor;
    private final boolean disablePropertyExpressionEventCollCache;
    private final boolean allowRollupFunctions;
    private final boolean allowBindingConsumption;
    private final boolean isResettingAggregations;
    private final boolean isExpressionNestedAudit;
    private final boolean isExpressionAudit;
    private final String intoTableName;
    private final boolean isFilterExpression;

    public ExprValidationContext(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegateUnverified viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, TableService tableService, ExprEvaluatorContext exprEvaluatorContext, EventAdapterService eventAdapterService, String statementName, int statementId, Annotation[] annotations, ContextDescriptor contextDescriptor, boolean disablePropertyExpressionEventCollCache, boolean allowRollupFunctions, boolean allowBindingConsumption, boolean isUnidirectionalJoin, String intoTableName, boolean isFilterExpression) {
        this.streamTypeService = streamTypeService;
        this.methodResolutionService = methodResolutionService;
        this.viewResourceDelegate = viewResourceDelegate;
        this.timeProvider = timeProvider;
        this.variableService = variableService;
        this.tableService = tableService;
        this.exprEvaluatorContext = exprEvaluatorContext;
        this.eventAdapterService = eventAdapterService;
        this.statementName = statementName;
        this.statementId = statementId;
        this.annotations = annotations;
        this.contextDescriptor = contextDescriptor;
        this.disablePropertyExpressionEventCollCache = disablePropertyExpressionEventCollCache;
        this.allowRollupFunctions = allowRollupFunctions;
        this.allowBindingConsumption = allowBindingConsumption;
        this.isResettingAggregations = isUnidirectionalJoin;
        this.intoTableName = intoTableName;
        this.isFilterExpression = isFilterExpression;
        this.isExpressionAudit = AuditEnum.EXPRESSION.getAudit(annotations) != null;
        this.isExpressionNestedAudit = AuditEnum.EXPRESSION_NESTED.getAudit(annotations) != null;
    }

    public ExprValidationContext(StreamTypeServiceImpl types, ExprValidationContext ctx) {
        this(types, ctx.getMethodResolutionService(), ctx.getViewResourceDelegate(), ctx.getTimeProvider(), ctx.getVariableService(), ctx.getTableService(), ctx.getExprEvaluatorContext(), ctx.getEventAdapterService(), ctx.getStatementName(), ctx.getStatementId(), ctx.getAnnotations(), ctx.getContextDescriptor(), ctx.isDisablePropertyExpressionEventCollCache(), false, ctx.isAllowBindingConsumption(), ctx.isResettingAggregations(), ctx.getIntoTableName(), false);
    }

    public StreamTypeService getStreamTypeService() {
        return this.streamTypeService;
    }

    public MethodResolutionService getMethodResolutionService() {
        return this.methodResolutionService;
    }

    public ViewResourceDelegateUnverified getViewResourceDelegate() {
        return this.viewResourceDelegate;
    }

    public TimeProvider getTimeProvider() {
        return this.timeProvider;
    }

    public VariableService getVariableService() {
        return this.variableService;
    }

    public ExprEvaluatorContext getExprEvaluatorContext() {
        return this.exprEvaluatorContext;
    }

    public EventAdapterService getEventAdapterService() {
        return this.eventAdapterService;
    }

    public String getStatementName() {
        return this.statementName;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public boolean isExpressionNestedAudit() {
        return this.isExpressionNestedAudit;
    }

    public boolean isExpressionAudit() {
        return this.isExpressionAudit;
    }

    public int getStatementId() {
        return this.statementId;
    }

    public ContextDescriptor getContextDescriptor() {
        return this.contextDescriptor;
    }

    public boolean isDisablePropertyExpressionEventCollCache() {
        return this.disablePropertyExpressionEventCollCache;
    }

    public boolean isAllowRollupFunctions() {
        return this.allowRollupFunctions;
    }

    public TableService getTableService() {
        return this.tableService;
    }

    public boolean isAllowBindingConsumption() {
        return this.allowBindingConsumption;
    }

    public boolean isResettingAggregations() {
        return this.isResettingAggregations;
    }

    public String getIntoTableName() {
        return this.intoTableName;
    }

    public boolean isFilterExpression() {
        return this.isFilterExpression;
    }
}

