/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.funcs;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class ExprInstanceofNode
extends ExprNodeBase
implements ExprEvaluator {
    private final String[] classIdentifiers;
    private Class[] classes;
    private CopyOnWriteArrayList<Pair<Class, Boolean>> resultCache = new CopyOnWriteArrayList();
    private transient ExprEvaluator evaluator;
    private static final long serialVersionUID = 3358616797009364727L;

    public ExprInstanceofNode(String[] classIdentifiers) {
        this.classIdentifiers = classIdentifiers;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 1) {
            throw new ExprValidationException("Instanceof node must have 1 child expression node supplying the expression to test");
        }
        if (this.classIdentifiers == null || this.classIdentifiers.length == 0) {
            throw new ExprValidationException("Instanceof node must have 1 or more class identifiers to verify type against");
        }
        this.evaluator = this.getChildNodes()[0].getExprEvaluator();
        Set<Class> classList = this.getClassSet(this.classIdentifiers);
        ExprInstanceofNode exprInstanceofNode = this;
        synchronized (exprInstanceofNode) {
            this.classes = classList.toArray(new Class[classList.size()]);
        }
        return null;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Class getType() {
        return Boolean.class;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object result = this.evaluator.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (result == null) {
            return false;
        }
        for (Pair<Class, Boolean> pair : this.resultCache) {
            if (pair.getFirst() != result.getClass()) continue;
            return pair.getSecond();
        }
        Boolean out = this.checkAddType(result.getClass());
        return out;
    }

    private synchronized Boolean checkAddType(Class type) {
        for (Pair<Class, Boolean> pair : this.resultCache) {
            if (pair.getFirst() != type) continue;
            return pair.getSecond();
        }
        HashSet<Class> classesToCheck = new HashSet<Class>();
        JavaClassHelper.getSuper(type, classesToCheck);
        classesToCheck.add(type);
        boolean fits = false;
        for (Class clazz : this.classes) {
            if (!classesToCheck.contains(clazz)) continue;
            fits = true;
            break;
        }
        this.resultCache.add(new Pair<Class, Boolean>(type, fits));
        return fits;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append("instanceof(");
        this.getChildNodes()[0].toEPL(writer, ExprPrecedenceEnum.MINIMUM);
        writer.append(",");
        String delimiter = "";
        for (int i = 0; i < this.classIdentifiers.length; ++i) {
            writer.append(delimiter);
            writer.append(this.classIdentifiers[i]);
            delimiter = ",";
        }
        writer.append(')');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprInstanceofNode)) {
            return false;
        }
        ExprInstanceofNode other = (ExprInstanceofNode)node;
        return Arrays.equals(other.classIdentifiers, this.classIdentifiers);
    }

    public String[] getClassIdentifiers() {
        return this.classIdentifiers;
    }

    private Set<Class> getClassSet(String[] classIdentifiers) throws ExprValidationException {
        HashSet<Class> classList = new HashSet<Class>();
        for (String className : classIdentifiers) {
            Class clazz = JavaClassHelper.getPrimitiveClassForName(className.trim());
            if (clazz != null) {
                classList.add(clazz);
                classList.add(JavaClassHelper.getBoxedType(clazz));
                continue;
            }
            try {
                clazz = JavaClassHelper.getClassForName(className.trim());
            }
            catch (ClassNotFoundException e) {
                throw new ExprValidationException("Class as listed in instanceof function by name '" + className + "' cannot be loaded", e);
            }
            classList.add(JavaClassHelper.getPrimitiveType(clazz));
            classList.add(JavaClassHelper.getBoxedType(clazz));
        }
        return classList;
    }
}

