/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.methodagg;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.agg.access.AggregationAccessor;
import com.espertech.esper.epl.agg.access.AggregationAgent;
import com.espertech.esper.epl.agg.access.AggregationStateKey;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationMethodFactoryUtil;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.core.ExprWildcard;
import com.espertech.esper.epl.expression.methodagg.ExprCountNode;
import com.espertech.esper.epl.expression.methodagg.ExprMethodAggUtil;

public class ExprCountNodeFactory
implements AggregationMethodFactory {
    private final ExprCountNode parent;
    private final boolean ignoreNulls;
    private final Class countedValueType;

    public ExprCountNodeFactory(ExprCountNode parent, boolean ignoreNulls, Class countedValueType) {
        this.parent = parent;
        this.ignoreNulls = ignoreNulls;
        this.countedValueType = countedValueType;
    }

    @Override
    public boolean isAccessAggregation() {
        return false;
    }

    @Override
    public Class getResultType() {
        return Long.class;
    }

    @Override
    public AggregationStateKey getAggregationStateKey(boolean isMatchRecognize) {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationStateFactory getAggregationStateFactory(boolean isMatchRecognize) {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationAccessor getAccessor() {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationMethod make(MethodResolutionService methodResolutionService, int agentInstanceId, int groupId, int aggregationId) {
        AggregationMethod method = methodResolutionService.makeCountAggregator(agentInstanceId, groupId, aggregationId, this.ignoreNulls, this.parent.isHasFilter());
        if (!this.parent.isDistinct()) {
            return method;
        }
        return methodResolutionService.makeDistinctAggregator(agentInstanceId, groupId, aggregationId, method, this.countedValueType, this.parent.isHasFilter());
    }

    @Override
    public ExprAggregateNodeBase getAggregationExpression() {
        return this.parent;
    }

    @Override
    public void validateIntoTableCompatible(AggregationMethodFactory intoTableAgg) throws ExprValidationException {
        AggregationMethodFactoryUtil.validateAggregationType(this, intoTableAgg);
        ExprCountNodeFactory that = (ExprCountNodeFactory)intoTableAgg;
        AggregationMethodFactoryUtil.validateAggregationFilter(this.parent.isHasFilter(), that.parent.isHasFilter());
        if (this.parent.isDistinct()) {
            AggregationMethodFactoryUtil.validateAggregationInputType(this.countedValueType, that.countedValueType);
        }
        if (this.ignoreNulls != that.ignoreNulls) {
            throw new ExprValidationException("The aggregation declares" + (this.ignoreNulls ? "" : " no") + " ignore nulls and provided is" + (that.ignoreNulls ? "" : " no") + " ignore nulls");
        }
    }

    @Override
    public AggregationAgent getAggregationStateAgent() {
        return null;
    }

    @Override
    public ExprEvaluator getMethodAggregationEvaluator(boolean join, EventType[] typesPerStream) throws ExprValidationException {
        return ExprCountNodeFactory.getMethodAggregationEvaluatorCountBy(this.parent.getPositionalParams(), join, typesPerStream);
    }

    public static ExprEvaluator getMethodAggregationEvaluatorCountBy(ExprNode[] childNodes, boolean join, EventType[] typesPerStream) throws ExprValidationException {
        if (childNodes[0] instanceof ExprWildcard && childNodes.length == 2) {
            return ExprMethodAggUtil.getDefaultEvaluator(new ExprNode[]{childNodes[1]}, join, typesPerStream);
        }
        if (childNodes[0] instanceof ExprWildcard && childNodes.length == 1) {
            return ExprMethodAggUtil.getDefaultEvaluator(new ExprNode[0], join, typesPerStream);
        }
        return ExprMethodAggUtil.getDefaultEvaluator(childNodes, join, typesPerStream);
    }
}

