/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.methodagg;

import com.espertech.esper.client.hook.AggregationFunctionFactory;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationValidationContext;
import com.espertech.esper.epl.expression.accessagg.ExprAggMultiFunctionUtil;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.baseagg.ExprAggregationPlugInNodeMarker;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.core.ExprWildcard;
import com.espertech.esper.epl.expression.methodagg.ExprPlugInAggFunctionFactory;

public class ExprPlugInAggFunctionFactoryNode
extends ExprAggregateNodeBase
implements ExprAggregationPlugInNodeMarker {
    private static final long serialVersionUID = 65459875362787079L;
    private transient AggregationFunctionFactory aggregationFunctionFactory;
    private final String functionName;

    public ExprPlugInAggFunctionFactoryNode(boolean distinct, AggregationFunctionFactory aggregationFunctionFactory, String functionName) {
        super(distinct);
        this.aggregationFunctionFactory = aggregationFunctionFactory;
        this.functionName = functionName;
        aggregationFunctionFactory.setFunctionName(functionName);
    }

    @Override
    public AggregationMethodFactory validateAggregationChild(ExprValidationContext validationContext) throws ExprValidationException {
        Class[] parameterTypes = new Class[this.positionalParams.length];
        Object[] constant = new Object[this.positionalParams.length];
        boolean[] isConstant = new boolean[this.positionalParams.length];
        ExprNode[] expressions = new ExprNode[this.positionalParams.length];
        int count = 0;
        boolean hasDataWindows = true;
        for (ExprNode child : this.positionalParams) {
            if (child.isConstantResult()) {
                isConstant[count] = true;
                constant[count] = child.getExprEvaluator().evaluate(null, true, validationContext.getExprEvaluatorContext());
            }
            parameterTypes[count] = child.getExprEvaluator().getType();
            expressions[count] = child;
            if (!ExprNodeUtility.hasRemoveStreamForAggregations(child, validationContext.getStreamTypeService(), validationContext.isResettingAggregations())) {
                hasDataWindows = false;
            }
            if (child instanceof ExprWildcard) {
                ExprAggMultiFunctionUtil.checkWildcardNotJoinOrSubquery(validationContext.getStreamTypeService(), this.functionName);
                parameterTypes[count] = validationContext.getStreamTypeService().getEventTypes()[0].getUnderlyingType();
                isConstant[count] = false;
                constant[count] = null;
            }
            ++count;
        }
        AggregationValidationContext context = new AggregationValidationContext(parameterTypes, isConstant, constant, super.isDistinct(), hasDataWindows, expressions);
        try {
            if (this.aggregationFunctionFactory == null) {
                this.aggregationFunctionFactory = validationContext.getMethodResolutionService().getEngineImportService().resolveAggregationFactory(this.functionName);
            }
            this.aggregationFunctionFactory.validate(context);
        }
        catch (Exception ex) {
            throw new ExprValidationException("Plug-in aggregation function '" + this.functionName + "' failed validation: " + ex.getMessage(), ex);
        }
        Class childType = null;
        if (this.positionalParams.length > 0) {
            childType = this.positionalParams[0].getExprEvaluator().getType();
        }
        return new ExprPlugInAggFunctionFactory(this, this.aggregationFunctionFactory, childType);
    }

    @Override
    public String getAggregationFunctionName() {
        return this.functionName;
    }

    @Override
    public final boolean equalsNodeAggregateMethodOnly(ExprAggregateNode node) {
        if (!(node instanceof ExprPlugInAggFunctionFactoryNode)) {
            return false;
        }
        ExprPlugInAggFunctionFactoryNode other = (ExprPlugInAggFunctionFactoryNode)node;
        return other.getAggregationFunctionName().equals(this.getAggregationFunctionName());
    }
}

