/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.ops.ExprBetweenNode;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberBigDecimalCoercer;
import com.espertech.esper.util.SimpleNumberBigIntegerCoercer;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;

public class ExprBetweenNodeImpl
extends ExprNodeBase
implements ExprEvaluator,
ExprBetweenNode {
    private final boolean isLowEndpointIncluded;
    private final boolean isHighEndpointIncluded;
    private final boolean isNotBetween;
    private boolean isAlwaysFalse;
    private transient ExprBetweenComp computer;
    private transient ExprEvaluator[] evaluators;
    private static final long serialVersionUID = -9089344387956311948L;

    public ExprBetweenNodeImpl(boolean lowEndpointIncluded, boolean highEndpointIncluded, boolean notBetween) {
        this.isLowEndpointIncluded = lowEndpointIncluded;
        this.isHighEndpointIncluded = highEndpointIncluded;
        this.isNotBetween = notBetween;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public boolean isLowEndpointIncluded() {
        return this.isLowEndpointIncluded;
    }

    @Override
    public boolean isHighEndpointIncluded() {
        return this.isHighEndpointIncluded;
    }

    @Override
    public boolean isNotBetween() {
        return this.isNotBetween;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 3) {
            throw new ExprValidationException("The Between operator requires exactly 3 child expressions");
        }
        this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes());
        Class typeOne = JavaClassHelper.getBoxedType(this.evaluators[0].getType());
        Class typeTwo = JavaClassHelper.getBoxedType(this.evaluators[1].getType());
        Class typeThree = JavaClassHelper.getBoxedType(this.evaluators[2].getType());
        if (typeOne == null) {
            throw new ExprValidationException("Null value not allowed in between-clause");
        }
        if (typeTwo == null || typeThree == null) {
            this.isAlwaysFalse = true;
        } else {
            if (typeOne != String.class || typeTwo != String.class || typeThree != String.class) {
                if (!JavaClassHelper.isNumeric(typeOne)) {
                    throw new ExprValidationException("Implicit conversion from datatype '" + typeOne.getSimpleName() + "' to numeric is not allowed");
                }
                if (!JavaClassHelper.isNumeric(typeTwo)) {
                    throw new ExprValidationException("Implicit conversion from datatype '" + typeTwo.getSimpleName() + "' to numeric is not allowed");
                }
                if (!JavaClassHelper.isNumeric(typeThree)) {
                    throw new ExprValidationException("Implicit conversion from datatype '" + typeThree.getSimpleName() + "' to numeric is not allowed");
                }
            }
            Class intermedType = JavaClassHelper.getCompareToCoercionType(typeOne, typeTwo);
            Class compareType = JavaClassHelper.getCompareToCoercionType(intermedType, typeThree);
            this.computer = this.makeComputer(compareType, typeOne, typeTwo, typeThree);
        }
        return null;
    }

    @Override
    public Class getType() {
        return Boolean.class;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.isAlwaysFalse) {
            return false;
        }
        Object value = this.evaluators[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (value == null) {
            return false;
        }
        Object lower = this.evaluators[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        Object higher = this.evaluators[2].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        boolean result = this.computer.isBetween(value, lower, higher);
        if (this.isNotBetween) {
            return !result;
        }
        return result;
    }

    @Override
    public boolean equalsNode(ExprNode node_) {
        if (!(node_ instanceof ExprBetweenNodeImpl)) {
            return false;
        }
        ExprBetweenNodeImpl other = (ExprBetweenNodeImpl)node_;
        return other.isNotBetween == this.isNotBetween;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        Iterator<ExprNode> it = Arrays.asList(this.getChildNodes()).iterator();
        it.next().toEPL(writer, this.getPrecedence());
        if (this.isNotBetween) {
            writer.append(" not between ");
        } else {
            writer.append(" between ");
        }
        it.next().toEPL(writer, this.getPrecedence());
        writer.append(" and ");
        it.next().toEPL(writer, this.getPrecedence());
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.RELATIONAL_BETWEEN_IN;
    }

    private ExprBetweenComp makeComputer(Class compareType, Class valueType, Class lowType, Class highType) {
        ExprBetweenComp computer = compareType == String.class ? new ExprBetweenCompString(this.isLowEndpointIncluded, this.isHighEndpointIncluded) : (compareType == BigDecimal.class ? new ExprBetweenCompBigDecimal(this.isLowEndpointIncluded, this.isHighEndpointIncluded, valueType, lowType, highType) : (compareType == BigInteger.class ? new ExprBetweenCompBigInteger(this.isLowEndpointIncluded, this.isHighEndpointIncluded, valueType, lowType, highType) : (compareType == Long.class ? new ExprBetweenCompLong(this.isLowEndpointIncluded, this.isHighEndpointIncluded) : new ExprBetweenCompDouble(this.isLowEndpointIncluded, this.isHighEndpointIncluded))));
        return computer;
    }

    private static class ExprBetweenCompBigInteger
    implements ExprBetweenComp {
        private boolean isLowIncluded;
        private boolean isHighIncluded;
        private SimpleNumberBigIntegerCoercer numberCoercerLower;
        private SimpleNumberBigIntegerCoercer numberCoercerUpper;
        private SimpleNumberBigIntegerCoercer numberCoercerValue;

        public ExprBetweenCompBigInteger(boolean lowIncluded, boolean highIncluded, Class valueType, Class lowerType, Class upperType) {
            this.isLowIncluded = lowIncluded;
            this.isHighIncluded = highIncluded;
            this.numberCoercerLower = SimpleNumberCoercerFactory.getCoercerBigInteger(lowerType);
            this.numberCoercerUpper = SimpleNumberCoercerFactory.getCoercerBigInteger(upperType);
            this.numberCoercerValue = SimpleNumberCoercerFactory.getCoercerBigInteger(valueType);
        }

        @Override
        public boolean isBetween(Object value, Object lower, Object upper) {
            BigInteger upperD;
            if (value == null || lower == null || upper == null) {
                return false;
            }
            BigInteger valueD = this.numberCoercerValue.coerceBoxedBigInt((Number)value);
            BigInteger lowerD = this.numberCoercerLower.coerceBoxedBigInt((Number)lower);
            if (lowerD.compareTo(upperD = this.numberCoercerUpper.coerceBoxedBigInt((Number)upper)) > 0) {
                BigInteger temp = upperD;
                upperD = lowerD;
                lowerD = temp;
            }
            if (valueD.compareTo(lowerD) > 0) {
                if (valueD.compareTo(upperD) < 0) {
                    return true;
                }
                if (this.isHighIncluded) {
                    return valueD.equals(upperD);
                }
                return false;
            }
            return this.isLowIncluded && valueD.equals(lowerD);
        }
    }

    private static class ExprBetweenCompBigDecimal
    implements ExprBetweenComp {
        private boolean isLowIncluded;
        private boolean isHighIncluded;
        private SimpleNumberBigDecimalCoercer numberCoercerLower;
        private SimpleNumberBigDecimalCoercer numberCoercerUpper;
        private SimpleNumberBigDecimalCoercer numberCoercerValue;

        public ExprBetweenCompBigDecimal(boolean lowIncluded, boolean highIncluded, Class valueType, Class lowerType, Class upperType) {
            this.isLowIncluded = lowIncluded;
            this.isHighIncluded = highIncluded;
            this.numberCoercerLower = SimpleNumberCoercerFactory.getCoercerBigDecimal(lowerType);
            this.numberCoercerUpper = SimpleNumberCoercerFactory.getCoercerBigDecimal(upperType);
            this.numberCoercerValue = SimpleNumberCoercerFactory.getCoercerBigDecimal(valueType);
        }

        @Override
        public boolean isBetween(Object valueUncast, Object lowerUncast, Object upperUncast) {
            int valueComparedLower;
            BigDecimal upper;
            if (valueUncast == null || lowerUncast == null || upperUncast == null) {
                return false;
            }
            BigDecimal value = this.numberCoercerValue.coerceBoxedBigDec((Number)valueUncast);
            BigDecimal lower = this.numberCoercerLower.coerceBoxedBigDec((Number)lowerUncast);
            if (lower.compareTo(upper = this.numberCoercerUpper.coerceBoxedBigDec((Number)upperUncast)) > 0) {
                BigDecimal temp = upper;
                upper = lower;
                lower = temp;
            }
            if ((valueComparedLower = value.compareTo(lower)) > 0) {
                int valueComparedUpper = value.compareTo(upper);
                if (valueComparedUpper < 0) {
                    return true;
                }
                return this.isHighIncluded && valueComparedUpper == 0;
            }
            return this.isLowIncluded && valueComparedLower == 0;
        }
    }

    private static class ExprBetweenCompLong
    implements ExprBetweenComp {
        private boolean isLowIncluded;
        private boolean isHighIncluded;

        public ExprBetweenCompLong(boolean lowIncluded, boolean highIncluded) {
            this.isLowIncluded = lowIncluded;
            this.isHighIncluded = highIncluded;
        }

        @Override
        public boolean isBetween(Object value, Object lower, Object upper) {
            long upperD;
            if (value == null || lower == null || upper == null) {
                return false;
            }
            long valueD = ((Number)value).longValue();
            long lowerD = ((Number)lower).longValue();
            if (lowerD > (upperD = ((Number)upper).longValue())) {
                long temp = upperD;
                upperD = lowerD;
                lowerD = temp;
            }
            if (valueD > lowerD) {
                if (valueD < upperD) {
                    return true;
                }
                if (this.isHighIncluded) {
                    return valueD == upperD;
                }
                return false;
            }
            return this.isLowIncluded && valueD == lowerD;
        }
    }

    private static class ExprBetweenCompDouble
    implements ExprBetweenComp {
        private boolean isLowIncluded;
        private boolean isHighIncluded;

        public ExprBetweenCompDouble(boolean lowIncluded, boolean highIncluded) {
            this.isLowIncluded = lowIncluded;
            this.isHighIncluded = highIncluded;
        }

        @Override
        public boolean isBetween(Object value, Object lower, Object upper) {
            double upperD;
            if (value == null || lower == null || upper == null) {
                return false;
            }
            double valueD = ((Number)value).doubleValue();
            double lowerD = ((Number)lower).doubleValue();
            if (lowerD > (upperD = ((Number)upper).doubleValue())) {
                double temp = upperD;
                upperD = lowerD;
                lowerD = temp;
            }
            if (valueD > lowerD) {
                if (valueD < upperD) {
                    return true;
                }
                if (this.isHighIncluded) {
                    return valueD == upperD;
                }
                return false;
            }
            return this.isLowIncluded && valueD == lowerD;
        }
    }

    private static class ExprBetweenCompString
    implements ExprBetweenComp {
        private boolean isLowIncluded;
        private boolean isHighIncluded;

        public ExprBetweenCompString(boolean lowIncluded, boolean isHighIncluded) {
            this.isLowIncluded = lowIncluded;
            this.isHighIncluded = isHighIncluded;
        }

        @Override
        public boolean isBetween(Object value, Object lower, Object upper) {
            if (value == null || lower == null || upper == null) {
                return false;
            }
            String valueStr = (String)value;
            String upperStr = (String)upper;
            String lowerStr = (String)lower;
            if (upperStr.compareTo(lowerStr) < 0) {
                String temp = upperStr;
                upperStr = lowerStr;
                lowerStr = temp;
            }
            if (valueStr.compareTo(lowerStr) < 0) {
                return false;
            }
            if (valueStr.compareTo(upperStr) > 0) {
                return false;
            }
            if (!this.isLowIncluded && valueStr.equals(lowerStr)) {
                return false;
            }
            return this.isHighIncluded || !valueStr.equals(upperStr);
        }

        public boolean isEqualsEndpoint(Object value, Object endpoint) {
            return value.equals(endpoint);
        }
    }

    private static interface ExprBetweenComp {
        public boolean isBetween(Object var1, Object var2, Object var3);
    }
}

