/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.time;

import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConst;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaResult;
import com.espertech.esper.epl.expression.time.ExprTimePeriodImpl;
import java.util.Calendar;
import java.util.TimeZone;

public class ExprTimePeriodEvalDeltaConstCalAdd
implements ExprTimePeriodEvalDeltaConst {
    private final Calendar cal;
    private final ExprTimePeriodImpl.TimePeriodAdder[] adders;
    private final int[] added;

    public ExprTimePeriodEvalDeltaConstCalAdd(ExprTimePeriodImpl.TimePeriodAdder[] adders, int[] added, TimeZone timeZone) {
        this.adders = adders;
        this.added = added;
        this.cal = Calendar.getInstance(timeZone);
    }

    @Override
    public boolean equalsTimePeriod(ExprTimePeriodEvalDeltaConst otherComputation) {
        if (otherComputation instanceof ExprTimePeriodEvalDeltaConstCalAdd) {
            ExprTimePeriodEvalDeltaConstCalAdd other = (ExprTimePeriodEvalDeltaConstCalAdd)otherComputation;
            if (other.adders.length != this.adders.length) {
                return false;
            }
            for (int i = 0; i < this.adders.length; ++i) {
                if (this.added[i] == other.added[i] && this.adders[i].getClass() == other.adders[i].getClass()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized long deltaMillisecondsAdd(long fromTime) {
        this.cal.setTimeInMillis(fromTime);
        ExprTimePeriodEvalDeltaConstCalAdd.addSubtract(this.adders, this.added, this.cal, 1);
        return this.cal.getTimeInMillis() - fromTime;
    }

    @Override
    public synchronized long deltaMillisecondsSubtract(long fromTime) {
        this.cal.setTimeInMillis(fromTime);
        ExprTimePeriodEvalDeltaConstCalAdd.addSubtract(this.adders, this.added, this.cal, -1);
        return fromTime - this.cal.getTimeInMillis();
    }

    @Override
    public synchronized ExprTimePeriodEvalDeltaResult deltaMillisecondsAddWReference(long fromTime, long reference) {
        long last;
        if (reference > fromTime) {
            while (reference > fromTime) {
                reference -= this.deltaMillisecondsSubtract(reference);
            }
        }
        long next = reference;
        while ((next += this.deltaMillisecondsAdd(last = next)) <= fromTime) {
        }
        return new ExprTimePeriodEvalDeltaResult(next - fromTime, last);
    }

    private static void addSubtract(ExprTimePeriodImpl.TimePeriodAdder[] adders, int[] added, Calendar cal, int factor) {
        for (int i = 0; i < adders.length; ++i) {
            adders[i].add(cal, factor * added[i]);
        }
    }
}

