/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.join.base.HistoricalIndexLookupStrategy;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyed;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class HistoricalIndexLookupStrategyIndex
implements HistoricalIndexLookupStrategy {
    private final EventBean[] eventsPerStream;
    private final int lookupStream;
    private final ExprEvaluator[] evaluators;

    public HistoricalIndexLookupStrategyIndex(EventType eventType, int lookupStream, List<QueryGraphValueEntryHashKeyed> hashKeys) {
        this.evaluators = new ExprEvaluator[hashKeys.size()];
        for (int i = 0; i < hashKeys.size(); ++i) {
            this.evaluators[i] = hashKeys.get(i).getKeyExpr().getExprEvaluator();
        }
        this.eventsPerStream = new EventBean[lookupStream + 1];
        this.lookupStream = lookupStream;
    }

    @Override
    public Iterator<EventBean> lookup(EventBean lookupEvent, EventTable[] indexTable, ExprEvaluatorContext exprEvaluatorContext) {
        if (indexTable[0] instanceof PropertyIndexedEventTable) {
            PropertyIndexedEventTable index = (PropertyIndexedEventTable)indexTable[0];
            Object[] keys = this.getKeys(lookupEvent, exprEvaluatorContext);
            Set<EventBean> events = index.lookup(keys);
            if (events != null) {
                return events.iterator();
            }
            return null;
        }
        return indexTable[0].iterator();
    }

    private Object[] getKeys(EventBean theEvent, ExprEvaluatorContext exprEvaluatorContext) {
        this.eventsPerStream[this.lookupStream] = theEvent;
        Object[] keys = new Object[this.evaluators.length];
        for (int i = 0; i < this.evaluators.length; ++i) {
            keys[i] = this.evaluators[i].evaluate(this.eventsPerStream, true, exprEvaluatorContext);
        }
        return keys;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " evaluators " + ExprNodeUtility.printEvaluators(this.evaluators);
    }
}

