/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.base;

import java.util.SortedSet;
import java.util.TreeSet;

public class HistoricalViewableDesc {
    private boolean hasHistorical;
    private final SortedSet<Integer>[] dependenciesPerHistorical;
    private final boolean[] isHistorical;

    public HistoricalViewableDesc(int numStreams) {
        this.dependenciesPerHistorical = new SortedSet[numStreams];
        this.isHistorical = new boolean[numStreams];
    }

    public void setHistorical(int streamNum, SortedSet<Integer> dependencies) {
        this.hasHistorical = true;
        this.isHistorical[streamNum] = true;
        if (this.dependenciesPerHistorical[streamNum] != null) {
            throw new RuntimeException("Dependencies for stream " + streamNum + "already initialized");
        }
        this.dependenciesPerHistorical[streamNum] = new TreeSet<Integer>();
        if (dependencies != null) {
            this.dependenciesPerHistorical[streamNum].addAll(dependencies);
        }
    }

    public boolean isHasHistorical() {
        return this.hasHistorical;
    }

    public SortedSet<Integer>[] getDependenciesPerHistorical() {
        return this.dependenciesPerHistorical;
    }

    public boolean[] getHistorical() {
        return this.isHistorical;
    }
}

