/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.join.plan.QueryPlanIndexItem;
import com.espertech.esper.epl.join.plan.QueryPlanIndexUniqueHelper;
import com.espertech.esper.epl.join.plan.TableLookupIndexReqKey;
import com.espertech.esper.util.UuidGenerator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QueryPlanIndex {
    private Map<TableLookupIndexReqKey, QueryPlanIndexItem> items;

    public QueryPlanIndex(Map<TableLookupIndexReqKey, QueryPlanIndexItem> items) {
        if (items == null) {
            throw new IllegalArgumentException("Null value not allowed for items");
        }
        this.items = items;
    }

    public Map<TableLookupIndexReqKey, QueryPlanIndexItem> getItems() {
        return this.items;
    }

    public static QueryPlanIndex makeIndex(QueryPlanIndexItem ... items) {
        LinkedHashMap<TableLookupIndexReqKey, QueryPlanIndexItem> result = new LinkedHashMap<TableLookupIndexReqKey, QueryPlanIndexItem>();
        for (QueryPlanIndexItem item : items) {
            result.put(new TableLookupIndexReqKey(UuidGenerator.generate()), item);
        }
        return new QueryPlanIndex(result);
    }

    public static QueryPlanIndex makeIndex(List<QueryPlanIndexItem> indexesSet) {
        LinkedHashMap<TableLookupIndexReqKey, QueryPlanIndexItem> items = new LinkedHashMap<TableLookupIndexReqKey, QueryPlanIndexItem>();
        for (QueryPlanIndexItem item : indexesSet) {
            items.put(new TableLookupIndexReqKey(UuidGenerator.generate()), item);
        }
        return new QueryPlanIndex(items);
    }

    protected Pair<TableLookupIndexReqKey, int[]> getIndexNum(String[] indexProps, String[] rangeProps) {
        QueryPlanIndexItem proposed = new QueryPlanIndexItem(indexProps, null, rangeProps, null, false);
        for (Map.Entry<TableLookupIndexReqKey, QueryPlanIndexItem> entry : this.items.entrySet()) {
            if (!entry.getValue().equalsCompareSortedProps(proposed)) continue;
            return new Pair<TableLookupIndexReqKey, Object>(entry.getKey(), null);
        }
        for (Map.Entry<TableLookupIndexReqKey, QueryPlanIndexItem> entry : this.items.entrySet()) {
            int[] indexes;
            if (entry.getValue().getRangeProps() != null && entry.getValue().getRangeProps().length != 0 || (indexes = QueryPlanIndexUniqueHelper.checkSufficientGetAssignment(entry.getValue().getIndexProps(), indexProps)) == null || indexes.length == 0) continue;
            return new Pair<TableLookupIndexReqKey, int[]>(entry.getKey(), indexes);
        }
        return null;
    }

    protected TableLookupIndexReqKey getFirstIndexNum() {
        return this.items.keySet().iterator().next();
    }

    public String addIndex(String[] indexProperties, Class[] coercionTypes) {
        String uuid = UuidGenerator.generate();
        this.items.put(new TableLookupIndexReqKey(uuid), new QueryPlanIndexItem(indexProperties, coercionTypes, null, null, false));
        return uuid;
    }

    public String[][] getIndexProps() {
        String[][] arr = new String[this.items.size()][];
        int count = 0;
        for (Map.Entry<TableLookupIndexReqKey, QueryPlanIndexItem> entry : this.items.entrySet()) {
            arr[count] = entry.getValue().getIndexProps();
            ++count;
        }
        return arr;
    }

    public Class[] getCoercionTypes(String[] indexProperties) {
        for (Map.Entry<TableLookupIndexReqKey, QueryPlanIndexItem> entry : this.items.entrySet()) {
            if (!Arrays.deepEquals(entry.getValue().getIndexProps(), indexProperties)) continue;
            return entry.getValue().getOptIndexCoercionTypes();
        }
        throw new IllegalArgumentException("Index properties not found");
    }

    public void setCoercionTypes(String[] indexProperties, Class[] coercionTypes) {
        boolean found = false;
        for (Map.Entry<TableLookupIndexReqKey, QueryPlanIndexItem> entry : this.items.entrySet()) {
            if (!Arrays.deepEquals(entry.getValue().getIndexProps(), indexProperties)) continue;
            entry.getValue().setOptIndexCoercionTypes(coercionTypes);
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException("Index properties not found");
        }
    }

    public String toString() {
        if (this.items.isEmpty()) {
            return "    (none)";
        }
        StringBuilder buf = new StringBuilder();
        String delimiter = "";
        for (Map.Entry<TableLookupIndexReqKey, QueryPlanIndexItem> entry : this.items.entrySet()) {
            buf.append(delimiter);
            String info = entry.getValue() == null ? "" : " : " + entry.getValue();
            buf.append("    index " + entry.getKey() + info);
            delimiter = "\n";
        }
        return buf.toString();
    }

    public static String print(QueryPlanIndex[] indexSpecs) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("QueryPlanIndex[]\n");
        String delimiter = "";
        for (int i = 0; i < indexSpecs.length; ++i) {
            buffer.append(delimiter);
            buffer.append("  index spec stream " + i + " : \n" + (indexSpecs[i] == null ? "    null" : indexSpecs[i]));
            delimiter = "\n";
        }
        return buffer.toString() + "\n";
    }

    public static QueryPlanIndex makeIndexTableAccess(TableLookupIndexReqKey indexName) {
        HashMap<TableLookupIndexReqKey, QueryPlanIndexItem> indexMap = new HashMap<TableLookupIndexReqKey, QueryPlanIndexItem>();
        indexMap.put(indexName, null);
        return new QueryPlanIndex(indexMap);
    }
}

