/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.util.CollectionUtil;
import java.util.Arrays;

public class QueryPlanIndexItem {
    private final String[] indexProps;
    private Class[] optIndexCoercionTypes;
    private final String[] rangeProps;
    private final Class[] optRangeCoercionTypes;
    private final boolean unique;

    public QueryPlanIndexItem(String[] indexProps, Class[] optIndexCoercionTypes, String[] rangeProps, Class[] optRangeCoercionTypes, boolean unique) {
        this.indexProps = indexProps;
        this.optIndexCoercionTypes = optIndexCoercionTypes;
        this.rangeProps = rangeProps == null || rangeProps.length == 0 ? null : rangeProps;
        this.optRangeCoercionTypes = optRangeCoercionTypes;
        this.unique = unique;
        if (unique && indexProps.length == 0) {
            throw new IllegalStateException("Invalid unique index planned without hash index props");
        }
        if (unique && rangeProps.length > 0) {
            throw new IllegalStateException("Invalid unique index planned that includes range props");
        }
    }

    public String[] getIndexProps() {
        return this.indexProps;
    }

    public Class[] getOptIndexCoercionTypes() {
        return this.optIndexCoercionTypes;
    }

    public String[] getRangeProps() {
        return this.rangeProps;
    }

    public Class[] getOptRangeCoercionTypes() {
        return this.optRangeCoercionTypes;
    }

    public void setOptIndexCoercionTypes(Class[] optIndexCoercionTypes) {
        this.optIndexCoercionTypes = optIndexCoercionTypes;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public String toString() {
        return "QueryPlanIndexItem{unique=" + this.unique + ", indexProps=" + (this.indexProps == null ? null : Arrays.asList(this.indexProps)) + ", rangeProps=" + (this.rangeProps == null ? null : Arrays.asList(this.rangeProps)) + ", optIndexCoercionTypes=" + (this.optIndexCoercionTypes == null ? null : Arrays.asList(this.optIndexCoercionTypes)) + ", optRangeCoercionTypes=" + (this.optRangeCoercionTypes == null ? null : Arrays.asList(this.optRangeCoercionTypes)) + '}';
    }

    public boolean equalsCompareSortedProps(QueryPlanIndexItem other) {
        if (this.unique != other.unique) {
            return false;
        }
        String[] otherIndexProps = CollectionUtil.copySortArray(other.getIndexProps());
        String[] thisIndexProps = CollectionUtil.copySortArray(this.getIndexProps());
        String[] otherRangeProps = CollectionUtil.copySortArray(other.getRangeProps());
        String[] thisRangeProps = CollectionUtil.copySortArray(this.getRangeProps());
        return CollectionUtil.compare(otherIndexProps, thisIndexProps) && CollectionUtil.compare(otherRangeProps, thisRangeProps);
    }
}

