/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.join.plan.QueryPlanIndexItem;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableFactory;
import com.espertech.esper.epl.join.table.EventTableFactoryTableIdentAgentInstance;
import com.espertech.esper.epl.lookup.EventTableIndexService;
import com.espertech.esper.util.CollectionUtil;

public class EventTableUtil {
    public static EventTable buildIndex(AgentInstanceContext agentInstanceContext, int indexedStreamNum, QueryPlanIndexItem item, EventType eventType, boolean coerceOnAddOnly, boolean unique, String optionalIndexName, Object optionalSerde, boolean isFireAndForget) {
        EventTable table;
        String[] indexProps = item.getIndexProps();
        Class[] indexCoercionTypes = EventTableUtil.normalize(item.getOptIndexCoercionTypes());
        String[] rangeProps = item.getRangeProps();
        Class[] rangeCoercionTypes = EventTableUtil.normalize(item.getOptRangeCoercionTypes());
        EventTableFactoryTableIdentAgentInstance ident = new EventTableFactoryTableIdentAgentInstance(agentInstanceContext);
        EventTableIndexService eventTableIndexService = agentInstanceContext.getStatementContext().getEventTableIndexService();
        if (rangeProps == null || rangeProps.length == 0) {
            if (indexProps == null || indexProps.length == 0) {
                EventTableFactory factory = eventTableIndexService.createUnindexed(indexedStreamNum, optionalSerde, isFireAndForget);
                table = factory.makeEventTables(ident)[0];
            } else if (indexProps.length == 1) {
                if (indexCoercionTypes == null || indexCoercionTypes.length == 0) {
                    EventTableFactory factory = eventTableIndexService.createSingle(indexedStreamNum, eventType, indexProps[0], unique, optionalIndexName, optionalSerde, isFireAndForget);
                    table = factory.makeEventTables(ident)[0];
                } else if (coerceOnAddOnly) {
                    EventTableFactory factory = eventTableIndexService.createSingleCoerceAdd(indexedStreamNum, eventType, indexProps[0], indexCoercionTypes[0], optionalSerde, isFireAndForget);
                    table = factory.makeEventTables(ident)[0];
                } else {
                    EventTableFactory factory = eventTableIndexService.createSingleCoerceAll(indexedStreamNum, eventType, indexProps[0], indexCoercionTypes[0], optionalSerde, isFireAndForget);
                    table = factory.makeEventTables(ident)[0];
                }
            } else if (indexCoercionTypes == null || indexCoercionTypes.length == 0) {
                EventTableFactory factory = eventTableIndexService.createMultiKey(indexedStreamNum, eventType, indexProps, unique, optionalIndexName, optionalSerde, isFireAndForget);
                table = factory.makeEventTables(ident)[0];
            } else if (coerceOnAddOnly) {
                EventTableFactory factory = eventTableIndexService.createMultiKeyCoerceAdd(indexedStreamNum, eventType, indexProps, indexCoercionTypes, isFireAndForget);
                table = factory.makeEventTables(ident)[0];
            } else {
                EventTableFactory factory = eventTableIndexService.createMultiKeyCoerceAll(indexedStreamNum, eventType, indexProps, indexCoercionTypes, isFireAndForget);
                table = factory.makeEventTables(ident)[0];
            }
        } else {
            if (rangeProps.length == 1 && (indexProps == null || indexProps.length == 0)) {
                if (rangeCoercionTypes == null) {
                    EventTableFactory factory = eventTableIndexService.createSorted(indexedStreamNum, eventType, rangeProps[0], isFireAndForget);
                    return factory.makeEventTables(ident)[0];
                }
                EventTableFactory factory = eventTableIndexService.createSortedCoerce(indexedStreamNum, eventType, rangeProps[0], rangeCoercionTypes[0], isFireAndForget);
                return factory.makeEventTables(ident)[0];
            }
            EventTableFactory factory = eventTableIndexService.createComposite(indexedStreamNum, eventType, indexProps, indexCoercionTypes, rangeProps, rangeCoercionTypes, isFireAndForget);
            return factory.makeEventTables(ident)[0];
        }
        return table;
    }

    private static Class[] normalize(Class[] types) {
        if (types == null) {
            return null;
        }
        if (CollectionUtil.isAllNullArray(types)) {
            return null;
        }
        return types;
    }
}

