/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.lookup;

import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class IndexedPropDesc
implements Comparable {
    private final String indexPropName;
    private final Class coercionType;

    public IndexedPropDesc(String indexPropName, Class coercionType) {
        this.indexPropName = indexPropName;
        this.coercionType = coercionType;
    }

    public String getIndexPropName() {
        return this.indexPropName;
    }

    public Class getCoercionType() {
        return this.coercionType;
    }

    public static String[] getIndexProperties(IndexedPropDesc[] descList) {
        String[] result = new String[descList.length];
        int count = 0;
        for (IndexedPropDesc desc : descList) {
            result[count++] = desc.getIndexPropName();
        }
        return result;
    }

    public static String[] getIndexProperties(List<IndexedPropDesc> descList) {
        String[] result = new String[descList.size()];
        int count = 0;
        for (IndexedPropDesc desc : descList) {
            result[count++] = desc.getIndexPropName();
        }
        return result;
    }

    public static int getPropertyIndex(String propertyName, IndexedPropDesc[] descList) {
        for (int i = 0; i < descList.length; ++i) {
            if (!descList[i].getIndexPropName().equals(propertyName)) continue;
            return i;
        }
        return -1;
    }

    public static Class[] getCoercionTypes(IndexedPropDesc[] descList) {
        Class[] result = new Class[descList.length];
        int count = 0;
        for (IndexedPropDesc desc : descList) {
            result[count++] = desc.getCoercionType();
        }
        return result;
    }

    public int compareTo(Object o) {
        IndexedPropDesc other = (IndexedPropDesc)o;
        return this.indexPropName.compareTo(other.getIndexPropName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexedPropDesc that = (IndexedPropDesc)o;
        if (!this.coercionType.equals(that.coercionType)) {
            return false;
        }
        return this.indexPropName.equals(that.indexPropName);
    }

    public static boolean compare(List<IndexedPropDesc> first, List<IndexedPropDesc> second) {
        if (first.size() != second.size()) {
            return false;
        }
        ArrayList<IndexedPropDesc> copyFirst = new ArrayList<IndexedPropDesc>(first);
        ArrayList<IndexedPropDesc> copySecond = new ArrayList<IndexedPropDesc>(second);
        Comparator<IndexedPropDesc> comparator = new Comparator<IndexedPropDesc>(){

            @Override
            public int compare(IndexedPropDesc o1, IndexedPropDesc o2) {
                return o1.getIndexPropName().compareTo(o2.getIndexPropName());
            }
        };
        Collections.sort(copyFirst, comparator);
        Collections.sort(copySecond, comparator);
        for (int i = 0; i < copyFirst.size(); ++i) {
            if (((IndexedPropDesc)copyFirst.get(i)).equals(copySecond.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.indexPropName.hashCode();
        result = 31 * result + this.coercionType.hashCode();
        return result;
    }

    public static void toQueryPlan(StringWriter writer, IndexedPropDesc[] indexedProps) {
        String delimiter = "";
        for (IndexedPropDesc prop : indexedProps) {
            writer.write(delimiter);
            writer.write(prop.getIndexPropName());
            writer.write("(");
            writer.write(JavaClassHelper.getSimpleNameForClass(prop.getCoercionType()));
            writer.write(")");
            delimiter = ",";
        }
    }
}

