/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.lookup;

import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyedProp;
import com.espertech.esper.epl.lookup.SubordPropHashKey;
import java.util.Collection;

public class SubordPropUtil {
    public static boolean isStrictKeyJoin(Collection<SubordPropHashKey> hashKeys) {
        for (SubordPropHashKey hashKey : hashKeys) {
            if (hashKey.getHashKey() instanceof QueryGraphValueEntryHashKeyedProp) continue;
            return false;
        }
        return true;
    }

    public static int[] getKeyStreamNums(Collection<SubordPropHashKey> descList) {
        int[] streamIds = new int[descList.size()];
        int count = 0;
        for (SubordPropHashKey desc : descList) {
            if (!(desc.getHashKey() instanceof QueryGraphValueEntryHashKeyedProp)) {
                throw new UnsupportedOperationException("Not a strict key compare");
            }
            streamIds[count++] = desc.getOptionalKeyStreamNum();
        }
        return streamIds;
    }

    public static String[] getKeyProperties(Collection<SubordPropHashKey> descList) {
        String[] result = new String[descList.size()];
        int count = 0;
        for (SubordPropHashKey desc : descList) {
            if (!(desc.getHashKey() instanceof QueryGraphValueEntryHashKeyedProp)) {
                throw new UnsupportedOperationException("Not a strict key compare");
            }
            QueryGraphValueEntryHashKeyedProp keyed = (QueryGraphValueEntryHashKeyedProp)desc.getHashKey();
            result[count++] = keyed.getKeyProperty();
        }
        return result;
    }

    public static String[] getKeyProperties(SubordPropHashKey[] descList) {
        String[] result = new String[descList.length];
        int count = 0;
        for (SubordPropHashKey desc : descList) {
            if (!(desc.getHashKey() instanceof QueryGraphValueEntryHashKeyedProp)) {
                throw new UnsupportedOperationException("Not a strict key compare");
            }
            QueryGraphValueEntryHashKeyedProp keyed = (QueryGraphValueEntryHashKeyedProp)desc.getHashKey();
            result[count++] = keyed.getKeyProperty();
        }
        return result;
    }

    public static Class[] getCoercionTypes(Collection<SubordPropHashKey> descList) {
        Class[] result = new Class[descList.size()];
        int count = 0;
        for (SubordPropHashKey desc : descList) {
            result[count++] = desc.getCoercionType();
        }
        return result;
    }

    public static Class[] getCoercionTypes(SubordPropHashKey[] descList) {
        Class[] result = new Class[descList.length];
        int count = 0;
        for (SubordPropHashKey desc : descList) {
            result[count++] = desc.getCoercionType();
        }
        return result;
    }
}

