/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.ConfigurationEngineDefaults;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.epl.named.NamedWindowConsumerLatch;
import com.espertech.esper.epl.named.NamedWindowConsumerLatchNone;
import com.espertech.esper.epl.named.NamedWindowConsumerLatchSpin;
import com.espertech.esper.epl.named.NamedWindowConsumerLatchWait;
import com.espertech.esper.epl.named.NamedWindowConsumerView;
import com.espertech.esper.epl.named.NamedWindowDeltaData;
import com.espertech.esper.timer.TimeSourceService;
import java.util.List;
import java.util.Map;

public class NamedWindowConsumerLatchFactory {
    private final String name;
    private final boolean useSpin;
    private final TimeSourceService timeSourceService;
    private final long msecWait;
    private final boolean enabled;
    private NamedWindowConsumerLatchSpin currentLatchSpin;
    private NamedWindowConsumerLatchWait currentLatchWait;

    public NamedWindowConsumerLatchFactory(String name, boolean enabled, long msecWait, ConfigurationEngineDefaults.Threading.Locking locking, TimeSourceService timeSourceService) {
        this.name = name;
        this.enabled = enabled;
        this.msecWait = msecWait;
        this.timeSourceService = timeSourceService;
        boolean bl = this.useSpin = enabled && locking == ConfigurationEngineDefaults.Threading.Locking.SPIN;
        if (this.useSpin) {
            this.currentLatchSpin = new NamedWindowConsumerLatchSpin(this);
        } else if (enabled) {
            this.currentLatchWait = new NamedWindowConsumerLatchWait(this);
        }
    }

    public NamedWindowConsumerLatch newLatch(NamedWindowDeltaData delta, Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> consumers) {
        if (this.useSpin) {
            NamedWindowConsumerLatchSpin nextLatch;
            this.currentLatchSpin = nextLatch = new NamedWindowConsumerLatchSpin(delta, consumers, this, this.currentLatchSpin);
            return nextLatch;
        }
        if (this.enabled) {
            NamedWindowConsumerLatchWait nextLatch = new NamedWindowConsumerLatchWait(delta, consumers, this, this.currentLatchWait);
            this.currentLatchWait.setLater(nextLatch);
            this.currentLatchWait = nextLatch;
            return nextLatch;
        }
        return new NamedWindowConsumerLatchNone(delta, consumers);
    }

    public TimeSourceService getTimeSourceService() {
        return this.timeSourceService;
    }

    public String getName() {
        return this.name;
    }

    public long getMsecWait() {
        return this.msecWait;
    }
}

