/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.epl.named.NamedWindowConsumerLatch;
import com.espertech.esper.epl.named.NamedWindowConsumerLatchFactory;
import com.espertech.esper.epl.named.NamedWindowConsumerView;
import com.espertech.esper.epl.named.NamedWindowDeltaData;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NamedWindowConsumerLatchSpin
extends NamedWindowConsumerLatch {
    private static final Log log = LogFactory.getLog(NamedWindowConsumerLatchSpin.class);
    private NamedWindowConsumerLatchFactory factory;
    private NamedWindowConsumerLatchSpin earlier;
    private Thread currentThread;
    private volatile boolean isCompleted;

    public NamedWindowConsumerLatchSpin(NamedWindowDeltaData deltaData, Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> dispatchTo, NamedWindowConsumerLatchFactory factory, NamedWindowConsumerLatchSpin earlier) {
        super(deltaData, dispatchTo);
        this.factory = factory;
        this.earlier = earlier;
    }

    public NamedWindowConsumerLatchSpin(NamedWindowConsumerLatchFactory factory) {
        super(null, null);
        this.factory = factory;
        this.isCompleted = true;
        this.earlier = null;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    @Override
    public void await() {
        if (this.earlier.isCompleted) {
            this.currentThread = Thread.currentThread();
            return;
        }
        if (this.earlier.getCurrentThread() == Thread.currentThread()) {
            this.currentThread = Thread.currentThread();
            return;
        }
        long spinStartTime = this.factory.getTimeSourceService().getTimeMillis();
        while (!this.earlier.isCompleted) {
            Thread.yield();
            long spinDelta = this.factory.getTimeSourceService().getTimeMillis() - spinStartTime;
            if (spinDelta <= this.factory.getMsecWait()) continue;
            log.info((Object)("Spin wait timeout exceeded in named window '" + this.factory.getName() + "' consumer dispatch at " + this.factory.getMsecWait() + "ms for " + this.factory.getName() + ", consider disabling named window consumer dispatch latching for better performance"));
            break;
        }
    }

    @Override
    public Thread getCurrentThread() {
        return this.currentThread;
    }

    @Override
    public void done() {
        this.isCompleted = true;
        this.earlier = null;
    }
}

