/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.ConfigurationEngineDefaults;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.StatementResultService;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.named.NamedWindowConsumerCallback;
import com.espertech.esper.epl.named.NamedWindowConsumerDesc;
import com.espertech.esper.epl.named.NamedWindowConsumerLatchFactory;
import com.espertech.esper.epl.named.NamedWindowConsumerView;
import com.espertech.esper.epl.named.NamedWindowDeltaData;
import com.espertech.esper.epl.named.NamedWindowDispatchService;
import com.espertech.esper.epl.named.NamedWindowMgmtService;
import com.espertech.esper.epl.named.NamedWindowUtil;
import com.espertech.esper.event.vaevent.ValueAddEventProcessor;
import com.espertech.esper.timer.TimeSourceService;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class NamedWindowTailView {
    private final EventType eventType;
    private final NamedWindowMgmtService namedWindowMgmtService;
    private final NamedWindowDispatchService namedWindowDispatchService;
    private final StatementResultService statementResultService;
    private final ValueAddEventProcessor revisionProcessor;
    private final boolean isPrioritized;
    private final boolean isParentBatchWindow;
    private volatile Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> consumersNonContext;
    private final NamedWindowConsumerLatchFactory latchFactory;

    public NamedWindowTailView(EventType eventType, NamedWindowMgmtService namedWindowMgmtService, NamedWindowDispatchService namedWindowDispatchService, StatementResultService statementResultService, ValueAddEventProcessor revisionProcessor, boolean prioritized, boolean parentBatchWindow, TimeSourceService timeSourceService, ConfigurationEngineDefaults.Threading threadingConfig) {
        this.eventType = eventType;
        this.namedWindowMgmtService = namedWindowMgmtService;
        this.namedWindowDispatchService = namedWindowDispatchService;
        this.statementResultService = statementResultService;
        this.revisionProcessor = revisionProcessor;
        this.isPrioritized = prioritized;
        this.isParentBatchWindow = parentBatchWindow;
        this.consumersNonContext = NamedWindowUtil.createConsumerMap(this.isPrioritized);
        this.latchFactory = new NamedWindowConsumerLatchFactory(eventType.getName(), threadingConfig.isNamedWindowConsumerDispatchPreserveOrder(), threadingConfig.getNamedWindowConsumerDispatchTimeout(), threadingConfig.getNamedWindowConsumerDispatchLocking(), timeSourceService);
    }

    public boolean isParentBatchWindow() {
        return this.isParentBatchWindow;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public StatementResultService getStatementResultService() {
        return this.statementResultService;
    }

    public NamedWindowMgmtService getNamedWindowMgmtService() {
        return this.namedWindowMgmtService;
    }

    public NamedWindowDispatchService getNamedWindowDispatchService() {
        return this.namedWindowDispatchService;
    }

    public boolean isPrioritized() {
        return this.isPrioritized;
    }

    public ValueAddEventProcessor getRevisionProcessor() {
        return this.revisionProcessor;
    }

    public Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> getConsumersNonContext() {
        return this.consumersNonContext;
    }

    public NamedWindowConsumerView addConsumer(NamedWindowConsumerDesc consumerDesc) {
        NamedWindowConsumerCallback consumerCallback = new NamedWindowConsumerCallback(){

            @Override
            public Iterator<EventBean> getIterator() {
                throw new UnsupportedOperationException("Iterator not supported on named windows that have a context attached and when that context is not the same as the consuming statement's context");
            }

            @Override
            public void stopped(NamedWindowConsumerView namedWindowConsumerView) {
                NamedWindowTailView.this.removeConsumer(namedWindowConsumerView);
            }
        };
        boolean audit = AuditEnum.STREAM.getAudit(consumerDesc.getAgentInstanceContext().getStatementContext().getAnnotations()) != null;
        NamedWindowConsumerView consumerView = new NamedWindowConsumerView(ExprNodeUtility.getEvaluators(consumerDesc.getFilterList()), consumerDesc.getOptPropertyEvaluator(), this.eventType, consumerCallback, consumerDesc.getAgentInstanceContext(), audit);
        List<NamedWindowConsumerView> viewsPerStatements = this.consumersNonContext.get(consumerDesc.getAgentInstanceContext().getEpStatementAgentInstanceHandle());
        if (viewsPerStatements == null) {
            viewsPerStatements = new CopyOnWriteArrayList<NamedWindowConsumerView>();
            Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> newConsumers = NamedWindowUtil.createConsumerMap(this.isPrioritized);
            newConsumers.putAll(this.consumersNonContext);
            newConsumers.put(consumerDesc.getAgentInstanceContext().getEpStatementAgentInstanceHandle(), viewsPerStatements);
            this.consumersNonContext = newConsumers;
        }
        viewsPerStatements.add(consumerView);
        return consumerView;
    }

    public void removeConsumer(NamedWindowConsumerView namedWindowConsumerView) {
        EPStatementAgentInstanceHandle handleRemoved = null;
        for (Map.Entry<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> entry : this.consumersNonContext.entrySet()) {
            boolean foundAndRemoved = entry.getValue().remove(namedWindowConsumerView);
            if (!foundAndRemoved || entry.getValue().size() != 0) continue;
            handleRemoved = entry.getKey();
            break;
        }
        if (handleRemoved != null) {
            Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> newConsumers = NamedWindowUtil.createConsumerMap(this.isPrioritized);
            newConsumers.putAll(this.consumersNonContext);
            newConsumers.remove(handleRemoved);
            this.consumersNonContext = newConsumers;
        }
    }

    public void addDispatches(Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> consumersInContext, NamedWindowDeltaData delta, AgentInstanceContext agentInstanceContext) {
        if (!consumersInContext.isEmpty()) {
            this.namedWindowDispatchService.addDispatch(this.latchFactory, delta, consumersInContext);
        }
        if (!this.consumersNonContext.isEmpty()) {
            this.namedWindowDispatchService.addDispatch(this.latchFactory, delta, this.consumersNonContext);
        }
    }
}

