/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.generated.EsperEPL2GrammarParser;
import com.espertech.esper.epl.parse.ASTConstantHelper;
import com.espertech.esper.epl.parse.ASTWalkException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RuleContext;

public class ASTJsonHelper {
    public static Object walk(CommonTokenStream tokenStream, EsperEPL2GrammarParser.JsonvalueContext node) throws ASTWalkException {
        if (node.constant() != null) {
            EsperEPL2GrammarParser.ConstantContext constCtx = node.constant();
            if (constCtx.stringconstant() != null) {
                return ASTJsonHelper.extractString(constCtx.stringconstant().getText());
            }
            return ASTConstantHelper.parse(constCtx.getChild(0));
        }
        if (node.jsonobject() != null) {
            return ASTJsonHelper.walkObject(tokenStream, node.jsonobject());
        }
        if (node.jsonarray() != null) {
            return ASTJsonHelper.walkArray(tokenStream, node.jsonarray());
        }
        throw ASTWalkException.from("Encountered unexpected node type in json tree", tokenStream, (RuleContext)node);
    }

    public static Map<String, Object> walkObject(CommonTokenStream tokenStream, EsperEPL2GrammarParser.JsonobjectContext ctx) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        List<EsperEPL2GrammarParser.JsonpairContext> pairs = ctx.jsonmembers().jsonpair();
        for (EsperEPL2GrammarParser.JsonpairContext pair : pairs) {
            Pair<String, Object> value = ASTJsonHelper.walkJSONField(tokenStream, pair);
            map.put(value.getFirst(), value.getSecond());
        }
        return map;
    }

    public static List<Object> walkArray(CommonTokenStream tokenStream, EsperEPL2GrammarParser.JsonarrayContext ctx) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (ctx.jsonelements() == null) {
            return list;
        }
        List<EsperEPL2GrammarParser.JsonvalueContext> values = ctx.jsonelements().jsonvalue();
        for (EsperEPL2GrammarParser.JsonvalueContext value : values) {
            Object val = ASTJsonHelper.walk(tokenStream, value);
            list.add(val);
        }
        return list;
    }

    private static Pair<String, Object> walkJSONField(CommonTokenStream tokenStream, EsperEPL2GrammarParser.JsonpairContext ctx) {
        String label = ctx.stringconstant() != null ? ASTJsonHelper.extractString(ctx.stringconstant().getText()) : ctx.keywordAllowedIdent().getText();
        Object value = ASTJsonHelper.walk(tokenStream, ctx.jsonvalue());
        return new Pair<String, Object>(label, value);
    }

    private static String extractString(String text) {
        int slashIndex;
        StringBuffer sb = new StringBuffer(text);
        int startPoint = 1;
        while ((slashIndex = sb.indexOf("\\", startPoint)) != -1) {
            char escapeType = sb.charAt(slashIndex + 1);
            switch (escapeType) {
                case 'u': {
                    String unicode = ASTJsonHelper.extractUnicode(sb, slashIndex);
                    sb.replace(slashIndex, slashIndex + 6, unicode);
                    break;
                }
                case 'b': {
                    sb.replace(slashIndex, slashIndex + 2, "\b");
                    break;
                }
                case 't': {
                    sb.replace(slashIndex, slashIndex + 2, "\t");
                    break;
                }
                case 'n': {
                    sb.replace(slashIndex, slashIndex + 2, "\n");
                    break;
                }
                case 'f': {
                    sb.replace(slashIndex, slashIndex + 2, "\f");
                    break;
                }
                case 'r': {
                    sb.replace(slashIndex, slashIndex + 2, "\r");
                    break;
                }
                case '\'': {
                    sb.replace(slashIndex, slashIndex + 2, "'");
                    break;
                }
                case '\"': {
                    sb.replace(slashIndex, slashIndex + 2, "\"");
                    break;
                }
                case '\\': {
                    sb.replace(slashIndex, slashIndex + 2, "\\");
                    break;
                }
                case '/': {
                    sb.replace(slashIndex, slashIndex + 2, "/");
                    break;
                }
            }
            startPoint = slashIndex + 1;
        }
        sb.deleteCharAt(0);
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private static String extractUnicode(StringBuffer sb, int slashIndex) {
        String result;
        String code = sb.substring(slashIndex + 2, slashIndex + 6);
        int charNum = Integer.parseInt(code, 16);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            osw.write(charNum);
            osw.flush();
            result = baos.toString("UTF-8");
        }
        catch (Exception e) {
            throw ASTWalkException.from("Failed to obtain for unicode '" + charNum + "'", e);
        }
        return result;
    }
}

