/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.property;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.property.PropertyEvaluator;
import com.espertech.esper.epl.property.PropertyEvaluatorAccumulative;
import java.util.ArrayDeque;

public class PropertyEvaluatorSelect
implements PropertyEvaluator {
    private final SelectExprProcessor selectExprProcessor;
    private final PropertyEvaluatorAccumulative accumulative;

    public PropertyEvaluatorSelect(SelectExprProcessor selectExprProcessor, PropertyEvaluatorAccumulative accumulative) {
        this.selectExprProcessor = selectExprProcessor;
        this.accumulative = accumulative;
    }

    @Override
    public EventBean[] getProperty(EventBean theEvent, ExprEvaluatorContext exprEvaluatorContext) {
        ArrayDeque<EventBean[]> rows = this.accumulative.getAccumulative(theEvent, exprEvaluatorContext);
        if (rows == null || rows.isEmpty()) {
            return null;
        }
        ArrayDeque<EventBean> result = new ArrayDeque<EventBean>();
        for (EventBean[] row : rows) {
            EventBean bean = this.selectExprProcessor.process(row, true, false, exprEvaluatorContext);
            result.add(bean);
        }
        return result.toArray(new EventBean[result.size()]);
    }

    @Override
    public EventType getFragmentEventType() {
        return this.selectExprProcessor.getResultEventType();
    }

    @Override
    public boolean compareTo(PropertyEvaluator otherFilterPropertyEval) {
        return false;
    }
}

