/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.script;

import com.espertech.esper.client.hook.EPLScriptContext;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeInnerNodeProvider;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.script.ExprNodeScriptEvalJSR223;
import com.espertech.esper.epl.script.ExprNodeScriptEvalMVEL;
import com.espertech.esper.epl.script.jsr223.ExpressionScriptCompiledJSR223;
import com.espertech.esper.epl.script.jsr223.JSR223Helper;
import com.espertech.esper.epl.script.mvel.ExpressionScriptCompiledMVEL;
import com.espertech.esper.epl.script.mvel.MVELHelper;
import com.espertech.esper.epl.spec.ExpressionScriptCompiled;
import com.espertech.esper.epl.spec.ExpressionScriptProvided;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.script.CompiledScript;

public class ExprNodeScript
extends ExprNodeBase
implements ExprNodeInnerNodeProvider {
    private static final long serialVersionUID = 2661218104424440161L;
    public static final String CONTEXT_BINDING_NAME = "epl";
    private final String defaultDialect;
    private final ExpressionScriptProvided script;
    private final List<ExprNode> parameters;
    private transient ExprEvaluator evaluator;

    public ExprNodeScript(String defaultDialect, ExpressionScriptProvided script, List<ExprNode> parameters) {
        this.defaultDialect = defaultDialect;
        this.script = script;
        this.parameters = parameters;
    }

    @Override
    public List<ExprNode> getAdditionalNodes() {
        return this.parameters;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this.evaluator;
    }

    public List<ExprNode> getParameters() {
        return this.parameters;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append(this.script.getName());
        ExprNodeUtility.toExpressionStringIncludeParen(this.parameters, writer);
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    public ExpressionScriptProvided getScript() {
        return this.script;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (this == node) {
            return true;
        }
        if (node == null || this.getClass() != node.getClass()) {
            return false;
        }
        ExprNodeScript that = (ExprNodeScript)node;
        if (this.script != null ? !this.script.equals(that.script) : that.script != null) {
            return false;
        }
        return ExprNodeUtility.deepEquals(this.parameters, that.parameters);
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        Class returnType;
        if (this.evaluator != null) {
            return null;
        }
        if (this.script.getParameterNames().size() != this.parameters.size()) {
            throw new ExprValidationException("Invalid number of parameters for script '" + this.script.getName() + "', expected " + this.script.getParameterNames().size() + " parameters but received " + this.parameters.size() + " parameters");
        }
        ArrayList<ExprNode> validatedParameters = new ArrayList<ExprNode>();
        for (ExprNode expr : this.parameters) {
            validatedParameters.add(ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.SCRIPTPARAMS, expr, validationContext));
        }
        String[] inputParamNames = new String[this.script.getParameterNames().size()];
        ExprEvaluator[] evaluators = new ExprEvaluator[this.script.getParameterNames().size()];
        for (int i = 0; i < this.script.getParameterNames().size(); ++i) {
            inputParamNames[i] = this.script.getParameterNames().get(i);
            evaluators[i] = ((ExprNode)validatedParameters.get(i)).getExprEvaluator();
        }
        if (this.script.getCompiled() == null) {
            this.compileScript(evaluators);
        }
        Class declaredReturnType = this.getDeclaredReturnType(this.script.getOptionalReturnTypeName(), validationContext);
        if (this.script.isOptionalReturnTypeIsArray() && declaredReturnType != null) {
            declaredReturnType = JavaClassHelper.getArrayType(declaredReturnType);
        }
        if (this.script.getCompiled().getKnownReturnType() == null && this.script.getOptionalReturnTypeName() == null) {
            returnType = Object.class;
        } else if (this.script.getCompiled().getKnownReturnType() != null) {
            if (declaredReturnType == null) {
                returnType = this.script.getCompiled().getKnownReturnType();
            } else {
                Class knownReturnType = this.script.getCompiled().getKnownReturnType();
                if (!(declaredReturnType.isArray() && knownReturnType.isArray() || JavaClassHelper.isAssignmentCompatible(knownReturnType, declaredReturnType))) {
                    throw new ExprValidationException("Return type and declared type not compatible for script '" + this.script.getName() + "', known return type is " + knownReturnType.getName() + " versus declared return type " + declaredReturnType.getName());
                }
                returnType = declaredReturnType;
            }
        } else {
            returnType = declaredReturnType;
        }
        if (returnType == null) {
            returnType = Object.class;
        }
        this.prepareEvaluator(validationContext.getStatementName(), inputParamNames, evaluators, returnType);
        return null;
    }

    private void compileScript(ExprEvaluator[] evaluators) throws ExprValidationException {
        ExpressionScriptCompiled compiled;
        String dialect;
        String string = dialect = this.script.getOptionalDialect() == null ? this.defaultDialect : this.script.getOptionalDialect();
        if (dialect.toLowerCase().trim().equals("mvel")) {
            HashMap<String, Class> mvelInputParamTypes = new HashMap<String, Class>();
            for (int i = 0; i < this.script.getParameterNames().size(); ++i) {
                String mvelParamName = this.script.getParameterNames().get(i);
                mvelInputParamTypes.put(mvelParamName, evaluators[i].getType());
            }
            mvelInputParamTypes.put(CONTEXT_BINDING_NAME, EPLScriptContext.class);
            compiled = MVELHelper.compile(this.script.getName(), this.script.getExpression(), mvelInputParamTypes);
        } else {
            CompiledScript compiledScript = JSR223Helper.verifyCompileScript(this.script, dialect);
            compiled = new ExpressionScriptCompiledJSR223(compiledScript);
        }
        this.script.setCompiled(compiled);
    }

    private void prepareEvaluator(String statementName, String[] inputParamNames, ExprEvaluator[] evaluators, Class returnType) {
        if (this.script.getCompiled() instanceof ExpressionScriptCompiledMVEL) {
            ExpressionScriptCompiledMVEL mvel = (ExpressionScriptCompiledMVEL)this.script.getCompiled();
            this.evaluator = new ExprNodeScriptEvalMVEL(this.script.getName(), statementName, inputParamNames, evaluators, returnType, mvel.getCompiled());
        } else {
            ExpressionScriptCompiledJSR223 jsr223 = (ExpressionScriptCompiledJSR223)this.script.getCompiled();
            this.evaluator = new ExprNodeScriptEvalJSR223(this.script.getName(), statementName, inputParamNames, evaluators, returnType, jsr223.getCompiled());
        }
    }

    private Class getDeclaredReturnType(String returnTypeName, ExprValidationContext validationContext) throws ExprValidationException {
        if (returnTypeName == null) {
            return null;
        }
        if (returnTypeName.equals("void")) {
            return null;
        }
        Class returnType = JavaClassHelper.getClassForSimpleName(returnTypeName);
        if (returnType != null) {
            return returnType;
        }
        try {
            return validationContext.getMethodResolutionService().resolveClass(returnTypeName, false);
        }
        catch (EngineImportException e1) {
            throw new ExprValidationException("Failed to resolve return type '" + returnTypeName + "' specified for script '" + this.script.getName() + "'");
        }
    }
}

